/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.util;

import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.ability.bravery.BraveryBoost;
import com.pulsar.soulforge.ability.bravery.ValiantHeart;
import com.pulsar.soulforge.ability.determination.DeterminationDome;
import com.pulsar.soulforge.ability.duals.AcceleratedPelletAura;
import com.pulsar.soulforge.ability.duals.Armory;
import com.pulsar.soulforge.ability.duals.FearlessInstincts;
import com.pulsar.soulforge.ability.duals.FriendlinessPellets;
import com.pulsar.soulforge.ability.duals.HestiasHearth;
import com.pulsar.soulforge.ability.duals.LightningRod;
import com.pulsar.soulforge.ability.duals.PerfectedAuraTechnique;
import com.pulsar.soulforge.ability.duals.Reload;
import com.pulsar.soulforge.ability.duals.ShiningSoul;
import com.pulsar.soulforge.ability.duals.StatusInversion;
import com.pulsar.soulforge.ability.duals.Stockpile;
import com.pulsar.soulforge.ability.duals.Ward;
import com.pulsar.soulforge.ability.duals.WarpPortal;
import com.pulsar.soulforge.ability.duals.Wormhole;
import com.pulsar.soulforge.ability.duals.YourShield;
import com.pulsar.soulforge.ability.integrity.RepulsionField;
import com.pulsar.soulforge.ability.justice.JusticeBow;
import com.pulsar.soulforge.ability.justice.JusticeCrossbow;
import com.pulsar.soulforge.ability.justice.JusticeRevolver;
import com.pulsar.soulforge.ability.justice.Launch;
import com.pulsar.soulforge.ability.kindness.Immobilization;
import com.pulsar.soulforge.ability.kindness.KindnessDome;
import com.pulsar.soulforge.ability.perseverance.MorphingWeaponry;
import com.pulsar.soulforge.ability.perseverance.PerseveranceAura;
import com.pulsar.soulforge.ability.pures.AngelsTempest;
import com.pulsar.soulforge.ability.pures.BFRCMG;
import com.pulsar.soulforge.ability.pures.BoogieWoogie;
import com.pulsar.soulforge.ability.pures.MartyrsTouch;
import com.pulsar.soulforge.ability.pures.ResplendentPhoenix;
import com.pulsar.soulforge.effects.SoulForgeEffects;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;

public class Constants {
    public static List<String> hostiles = new ArrayList<String>(List.of("blaze", "creeper", "cave_spider", "drowned", "elder_guardian", "ender_dragon", "enderman", "endermite", "evoker", "ghast", "guardian", "hoglin", "husk", "magma_cube", "phantom", "piglin", "piglin_brute", "pillager", "polar_bear", "ravager", "shulker", "silverfish", "skeleton", "slime", "spider", "stray", "vex", "vindicator", "warden", "witch", "wither", "wither_skeleton", "zoglin", "zombie", "zombie_villager", "zombified_piglin"));
    public static List<AbilityBase> endsOnDisconnect = new ArrayList<DeterminationDome>(List.of(new Immobilization(), new KindnessDome(), new DeterminationDome()));
    public static HashMap<class_1299<?>, class_1792> essenceDrops = new HashMap(Map.ofEntries(Map.entry(class_1299.field_6099, SoulForgeItems.BRAVERY_ESSENCE), Map.entry(class_1299.field_23214, SoulForgeItems.BRAVERY_ESSENCE), Map.entry(class_1299.field_6118, SoulForgeItems.JUSTICE_ESSENCE), Map.entry(class_1299.field_28315, SoulForgeItems.JUSTICE_ESSENCE), Map.entry(class_1299.field_6147, SoulForgeItems.KINDNESS_ESSENCE), Map.entry(class_1299.field_6113, SoulForgeItems.KINDNESS_ESSENCE), Map.entry(class_1299.field_6125, SoulForgeItems.PATIENCE_ESSENCE), Map.entry(class_1299.field_6047, SoulForgeItems.PATIENCE_ESSENCE), Map.entry(class_1299.field_6059, SoulForgeItems.INTEGRITY_ESSENCE), Map.entry(class_1299.field_38384, SoulForgeItems.INTEGRITY_ESSENCE), Map.entry(class_1299.field_22281, SoulForgeItems.PERSEVERANCE_ESSENCE), Map.entry(class_1299.field_42622, SoulForgeItems.PERSEVERANCE_ESSENCE)));
    public static HashMap<class_1291, class_1291> effectInversion = new HashMap(Map.ofEntries(Map.entry(class_1294.field_5904, class_1294.field_5909), Map.entry(class_1294.field_5909, class_1294.field_5904), Map.entry(class_1294.field_5900, class_1294.field_5909), Map.entry(class_1294.field_5910, class_1294.field_5911), Map.entry(class_1294.field_5911, class_1294.field_5910), Map.entry(class_1294.field_5924, class_1294.field_5899), Map.entry(class_1294.field_5899, class_1294.field_5924), Map.entry(class_1294.field_5920, class_1294.field_5924), Map.entry(SoulForgeEffects.VULNERABILITY, class_1294.field_5907), Map.entry(class_1294.field_5907, SoulForgeEffects.VULNERABILITY), Map.entry(class_1294.field_5926, class_1294.field_5908), Map.entry(class_1294.field_5903, class_1294.field_5922), Map.entry(class_1294.field_5922, class_1294.field_5903), Map.entry(class_1294.field_5917, class_1294.field_5901), Map.entry(class_1294.field_5901, class_1294.field_5917), Map.entry(class_1294.field_5912, class_1294.field_5905), Map.entry(class_1294.field_5905, class_1294.field_5912), Map.entry(class_1294.field_5913, class_1294.field_5906), Map.entry(class_1294.field_5906, class_1294.field_5902), Map.entry(class_1294.field_5902, class_1294.field_5906), Map.entry(class_1294.field_5925, class_1294.field_38092), Map.entry(class_1294.field_38092, class_1294.field_5925), Map.entry(class_1294.field_5919, class_1294.field_5925), Map.entry(SoulForgeEffects.CRUSHED, class_1294.field_5907), Map.entry(SoulForgeEffects.EEPY, class_1294.field_5925), Map.entry(SoulForgeEffects.FROSTBITE, class_1294.field_5918), Map.entry(SoulForgeEffects.MANA_OVERLOAD, SoulForgeEffects.MANA_SICKNESS), Map.entry(SoulForgeEffects.MANA_SICKNESS, SoulForgeEffects.MANA_OVERLOAD)));
    public static HashMap<class_1291, Integer> effectHighest = new HashMap(Map.ofEntries(Map.entry(class_1294.field_5898, 3), Map.entry(class_1294.field_16595, 4), Map.entry(class_1294.field_5919, 0), Map.entry(class_1294.field_5927, 0), Map.entry(class_1294.field_38092, 0), Map.entry(class_1294.field_5900, 2), Map.entry(class_1294.field_5918, 0), Map.entry(class_1294.field_5912, 0), Map.entry(class_1294.field_5917, 1), Map.entry(class_1294.field_5914, 0), Map.entry(class_1294.field_18980, 0), Map.entry(class_1294.field_5903, 0), Map.entry(class_1294.field_5921, 15), Map.entry(class_1294.field_5915, 82), Map.entry(class_1294.field_5905, 0), Map.entry(class_1294.field_5913, 1), Map.entry(class_1294.field_5902, 0), Map.entry(class_1294.field_5926, 69), Map.entry(class_1294.field_5901, 2), Map.entry(class_1294.field_5916, 0), Map.entry(class_1294.field_5925, 0), Map.entry(class_1294.field_5899, 3), Map.entry(class_1294.field_5924, 1), Map.entry(class_1294.field_5907, 3), Map.entry(class_1294.field_5922, 0), Map.entry(class_1294.field_5906, 1), Map.entry(class_1294.field_5909, 5), Map.entry(class_1294.field_5904, 1), Map.entry(class_1294.field_5910, 1), Map.entry(class_1294.field_5908, -1), Map.entry(class_1294.field_5923, 0), Map.entry(class_1294.field_5911, 0), Map.entry(class_1294.field_5920, 1)));
    public static HashMap<TraitBase, AbilityBase> pureAbilities = new HashMap(Map.ofEntries(Map.entry(Traits.patience, new AngelsTempest()), Map.entry(Traits.kindness, new MartyrsTouch()), Map.entry(Traits.bravery, new ResplendentPhoenix()), Map.entry(Traits.justice, new BFRCMG()), Map.entry(Traits.integrity, new BoogieWoogie()), Map.entry(Traits.anxiety, new AngelsTempest()), Map.entry(Traits.misery, new MartyrsTouch()), Map.entry(Traits.fear, new ResplendentPhoenix()), Map.entry(Traits.ineptitude, new BFRCMG()), Map.entry(Traits.paranoia, new BoogieWoogie())));
    public static List<AbilityBase> dualAbilities = new ArrayList<AbilityBase>(List.of(new AcceleratedPelletAura(), new Armory(), new FearlessInstincts(), new FriendlinessPellets(), new HestiasHearth(), new LightningRod(), new Ward(), new PerfectedAuraTechnique(), new Reload(), new ShiningSoul(), new StatusInversion(), new Stockpile(), new WarpPortal(), new Wormhole(), new YourShield()));

    public static void invertStatusEffects(class_1309 entity, float durationModifier, float amplifierModifier) {
        Collection effects = entity.method_6026();
        ArrayList<class_1293> newEffects = new ArrayList<class_1293>();
        if (entity.method_20802() > 0) {
            entity.method_6092(new class_1293(class_1294.field_5918, (int)((float)entity.method_20802() * amplifierModifier), 0));
        }
        for (class_1293 effect : effects) {
            class_1291 effectType = effect.method_5579();
            if (effectInversion.containsKey(effect.method_5579())) {
                effectType = effectInversion.get(effectType);
            }
            newEffects.add(new class_1293(effectType, (int)((float)effect.method_5584() * durationModifier), (int)((float)effect.method_5578() * amplifierModifier)));
        }
        entity.method_6012();
        for (class_1293 effect : newEffects) {
            entity.method_6092(effect);
        }
    }

    public static void invertStatusEffects(class_1309 entity, float durationModifier) {
        Constants.invertStatusEffects(entity, durationModifier, 1.0f);
    }

    public static void invertStatusEffects(class_1309 entity) {
        Constants.invertStatusEffects(entity, 1.0f, 1.0f);
    }

    public static boolean isAllowedForDualTrait(AbilityBase ability, List<TraitBase> traits, int lv) {
        boolean perseverance;
        boolean bravery = traits.contains(Traits.bravery) || traits.contains(Traits.fear);
        boolean justice = traits.contains(Traits.justice) || traits.contains(Traits.ineptitude);
        boolean kindness = traits.contains(Traits.kindness) || traits.contains(Traits.misery);
        boolean patience = traits.contains(Traits.patience) || traits.contains(Traits.anxiety);
        boolean integrity = traits.contains(Traits.integrity) || traits.contains(Traits.paranoia);
        boolean bl = perseverance = traits.contains(Traits.perseverance) || traits.contains(Traits.despair);
        if (bravery && integrity) {
            return !(ability instanceof BraveryBoost) && (!(ability instanceof RepulsionField) || lv < 15);
        }
        if (bravery && patience) {
            return !(ability instanceof ValiantHeart);
        }
        if (bravery && perseverance) {
            return !(ability instanceof BraveryBoost) && !(ability instanceof PerseveranceAura) && !(ability instanceof ValiantHeart);
        }
        if (justice && integrity) {
            return (!(ability instanceof RepulsionField) || lv < 15) && !(ability instanceof Launch);
        }
        if (justice && perseverance) {
            return !(ability instanceof JusticeBow) && !(ability instanceof JusticeCrossbow) && !(ability instanceof JusticeRevolver) && !(ability instanceof MorphingWeaponry);
        }
        return true;
    }

    public static List<AbilityBase> getDualTraitAbilities(List<TraitBase> traits) {
        boolean perseverance;
        ArrayList<AbilityBase> extras = new ArrayList<AbilityBase>();
        boolean bravery = traits.contains(Traits.bravery) || traits.contains(Traits.fear) || traits.contains(Traits.spite);
        boolean justice = traits.contains(Traits.justice) || traits.contains(Traits.ineptitude) || traits.contains(Traits.spite);
        boolean kindness = traits.contains(Traits.kindness) || traits.contains(Traits.misery) || traits.contains(Traits.spite);
        boolean patience = traits.contains(Traits.patience) || traits.contains(Traits.anxiety) || traits.contains(Traits.spite);
        boolean integrity = traits.contains(Traits.integrity) || traits.contains(Traits.paranoia) || traits.contains(Traits.spite);
        boolean bl = perseverance = traits.contains(Traits.perseverance) || traits.contains(Traits.despair) || traits.contains(Traits.spite);
        if (bravery && justice) {
            extras.add(new LightningRod());
        }
        if (bravery && kindness) {
            extras.add(new HestiasHearth());
        }
        if (bravery && patience) {
            extras.add(new ShiningSoul());
        }
        if (bravery && integrity) {
            extras.add(new FearlessInstincts());
        }
        if (bravery && perseverance) {
            extras.add(new PerfectedAuraTechnique());
            extras.add(new Stockpile());
        }
        if (justice && kindness) {
            extras.add(new FriendlinessPellets());
        }
        if (justice && patience) {
            extras.add(new Reload());
        }
        if (justice && integrity) {
            extras.add(new AcceleratedPelletAura());
        }
        if (justice && perseverance) {
            extras.add(new Armory());
        }
        if (kindness && patience) {
            extras.add(new StatusInversion());
        }
        if (kindness && perseverance) {
            extras.add(new Ward());
            extras.add(new YourShield());
        }
        if (patience && integrity) {
            extras.add(new Wormhole());
            extras.add(new WarpPortal());
        }
        return extras;
    }
}

