/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.util;

import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3545;

public class ResetData {
    public int totalResets;
    public int resetsSincePure;
    public int resetsSinceStrong;
    public int resetsSinceDual;
    public int resetsSinceDT;
    public boolean bravery;
    public boolean justice;
    public boolean kindness;
    public boolean patience;
    public boolean integrity;
    public boolean perseverance;
    public boolean determination;
    public boolean strongDual;
    public boolean setFirst;
    public List<class_3545<TraitBase, TraitBase>> unlockedDuals;
    public List<TraitBase> unlockedPures;

    public ResetData(int totalResets, int resetsSincePure, int resetsSinceStrong, int resetsSinceDual, int resetsSinceDT, boolean setFirst, List<class_3545<TraitBase, TraitBase>> unlockedDuals, List<TraitBase> unlockedPures) {
        this.totalResets = totalResets;
        this.resetsSincePure = resetsSincePure;
        this.resetsSinceStrong = resetsSinceStrong;
        this.resetsSinceDual = resetsSinceDual;
        this.resetsSinceDT = resetsSinceDT;
        this.setFirst = setFirst;
        this.unlockedDuals = unlockedDuals;
        this.unlockedPures = unlockedPures;
    }

    public ResetData() {
        this.totalResets = 0;
        this.resetsSincePure = 0;
        this.resetsSinceStrong = 0;
        this.resetsSinceDual = 0;
        this.resetsSinceDT = 0;
        this.setFirst = false;
        this.unlockedDuals = new ArrayList<class_3545<TraitBase, TraitBase>>();
        this.unlockedPures = new ArrayList<TraitBase>();
    }

    public ResetData(class_2487 nbt) {
        this.totalResets = nbt.method_10550("total");
        this.resetsSincePure = nbt.method_10550("pure");
        this.resetsSinceStrong = nbt.method_10550("strong");
        this.resetsSinceDual = nbt.method_10550("dual");
        this.resetsSinceDT = nbt.method_10550("determination");
        class_2487 achieved = nbt.method_10562("achieved");
        this.bravery = achieved.method_10577("bravery");
        this.justice = achieved.method_10577("justice");
        this.kindness = achieved.method_10577("kindness");
        this.patience = achieved.method_10577("patience");
        this.integrity = achieved.method_10577("integrity");
        this.perseverance = achieved.method_10577("perseverance");
        this.determination = achieved.method_10577("determination");
        this.strongDual = achieved.method_10577("strongDual");
        this.setFirst = nbt.method_10577("setFirst");
        this.unlockedDuals = new ArrayList<class_3545<TraitBase, TraitBase>>();
        class_2499 duals = nbt.method_10554("duals", 10);
        for (int i = 0; i < duals.size(); ++i) {
            class_2487 dual = duals.method_10602(i);
            TraitBase trait1 = Traits.get(dual.method_10558("trait1"));
            TraitBase trait2 = Traits.get(dual.method_10558("trait2"));
            if (trait1 == null || trait2 == null) continue;
            this.unlockedDuals.add((class_3545<TraitBase, TraitBase>)new class_3545((Object)trait1, (Object)trait2));
        }
        this.unlockedPures = new ArrayList<TraitBase>();
        class_2499 pures = nbt.method_10554("pures", 8);
        for (int i = 0; i < pures.size(); ++i) {
            String pure = pures.method_10608(i);
            TraitBase trait = Traits.get(pure);
            if (trait == null) continue;
            this.unlockedPures.add(trait);
        }
    }

    public class_2487 toNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("total", this.totalResets);
        nbt.method_10569("pure", this.resetsSincePure);
        nbt.method_10569("strong", this.resetsSinceStrong);
        nbt.method_10569("dual", this.resetsSinceDual);
        nbt.method_10569("determination", this.resetsSinceDT);
        class_2487 achieved = new class_2487();
        achieved.method_10556("bravery", this.bravery);
        achieved.method_10556("justice", this.justice);
        achieved.method_10556("kindness", this.kindness);
        achieved.method_10556("patience", this.patience);
        achieved.method_10556("integrity", this.integrity);
        achieved.method_10556("perseverance", this.perseverance);
        achieved.method_10556("determination", this.determination);
        achieved.method_10556("strongDual", this.strongDual);
        nbt.method_10556("setFirst", this.setFirst);
        nbt.method_10566("achieved", (class_2520)achieved);
        class_2499 duals = new class_2499();
        for (class_3545<TraitBase, TraitBase> dual : this.unlockedDuals) {
            class_2487 compound = new class_2487();
            compound.method_10582("trait1", ((TraitBase)dual.method_15442()).getName());
            compound.method_10582("trait2", ((TraitBase)dual.method_15441()).getName());
            duals.add((Object)compound);
        }
        nbt.method_10566("duals", (class_2520)duals);
        class_2499 pures = new class_2499();
        for (TraitBase pure : this.unlockedPures) {
            pures.add((Object)class_2519.method_23256((String)pure.getName()));
        }
        nbt.method_10566("pures", (class_2520)pures);
        return nbt;
    }

    public void writeBuf(class_2540 buf) {
        buf.method_10804(this.totalResets);
        buf.method_10804(this.resetsSincePure);
        buf.method_10804(this.resetsSinceStrong);
        buf.method_10804(this.resetsSinceDual);
        buf.method_10804(this.resetsSinceDT);
        buf.writeBoolean(this.bravery);
        buf.writeBoolean(this.justice);
        buf.writeBoolean(this.kindness);
        buf.writeBoolean(this.patience);
        buf.writeBoolean(this.integrity);
        buf.writeBoolean(this.perseverance);
        buf.writeBoolean(this.determination);
        buf.writeBoolean(this.strongDual);
        buf.writeBoolean(this.setFirst);
        buf.method_10804(this.unlockedDuals.size());
        for (class_3545<TraitBase, TraitBase> dual : this.unlockedDuals) {
            buf.method_10814(((TraitBase)dual.method_15442()).getName());
            buf.method_10814(((TraitBase)dual.method_15441()).getName());
        }
        buf.method_10804(this.unlockedPures.size());
        for (TraitBase pure : this.unlockedPures) {
            buf.method_10814(pure.getName());
        }
    }

    public static ResetData fromBuf(class_2540 buf) {
        ResetData resetData = new ResetData();
        resetData.totalResets = buf.method_10816();
        resetData.resetsSincePure = buf.method_10816();
        resetData.resetsSinceStrong = buf.method_10816();
        resetData.resetsSinceDual = buf.method_10816();
        resetData.resetsSinceDT = buf.method_10816();
        resetData.bravery = buf.readBoolean();
        resetData.justice = buf.readBoolean();
        resetData.kindness = buf.readBoolean();
        resetData.patience = buf.readBoolean();
        resetData.integrity = buf.readBoolean();
        resetData.perseverance = buf.readBoolean();
        resetData.determination = buf.readBoolean();
        resetData.strongDual = buf.readBoolean();
        resetData.setFirst = buf.readBoolean();
        resetData.unlockedDuals = new ArrayList<class_3545<TraitBase, TraitBase>>();
        int unlockedDualCount = buf.method_10816();
        for (int i = 0; i < unlockedDualCount; ++i) {
            TraitBase trait1 = Traits.get(buf.method_19772());
            TraitBase trait2 = Traits.get(buf.method_19772());
            resetData.unlockedDuals.add((class_3545<TraitBase, TraitBase>)new class_3545((Object)trait1, (Object)trait2));
        }
        resetData.unlockedPures = new ArrayList<TraitBase>();
        int unlockedPureCount = buf.method_10816();
        for (int i = 0; i < unlockedPureCount; ++i) {
            TraitBase trait = Traits.get(buf.method_19772());
            resetData.unlockedPures.add(trait);
        }
        return resetData;
    }

    public void addDual(TraitBase trait1, TraitBase trait2) {
        if (this.hasDual(trait1, trait2)) {
            return;
        }
        this.unlockedDuals.add((class_3545<TraitBase, TraitBase>)new class_3545((Object)trait1, (Object)trait2));
    }

    public boolean hasDual(TraitBase trait1, TraitBase trait2) {
        for (class_3545<TraitBase, TraitBase> dual : this.unlockedDuals) {
            if (dual.method_15442() != trait1 && dual.method_15441() != trait1 || dual.method_15442() != trait2 && dual.method_15441() != trait2) continue;
            return true;
        }
        return false;
    }

    public void addPure(TraitBase trait) {
        if (this.hasPure(trait)) {
            return;
        }
        this.unlockedPures.add(trait);
    }

    public boolean hasPure(TraitBase trait) {
        return this.unlockedPures.contains(trait);
    }
}

