/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.util;

import java.util.Objects;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class SpokenTextRenderer {
    private int timer = 0;
    private float speed = 0.0f;
    private int endTime = 0;
    private String text = "";

    public void setText(String text, float speed, int timeToDisappear) {
        this.text = text;
        this.timer = 0;
        this.speed = 5.0f / speed;
        this.endTime = (int)((float)text.length() * speed) + timeToDisappear;
    }

    public void setText(String text) {
        this.setText(text, 4.0f, 40);
    }

    public String getText() {
        return this.text;
    }

    public void clearText() {
        this.text = "";
        this.timer = 0;
        this.speed = 0.0f;
        this.endTime = 0;
    }

    public String toRender() {
        if (Objects.equals(this.text, "") || this.timer == 0 || this.speed == 0.0f || this.endTime == 0) {
            return "";
        }
        StringBuilder toRender = new StringBuilder();
        float t = 0.0f;
        for (char c : this.text.toCharArray()) {
            float getCharacterTimer = this.speed;
            if (c == '.' || c == '?' || c == '!') {
                getCharacterTimer *= 3.0f;
            }
            if (c == ',') {
                getCharacterTimer *= 2.0f;
            }
            if ((float)this.timer >= t) {
                toRender.append(c);
                t += getCharacterTimer;
                continue;
            }
            return toRender.toString();
        }
        return toRender.toString();
    }

    public void tick() {
        if (!Objects.equals(this.text, "")) {
            ++this.timer;
            if (this.timer >= this.endTime) {
                this.clearText();
            }
        }
    }

    public class_2487 writeNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("text", this.text);
        nbt.method_10569("timer", this.timer);
        nbt.method_10548("speed", this.speed);
        nbt.method_10569("endTime", this.endTime);
        return nbt;
    }

    public void readNbt(class_2487 nbt) {
        this.text = nbt.method_10558("text");
        this.timer = nbt.method_10550("timer");
        this.speed = nbt.method_10583("speed");
        this.endTime = nbt.method_10550("endTime");
    }

    public void writeBuffer(class_2540 buf) {
        buf.method_10814(this.text);
        buf.method_10804(this.timer);
        buf.writeFloat(this.speed);
        buf.method_10804(this.endTime);
    }

    public void readBuffer(class_2540 buf) {
        this.text = buf.method_19772();
        this.timer = buf.method_10816();
        this.speed = buf.readFloat();
        this.endTime = buf.method_10816();
    }
}

