/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.util;

import java.util.ArrayList;
import java.util.List;

public class StringCalculator {
    public static float getResult(String calc) throws Exception {
        char[] chars;
        CompoundEntry current = new CompoundEntry(null);
        block6: for (char c : chars = calc.toCharArray()) {
            if (Character.isDigit(c)) {
                if (!current.entries.isEmpty()) {
                    Entry last = current.entries.get(current.entries.size() - 1);
                    if (last instanceof IntEntry) {
                        IntEntry intEntry = (IntEntry)last;
                        intEntry.value = Integer.parseInt(String.valueOf(intEntry.value) + c);
                        continue;
                    }
                    if (last instanceof OperatorEntry) {
                        current.entries.add(new IntEntry(current, Integer.parseInt(Character.toString(c))));
                        continue;
                    }
                    throw new UnsupportedOperationException("Invalid operation found. Attempted to add IntEntry to CompoundEntry.");
                }
                current.entries.add(new IntEntry(current, Integer.parseInt(Character.toString(c))));
                continue;
            }
            if (c == '(') {
                CompoundEntry next = new CompoundEntry(current);
                current.entries.add(next);
                current = next;
                continue;
            }
            if (c == ')') {
                current = current.parent;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            switch (c) {
                case '+': {
                    current.entries.add(new OperatorEntry(current, OperatorEntry.Operator.ADD));
                    continue block6;
                }
                case '-': {
                    current.entries.add(new OperatorEntry(current, OperatorEntry.Operator.SUBTRACT));
                    continue block6;
                }
                case '*': {
                    current.entries.add(new OperatorEntry(current, OperatorEntry.Operator.MULTIPLY));
                    continue block6;
                }
                case '/': {
                    current.entries.add(new OperatorEntry(current, OperatorEntry.Operator.DIVIDE));
                }
            }
        }
        if (current.parent != null) {
            throw new Exception("Never returned to start CompoundEntry. Are you missing some brackets?");
        }
        return current.calculate();
    }

    public static class CompoundEntry
    extends Entry {
        public List<Entry> entries = new ArrayList<Entry>();

        public CompoundEntry(CompoundEntry parent) {
            super(parent);
        }

        public float calculate() {
            float value = Float.NaN;
            OperatorEntry operator = null;
            for (Entry entry : this.entries) {
                if (entry instanceof IntEntry) {
                    IntEntry intEntry = (IntEntry)entry;
                    if (Float.isNaN(value)) {
                        value = intEntry.value;
                        continue;
                    }
                    if (operator == null) continue;
                    switch (operator.operator.ordinal()) {
                        case 0: {
                            value += (float)intEntry.value;
                            break;
                        }
                        case 1: {
                            value -= (float)intEntry.value;
                            break;
                        }
                        case 2: {
                            value *= (float)intEntry.value;
                            break;
                        }
                        case 3: {
                            value /= (float)intEntry.value;
                        }
                    }
                    continue;
                }
                if (entry instanceof OperatorEntry) {
                    OperatorEntry operatorEntry;
                    operator = operatorEntry = (OperatorEntry)entry;
                    continue;
                }
                if (!(entry instanceof CompoundEntry)) continue;
                CompoundEntry compoundEntry = (CompoundEntry)entry;
                float entryVal = compoundEntry.calculate();
                if (Float.isNaN(value)) {
                    value = entryVal;
                    continue;
                }
                if (operator == null) continue;
                switch (operator.operator.ordinal()) {
                    case 0: {
                        value += entryVal;
                        break;
                    }
                    case 1: {
                        value -= entryVal;
                        break;
                    }
                    case 2: {
                        value *= entryVal;
                        break;
                    }
                    case 3: {
                        value /= entryVal;
                    }
                }
            }
            return value;
        }
    }

    public static class Entry {
        public CompoundEntry parent;

        public Entry(CompoundEntry parent) {
            this.parent = parent;
        }
    }

    public static class IntEntry
    extends Entry {
        public int value;

        public IntEntry(CompoundEntry parent, int value) {
            super(parent);
            this.value = value;
        }
    }

    public static class OperatorEntry
    extends Entry {
        public Operator operator;

        public OperatorEntry(CompoundEntry parent, Operator operator) {
            super(parent);
            this.operator = operator;
        }

        public static enum Operator {
            ADD,
            SUBTRACT,
            MULTIPLY,
            DIVIDE;

        }
    }
}

