/*
 * Decompiled with CFR 0.152.
 */
package com.pulsar.soulforge.util;

import com.mojang.brigadier.context.CommandContext;
import com.pulsar.soulforge.SoulForge;
import com.pulsar.soulforge.ability.AbilityBase;
import com.pulsar.soulforge.attribute.SoulForgeAttributes;
import com.pulsar.soulforge.components.EntityInitializer;
import com.pulsar.soulforge.components.HateComponent;
import com.pulsar.soulforge.components.SoulComponent;
import com.pulsar.soulforge.components.TemporaryModifierComponent;
import com.pulsar.soulforge.components.WorldComponent;
import com.pulsar.soulforge.entity.ShieldShardEntity;
import com.pulsar.soulforge.item.SoulForgeItems;
import com.pulsar.soulforge.tag.SoulForgeTags;
import com.pulsar.soulforge.trait.TraitBase;
import com.pulsar.soulforge.trait.Traits;
import com.pulsar.soulforge.util.Triplet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import net.minecraft.class_4076;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.joml.Vector3f;

public class Utils {
    public static final UUID antihealModifierID = UUID.fromString("860f5ef8-87a6-47c7-9af5-8ecd553338c9");
    public static List<String> omegagamers = List.of("GDPulsar", "lolteddii", "AmbrosialPhoenix", "KoriOfAllTrades", "KDMHX2");

    public static class_243 vector3fToVec3d(Vector3f vector3f) {
        return new class_243((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
    }

    public static class_3966 getFocussedEntity(class_1657 player, float distance) {
        class_243 start = player.method_33571();
        class_243 direction = player.method_5720().method_1021(10000.0);
        class_238 searchBox = player.method_5829().method_1014((double)distance);
        return class_1675.method_18077((class_1937)player.method_37908(), (class_1297)player, (class_243)start, (class_243)start.method_1019(direction), (class_238)searchBox, entity -> {
            if (!class_1301.field_6156.test(entity)) {
                if (!(entity instanceof ShieldShardEntity)) return false;
                ShieldShardEntity shieldShard = (ShieldShardEntity)((Object)entity);
                if (shieldShard.owner == player) return false;
            }
            if (entity instanceof class_1309) return true;
            if (!(entity instanceof ShieldShardEntity)) return false;
            return true;
        });
    }

    public static class_3966 getFocussedEntity(class_1657 player, float distance, Predicate<class_1297> predicate) {
        class_243 start = player.method_33571();
        class_243 direction = player.method_5720().method_1021((double)distance);
        class_238 searchBox = player.method_5829().method_1014((double)distance);
        return class_1675.method_18077((class_1937)player.method_37908(), (class_1297)player, (class_243)start, (class_243)start.method_1019(direction), (class_238)searchBox, predicate);
    }

    public static class_2338 getTopBlock(MinecraftServer server, class_1937 world, int x, int z) throws Exception {
        class_3218 serverWorld = server.method_3847(world.method_27983());
        if (!serverWorld.method_8393(class_4076.method_18675((int)x), class_4076.method_18675((int)z))) {
            throw new Exception("Chunk is not loaded.");
        }
        int i = serverWorld.method_8624(class_2902.class_2903.field_13197, x, z);
        return new class_2338(x, i, z);
    }

    public static void addAntiheal(double amount, int duration, class_1309 target) {
        TemporaryModifierComponent modifiers = SoulForge.getTemporaryModifiers(target);
        if (modifiers != null) {
            Triplet<class_1322, class_1320, Float> modifier = modifiers.getModifierEntry(SoulForgeAttributes.ANTIHEAL, antihealModifierID);
            if (modifier != null) {
                if (modifier.getFirst().method_6186() < amount) {
                    modifiers.removeTemporaryModifier(SoulForgeAttributes.ANTIHEAL, modifier.getFirst());
                    modifiers.addTemporaryModifier(SoulForgeAttributes.ANTIHEAL, new class_1322(antihealModifierID, "antiheal", amount, class_1322.class_1323.field_6328), duration);
                } else if (modifier.getFirst().method_6186() == amount && modifier.getThird().floatValue() < (float)duration) {
                    modifiers.removeTemporaryModifier(SoulForgeAttributes.ANTIHEAL, modifier.getFirst());
                    modifiers.addTemporaryModifier(SoulForgeAttributes.ANTIHEAL, new class_1322(antihealModifierID, "antiheal", amount, class_1322.class_1323.field_6328), duration);
                }
            } else {
                modifiers.addTemporaryModifier(SoulForgeAttributes.ANTIHEAL, new class_1322(antihealModifierID, "antiheal", amount, class_1322.class_1323.field_6328), duration);
            }
        }
    }

    public static void clearModifiersByName(class_1309 living, class_1320 attribute, String name) {
        if (living.method_5996(attribute) != null) {
            for (class_1322 modifier : Set.copyOf(living.method_5996(attribute).method_6195())) {
                if (!Objects.equals(modifier.method_6185(), name)) continue;
                living.method_5996(attribute).method_27304(modifier.method_6189());
            }
        }
    }

    public static void clearModifiersByUUID(class_1309 living, class_1320 attribute, UUID uuid) {
        if (living.method_5996(attribute) != null) {
            living.method_5996(attribute).method_6200(uuid);
        }
    }

    public static List<class_1309> getEntitiesInFrontOf(class_1657 player, float width, float depth, float distDown, float distUp) {
        float cos = class_3532.method_15362((float)(player.method_36454() * ((float)Math.PI / 180)));
        float sin = class_3532.method_15374((float)(player.method_36454() * ((float)Math.PI / 180)));
        float cos90 = -class_3532.method_15362((float)((player.method_36454() - 90.0f) * ((float)Math.PI / 180)));
        float sin90 = -class_3532.method_15374((float)((player.method_36454() - 90.0f) * ((float)Math.PI / 180)));
        int boxSize = class_3532.method_15375((float)(width + depth));
        class_238 box = new class_238(player.method_23317() - (double)boxSize, player.method_23318() - (double)distDown, player.method_23321() - (double)boxSize, player.method_23317() + (double)boxSize, player.method_23318() + (double)distUp, player.method_23321() + (double)boxSize);
        class_243 f = new class_243((double)(-sin), 0.0, (double)cos);
        class_243 s = new class_243((double)sin90, 0.0, (double)cos90);
        ArrayList<class_1309> targets = new ArrayList<class_1309>();
        for (class_1297 entity : player.method_5770().method_8335((class_1297)player, box)) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 living = (class_1309)entity;
            float df = (float)((living.method_23317() - player.method_23317()) * f.field_1352 + (living.method_23321() - player.method_23321()) * f.field_1350);
            float ds = (float)((living.method_23317() - player.method_23317()) * s.field_1352 + (living.method_23321() - player.method_23321()) * s.field_1350);
            if (!(df <= depth) || !(df >= 0.0f) || !(ds <= width) || !(ds >= -width)) continue;
            targets.add(living);
        }
        return targets;
    }

    public static List<class_1297> getEntitiesInDirection(class_1297 entity, class_243 direction, float width, float depth, float distDown, float distUp) {
        int boxSize = class_3532.method_15375((float)(width + depth));
        class_238 box = new class_238(entity.method_23317() - (double)boxSize, entity.method_23318() - (double)distDown, entity.method_23321() - (double)boxSize, entity.method_23317() + (double)boxSize, entity.method_23318() + (double)distUp, entity.method_23321() + (double)boxSize);
        class_243 s = direction.method_1024(1.5707964f);
        ArrayList<class_1297> targets = new ArrayList<class_1297>();
        for (class_1297 target : entity.method_5770().method_8335(null, box)) {
            float df = (float)((target.method_23317() - entity.method_23317()) * direction.field_1352 + (target.method_23321() - entity.method_23321()) * direction.field_1350);
            float ds = (float)((target.method_23317() - entity.method_23317()) * s.field_1352 + (target.method_23321() - entity.method_23321()) * s.field_1350);
            if (!(df <= depth) || !(df >= 0.0f) || !(ds <= width) || !(ds >= -width)) continue;
            targets.add(target);
        }
        return targets;
    }

    public static boolean abilityInstanceInList(AbilityBase ability, List<AbilityBase> list) {
        for (AbilityBase test : list) {
            if (ability.getID() != test.getID()) continue;
            return true;
        }
        return false;
    }

    public static class_2561 getTraitText(SoulComponent playerSoul) {
        if (playerSoul.getTraits().isEmpty()) {
            return class_2561.method_43470((String)"I THINK I FUCKED UP!!!");
        }
        class_5250 text = class_2561.method_43470((String)playerSoul.getTrait(0).getName());
        text = text.method_10862(playerSoul.getTrait(0).getStyle());
        if (playerSoul.getTraitCount() >= 2) {
            text = text.method_10852((class_2561)class_2561.method_43470((String)"-").method_27692(class_124.field_1070));
            class_5250 trait2 = class_2561.method_43470((String)playerSoul.getTrait(1).getName()).method_10862(playerSoul.getTrait(1).getStyle());
            text.method_10852((class_2561)trait2);
        }
        if (playerSoul.isPure()) {
            text = class_2561.method_43470((String)"Pure ").method_10852((class_2561)text);
        }
        if (playerSoul.isStrong() || playerSoul.hasTrait(Traits.determination)) {
            text = text.method_10862(text.method_10866().method_27706(class_124.field_1067));
        }
        return text;
    }

    public static boolean isImbued(class_1799 stack, class_1657 player) {
        return Utils.getImbuer(stack, player) != null;
    }

    public static class_1799 getImbuer(class_1799 stack, class_1657 player) {
        if (stack.method_7969().method_10545("imbuedId")) {
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                class_1799 check = player.method_31548().method_5438(i);
                if (!check.method_31574(SoulForgeItems.SIPHON_IMBUER)) continue;
                check.method_7948();
                if (stack.method_7969().method_25926("imbuedId").compareTo(check.method_7969().method_25926("imbuedId")) != 0) continue;
                return check;
            }
        }
        return null;
    }

    public static class_1799 getImbuedById(UUID uuid, class_1657 player) {
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            stack.method_7948();
            if (!stack.method_7969().method_10545("imbued") || !stack.method_7969().method_10545("imbuedId") || stack.method_7969().method_25926("imbuedId").compareTo(uuid) != 0) continue;
            return stack;
        }
        return null;
    }

    public static List<class_1297> visibleEntitiesInBox(class_1297 entity, class_238 box) {
        ArrayList<class_1297> visible = new ArrayList<class_1297>();
        for (class_1297 aoe : entity.method_5770().method_8335(null, box)) {
            class_3959 ctx = new class_3959(entity.method_19538(), aoe.method_19538(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity);
            if (!(entity.method_37908().method_17742(ctx).method_17784().method_1022(aoe.method_19538()) < (double)0.05f)) continue;
            visible.add(aoe);
        }
        return visible;
    }

    public static class_243 getArmPosition(class_1657 player) {
        float angle = player.method_6068() == class_1306.field_6183 ? -1.5707964f : 1.5707964f;
        return player.method_33571().method_1019(player.method_5720().method_1024(angle).method_38499(class_2350.class_2351.field_11052, 0.0).method_1021((double)0.4f)).method_1023(0.0, 1.0, 0.0);
    }

    public static void addEffectDuration(class_1309 target, class_1291 effect, int duration, int amplifier) {
        if (target.method_6059(effect) && target.method_6112(effect).method_5578() >= amplifier) {
            duration += target.method_6112(effect).method_5584();
        }
        target.method_6092(new class_1293(effect, duration, amplifier));
    }

    public static int getTotalEffectLevel(class_1309 target) {
        int val = 0;
        for (class_1293 effect : target.method_6026()) {
            val += effect.method_5578();
        }
        return val;
    }

    public static int getTotalDebuffLevel(class_1309 target) {
        int val = 0;
        for (class_1293 effect : target.method_6026()) {
            if (effect.method_5579().method_5573()) continue;
            val += effect.method_5578();
        }
        TemporaryModifierComponent modifiers = (TemporaryModifierComponent)EntityInitializer.TEMPORARY_MODIFIERS.get((Object)target);
        return val += modifiers.getModifierCount();
    }

    public static class_2499 vectorToNbt(class_243 vec) {
        class_2499 list = new class_2499();
        list.add((Object)class_2489.method_23241((double)vec.field_1352));
        list.add((Object)class_2489.method_23241((double)vec.field_1351));
        list.add((Object)class_2489.method_23241((double)vec.field_1350));
        return list;
    }

    public static class_243 nbtToVector(class_2499 list) {
        return new class_243(list.method_10611(0), list.method_10611(1), list.method_10611(2));
    }

    public static boolean isInverted(SoulComponent playerSoul) {
        return playerSoul.hasTrait(Traits.fear) || playerSoul.hasTrait(Traits.ineptitude) || playerSoul.hasTrait(Traits.misery) || playerSoul.hasTrait(Traits.anxiety) || playerSoul.hasTrait(Traits.paranoia) || playerSoul.hasTrait(Traits.despair);
    }

    public static TraitBase getInvertedVariant(TraitBase trait) {
        if (trait == Traits.bravery) {
            return Traits.fear;
        }
        if (trait == Traits.justice) {
            return Traits.ineptitude;
        }
        if (trait == Traits.kindness) {
            return Traits.misery;
        }
        if (trait == Traits.patience) {
            return Traits.anxiety;
        }
        if (trait == Traits.integrity) {
            return Traits.paranoia;
        }
        if (trait == Traits.perseverance) {
            return Traits.despair;
        }
        if (trait == Traits.determination) {
            return Traits.spite;
        }
        return null;
    }

    public static void addTemporaryAttribute(class_1309 entity, class_1320 attribute, class_1322 modifier, int duration) {
        ((TemporaryModifierComponent)EntityInitializer.TEMPORARY_MODIFIERS.get((Object)entity)).addTemporaryModifier(attribute, modifier, duration);
    }

    public static void removeTemporaryAttribute(class_1309 entity, class_1320 attribute, class_1322 modifier) {
        ((TemporaryModifierComponent)EntityInitializer.TEMPORARY_MODIFIERS.get((Object)entity)).removeTemporaryModifier(attribute, modifier);
    }

    public static boolean canAccessInverteds(CommandContext<class_2168> context) {
        return ((class_2168)context.getSource()).method_43737() && (omegagamers.contains(((class_2168)context.getSource()).method_44023().method_5477().getString()) || FabricLoader.getInstance().isDevelopmentEnvironment());
    }

    public static boolean canAccessInverteds(class_2168 source) {
        return source.method_43737() && (omegagamers.contains(source.method_44023().method_5477().getString()) || FabricLoader.getInstance().isDevelopmentEnvironment());
    }

    public static float getHate(class_1309 entity) {
        if (entity == null) {
            return 0.0f;
        }
        HateComponent hate = SoulForge.getHate(entity);
        if (hate == null) {
            return 0.0f;
        }
        return hate.getHatePercent();
    }

    public static boolean hasHate(class_1309 entity) {
        if (entity == null) {
            return false;
        }
        HateComponent hate = SoulForge.getHate(entity);
        if (hate == null) {
            return false;
        }
        return hate.hasHate();
    }

    public static void setHate(class_1309 entity, float amount) {
        if (entity == null) {
            return;
        }
        HateComponent hate = SoulForge.getHate(entity);
        if (hate == null) {
            return;
        }
        hate.setHatePercent(amount);
    }

    public static void addHate(class_1309 entity, float amount) {
        if (entity == null) {
            return;
        }
        HateComponent hate = SoulForge.getHate(entity);
        if (hate == null) {
            return;
        }
        hate.addHatePercent(amount);
    }

    public static void setHasHate(class_1309 entity, boolean hasHate) {
        if (entity == null) {
            return;
        }
        HateComponent hate = SoulForge.getHate(entity);
        if (hate == null) {
            return;
        }
        hate.setHasHate(hasHate);
    }

    public static <T, V> T getKeyByValue(HashMap<T, V> oldValues, V value) {
        for (Map.Entry<T, V> entry : oldValues.entrySet()) {
            if (entry.getValue() != value) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean isParrying(class_1309 entity) {
        if (entity.method_6115() && entity.method_6030().method_31573(SoulForgeTags.PARRY_ITEMS)) {
            return true;
        }
        if (entity instanceof class_1657) {
            SoulComponent playerSoul;
            class_1657 player = (class_1657)entity;
            if (player.method_37908().field_9236 || !(playerSoul = SoulForge.getPlayerSoul(player)).hasTrait(Traits.bravery) || !playerSoul.hasTrait(Traits.integrity) || playerSoul.hasCast("Valiant Heart")) {
                // empty if block
            }
        }
        return false;
    }

    public static float getPlayerKillCountExpMultiplier(class_1309 living, class_1657 player) {
        SoulComponent playerSoul = SoulForge.getPlayerSoul(player);
        if (living.method_6102()) {
            if (living.method_31747()) {
                if (playerSoul.getPlayerSouls().containsKey(living.method_5845())) {
                    return class_3532.method_15363((float)(1.0f - (float)playerSoul.getPlayerSouls().get(living.method_5845()).intValue() / 3.0f), (float)0.0f, (float)1.0f);
                }
            } else {
                String mobId = class_7923.field_41177.method_10221((Object)living.method_5864()).toString();
                if (playerSoul.getMonsterSouls().containsKey(mobId)) {
                    return class_3532.method_15363((float)(1.0f - (float)playerSoul.getMonsterSouls().get(mobId).intValue() / 50.0f), (float)0.2f, (float)1.0f);
                }
            }
        }
        return 1.0f;
    }

    public static float getEntityExpMultiplier(class_1309 living) {
        float targetDefence = 0.0f;
        if (living.method_6127().method_27306(class_5134.field_23724)) {
            targetDefence = (float)living.method_26825(class_5134.field_23724);
        }
        float targetDamage = 0.0f;
        if (living.method_6127().method_27306(class_5134.field_23721)) {
            targetDamage = (float)living.method_26825(class_5134.field_23721);
        }
        return 1.0f + targetDefence / 10.0f + targetDamage / 10.0f;
    }

    public static float getKillExpOverride(class_1309 living) {
        if (living.method_31747()) {
            float targetDefence = 0.0f;
            if (living.method_6127().method_27306(class_5134.field_23724)) {
                targetDefence = (float)living.method_26825(class_5134.field_23724);
            }
            class_1657 targetPlayer = (class_1657)living;
            SoulComponent targetSoul = SoulForge.getPlayerSoul(targetPlayer);
            return 250.0f * (1.0f + targetDefence / 10.0f * ((float)targetSoul.getLV() / 4.0f));
        }
        if (living.method_5864() == class_1299.field_6116) {
            return 3000.0f;
        }
        if (living.method_5864() == class_1299.field_6119) {
            return 1500.0f;
        }
        if (living.method_5864() == class_1299.field_6086) {
            return 500.0f;
        }
        if (living.method_5864() == class_1299.field_6090) {
            return 250.0f;
        }
        if (living.method_5864() == class_1299.field_38095) {
            return 1000.0f;
        }
        if (living.method_5864() == class_1299.field_25751) {
            return 250.0f;
        }
        return 0.0f;
    }

    public static int getKillExp(class_1309 living, class_1657 player) {
        float exp = Utils.getKillExpOverride(living);
        if (exp == 0.0f) {
            exp = living.method_6063() * Utils.getEntityExpMultiplier(living);
        }
        WorldComponent worldComponent = SoulForge.getWorldComponent(player.method_37908());
        exp *= worldComponent.getExpMultiplier();
        return (int)(exp *= Utils.getPlayerKillCountExpMultiplier(living, player));
    }

    public static int getDamageExp(class_1309 living, class_1657 player, float damage) {
        float exp = damage * Utils.getEntityExpMultiplier(living);
        WorldComponent worldComponent = SoulForge.getWorldComponent(player.method_37908());
        exp *= worldComponent.getExpMultiplier();
        return (int)(exp *= Utils.getPlayerKillCountExpMultiplier(living, player));
    }
}

