/*
 * Decompiled with CFR 0.152.
 */
package com.lyki;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.lyki.AttackDamageCallback;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PvPSystem
implements ModInitializer {
    private static final Map<UUID, Boolean> pvpStatus = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> attackCooldowns = new HashMap<UUID, Long>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"pvpsystem");
    private static long newPvpToggleCooldownMillis;
    private static boolean newDefaultPvPEnabled;
    private static final String CONFIG_PATH = "config/PvPSystem/pvpsystem.properties";
    private static final Properties properties;
    private JsonObject config;

    public void onInitialize() {
        LOGGER.info("PVPSystem by lykiaofficial (https://lyki.xyz)");
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, registrationEnvironment) -> this.registerPvPCommand((CommandDispatcher<class_2168>)dispatcher));
        try {
            File configFile = new File(CONFIG_PATH);
            if (!configFile.exists()) {
                PvPSystem.createDefaultConfig(configFile);
            }
            try (FileInputStream input = new FileInputStream(configFile);){
                properties.load(input);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        AttackDamageCallback.EVENT.register(this::onAttack);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                this.initializePvPStatus(player);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            UUID playerUuid = newPlayer.method_5667();
            this.resetAttackCooldown(playerUuid);
        });
        this.reloadConfig();
        this.loadConfig();
    }

    private class_5250 formatTextWithColor(String text) {
        String[] parts;
        class_5250 mutableText = (class_5250)class_2561.method_30163((String)"");
        for (String part : parts = text.split("(?=#[0-9a-fA-F]{6})")) {
            if (part.startsWith("#")) {
                String hexColor = part.substring(0, 7);
                String content = part.substring(7);
                mutableText = mutableText.method_10852((class_2561)class_2561.method_43470((String)content).method_27694(style -> style.method_27703(class_5251.method_27717((int)Integer.parseInt(hexColor.substring(1), 16)))));
                continue;
            }
            mutableText = mutableText.method_10852((class_2561)class_2561.method_43470((String)part));
        }
        return mutableText;
    }

    private void loadConfig() {
        Path configDir = Paths.get("config/PvPSystem", new String[0]);
        Path configFile = configDir.resolve("pvpsystem_messages.json");
        if (!Files.exists(configFile, new LinkOption[0])) {
            try {
                Files.createDirectories(configDir, new FileAttribute[0]);
                Files.copy(Objects.requireNonNull(this.getClass().getResourceAsStream("/pvpsystem_messages.json")), configFile, new CopyOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Gson gson = new Gson();
        try (BufferedReader reader = Files.newBufferedReader(configFile);){
            this.config = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getConfigMessage(String key, String ... replacements) {
        String message = this.config.has(key) ? this.config.get(key).getAsString() : key;
        for (int i = 0; i < replacements.length; i += 2) {
            message = message.replace(replacements[i], replacements[i + 1]);
        }
        return message;
    }

    private static void createDefaultConfig(File configFile) throws IOException {
        configFile.getParentFile().mkdirs();
        try (FileOutputStream output = new FileOutputStream(configFile);){
            properties.setProperty("defaultPvPEnabled", "false");
            properties.setProperty("pvpToggleCooldownSeconds", "30");
            properties.store(output, "PvPSystem Configuration by lykiaofficial");
        }
    }

    public static boolean getDefaultPvPEnabled() {
        return Boolean.parseBoolean(properties.getProperty("defaultPvPEnabled", "false"));
    }

    public static long getPvPToggleCooldownMillis() {
        int seconds = Integer.parseInt(properties.getProperty("pvpToggleCooldownSeconds", "30"));
        return seconds > 0 ? (long)seconds * 1000L : 0L;
    }

    private void registerPvPCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pvp").executes(this::executePvPCommand)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(source -> source.method_9259(2))).executes(this::executeReloadCommand)));
    }

    private int executePvPCommand(CommandContext<class_2168> context) {
        class_2168 sender = (class_2168)context.getSource();
        class_3222 player = sender.method_44023();
        if (player == null) {
            sender.method_9213(class_2561.method_30163((String)"This command can only be executed by a player."));
            return 0;
        }
        long attackCooldown = this.getAttackCooldown(sender.method_44023().method_5667());
        if (attackCooldown > 0L) {
            sender.method_45068(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("on_cooldown_you_cant_use_the_command", "%time%", this.formatCooldownTime(attackCooldown)))));
            return 0;
        }
        UUID playerUuid = player.method_5667();
        boolean currentStatus = pvpStatus.getOrDefault(playerUuid, newDefaultPvPEnabled);
        boolean newStatus = !currentStatus;
        pvpStatus.put(playerUuid, newStatus);
        if (newStatus) {
            sender.method_45068(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("pvp_set_to_enabled", new String[0]))));
        } else {
            sender.method_45068(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("pvp_set_to_disabled", new String[0]))));
        }
        return 1;
    }

    private int executeReloadCommand(CommandContext<class_2168> context) {
        class_2168 sender = (class_2168)context.getSource();
        this.reloadConfig();
        this.loadConfig();
        sender.method_45068(class_2561.method_54155((Message)this.formatTextWithColor("#FF0000PvPSystem #FFFFFFSettings and messages successfully reloaded.")));
        return 1;
    }

    private void reloadConfig() {
        try {
            File configFile = new File(CONFIG_PATH);
            try (FileInputStream input = new FileInputStream(configFile);){
                properties.load(input);
            }
            newPvpToggleCooldownMillis = PvPSystem.getPvPToggleCooldownMillis();
            newDefaultPvPEnabled = PvPSystem.getDefaultPvPEnabled();
        }
        catch (IOException ex) {
            LOGGER.error("Error reloading config: {}", (Object)ex.getMessage());
            ex.printStackTrace();
        }
    }

    private class_1269 onAttack(class_1657 attacker, class_1657 target, class_1282 source, float amount) {
        if (attacker instanceof class_1657 && target instanceof class_1657) {
            class_3222 serverAttacker = (class_3222)attacker;
            UUID attackerUuid = serverAttacker.method_5667();
            UUID targetUuid = target.method_5667();
            boolean attackerPvp = pvpStatus.getOrDefault(attackerUuid, newDefaultPvPEnabled);
            boolean targetPvp = pvpStatus.getOrDefault(targetUuid, newDefaultPvPEnabled);
            String targetDisplayName = target.method_5476().getString();
            if (!attackerPvp) {
                serverAttacker.method_64398(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("cant_attack_your_pvp_disabled", "%target%", targetDisplayName))));
                return class_1269.field_5814;
            }
            if (!targetPvp) {
                serverAttacker.method_64398(class_2561.method_54155((Message)this.formatTextWithColor(this.getConfigMessage("cant_attack_targets_pvp_disabled", "%target%", targetDisplayName))));
                return class_1269.field_5814;
            }
            this.applyAttackCooldown(attackerUuid);
            this.applyAttackCooldown(targetUuid);
        }
        return class_1269.field_5811;
    }

    private void initializePvPStatus(class_3222 player) {
        if (!pvpStatus.containsKey(player.method_5667())) {
            pvpStatus.put(player.method_5667(), newDefaultPvPEnabled);
        }
    }

    private long getAttackCooldown(UUID playerUuid) {
        if (!attackCooldowns.containsKey(playerUuid)) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis();
        long cooldownEndTime = attackCooldowns.get(playerUuid);
        return Math.max(0L, cooldownEndTime - currentTime);
    }

    private void applyAttackCooldown(UUID playerUuid) {
        long attackCooldownMillis = newPvpToggleCooldownMillis;
        long cooldownEndTime = System.currentTimeMillis() + attackCooldownMillis;
        attackCooldowns.put(playerUuid, cooldownEndTime);
    }

    private void resetAttackCooldown(UUID playerUuid) {
        attackCooldowns.remove(playerUuid);
    }

    private String formatCooldownTime(long milliseconds) {
        if (milliseconds <= 0L) {
            return "0s";
        }
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60L;
        minutes %= 60L;
        hours %= 24L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L || sb.length() == 0) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }

    static {
        properties = new Properties();
    }
}

