/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.entity;

import com.google.common.annotations.VisibleForTesting;
import com.natephantom.init.AllhallowsBlockEntityTypes;
import com.natephantom.init.AllhallowsPoiTypes;
import com.natephantom.init.AllhallowsSounds;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GhostEntity
extends Monster {
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK;
    private static final EntityDataAccessor<Boolean> DATA_INVISIBLE_GHOST;
    private static final EntityDataAccessor<Boolean> DATA_WEEPING;
    private static final EntityDataAccessor<Integer> DATA_ATTACK_TIMER;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState weepAnimationState = new AnimationState();
    public final AnimationState invisibleAnimationState = new AnimationState();
    public final AnimationState appearAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    private static final int COOLDOWN_BEFORE_LOCATING_NEW_GRAVE = 200;
    private int remainingCooldownBeforeLocatingNewGrave;
    @Nullable
    private BlockPos gravePos;
    private GhostGoToGraveGoal goToGraveGoal;
    private boolean isInvisible = false;
    private boolean justAttacked = false;
    private int invisibleTimer = 0;
    private final double weepRangeMax = 15.0;
    private final double weepRangeMin = 5.0;

    public GhostEntity(EntityType<? extends GhostEntity> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
        this.xpReward = 5;
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
        this.navigation = new FlyingPathNavigation((Mob)this, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FLYING_SPEED, 0.35).add(Attributes.ENTITY_INTERACTION_RANGE, 1.0).add(Attributes.FOLLOW_RANGE, 24.0);
    }

    protected SoundEvent getAmbientSound() {
        return AllhallowsSounds.GHOST_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return AllhallowsSounds.GHOST_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return AllhallowsSounds.GHOST_DEATH.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.goalSelector.addGoal(2, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new GhostWeepGoal(this, this));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.goalSelector.addGoal(3, (Goal)new GhostLocateGraveGoal());
        this.goToGraveGoal = new GhostGoToGraveGoal();
        this.goalSelector.addGoal(4, (Goal)this.goToGraveGoal);
        this.goalSelector.addGoal(7, (Goal)new GhostWanderGoal());
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    private void setupAnimationStates() {
        boolean attackingNow;
        boolean weeping = this.isGhostWeeping();
        boolean invisible = this.isGhostInvisible();
        int attackTimer = this.getAttackTimer();
        boolean bl = attackingNow = attackTimer > 0;
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.random.nextInt(40) + 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (invisible) {
            this.weepAnimationState.stop();
            this.attackAnimationState.stop();
            this.idleAnimationState.stop();
            this.appearAnimationState.stop();
            this.invisibleAnimationState.startIfStopped(this.tickCount);
            return;
        }
        if (weeping) {
            this.attackAnimationState.stop();
            this.idleAnimationState.stop();
            this.appearAnimationState.stop();
            this.invisibleAnimationState.stop();
            this.weepAnimationState.startIfStopped(this.tickCount);
            return;
        }
        if (attackingNow) {
            if (!this.attackAnimationState.isStarted()) {
                this.attackAnimationState.start(this.tickCount);
            }
            this.weepAnimationState.stop();
            this.idleAnimationState.stop();
            return;
        }
        this.weepAnimationState.stop();
        this.attackAnimationState.stop();
        this.appearAnimationState.stop();
        this.invisibleAnimationState.stop();
        this.idleAnimationState.startIfStopped(this.tickCount);
    }

    private void handleInvisible() {
        if (this.getTarget() instanceof Player) {
            if (this.getGhostInvisibleFlag()) {
                --this.invisibleTimer;
                if (this.invisibleTimer <= 0) {
                    this.setInvisible(false);
                    this.setGhostInvisibleFlag(false);
                }
            } else if (this.random.nextInt(300) == 0) {
                this.setInvisible(true);
                this.setGhostInvisibleFlag(true);
                this.invisibleTimer = 60 + this.random.nextInt(40);
            }
        } else if (this.getGhostInvisibleFlag()) {
            this.setInvisible(false);
            this.setGhostInvisibleFlag(false);
        }
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long lastPoseChangeTick) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, (Object)lastPoseChangeTick);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.handleInvisible();
            int at = this.getAttackTimer();
            if (at > 0) {
                this.setAttackTimer(at - 1);
            }
        } else {
            this.setupAnimationStates();
        }
    }

    public void weep() {
        if (!this.isGhostWeeping()) {
            this.setPose(Pose.INHALING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.playSound(AllhallowsSounds.GHOST_WEEP.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.resetLastPoseChangeTick(-this.level().getGameTime());
            this.setWeeping(true);
        }
    }

    public void endWeep() {
        if (this.isGhostWeeping()) {
            this.setPose(Pose.STANDING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(this.level().getGameTime());
            this.setWeeping(false);
        }
    }

    public boolean isGhostWeeping() {
        return (Boolean)this.entityData.get(DATA_WEEPING);
    }

    public boolean isGhostInvisible() {
        return this.isInvisible;
    }

    public void setWeeping(boolean weeping) {
        this.entityData.set(DATA_WEEPING, (Object)weeping);
    }

    public boolean doHurtTarget(Entity target) {
        boolean success = super.doHurtTarget(target);
        if (success && !this.level().isClientSide()) {
            this.setAttackTimer(10);
            this.playSound(AllhallowsSounds.GHOST_ATTACK.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        }
        return success;
    }

    public int getAttackTimer() {
        return (Integer)this.entityData.get(DATA_ATTACK_TIMER);
    }

    public void setAttackTimer(int ticks) {
        this.entityData.set(DATA_ATTACK_TIMER, (Object)ticks);
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entity) {
    }

    public void setGravePos(BlockPos gravePos) {
        this.gravePos = gravePos;
    }

    public boolean hasGrave() {
        return this.gravePos != null;
    }

    @Nullable
    public BlockPos getGravePos() {
        return this.gravePos;
    }

    private boolean closerThan(BlockPos pos, double distance) {
        return this.blockPosition().closerThan((Vec3i)pos, distance);
    }

    private boolean isTooFarFrom(BlockPos pos) {
        return !this.closerThan(pos, 32.0);
    }

    private boolean isGraveValid() {
        if (!this.hasGrave()) {
            return false;
        }
        if (this.isTooFarFrom(this.gravePos)) {
            return false;
        }
        BlockEntity blockEntity = this.level().getBlockEntity(this.gravePos);
        return blockEntity != null && blockEntity.getType() == AllhallowsBlockEntityTypes.GRAVESTONE.get();
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean getGhostInvisibleFlag() {
        return (Boolean)this.entityData.get(DATA_INVISIBLE_GHOST);
    }

    public void setGhostInvisibleFlag(boolean v) {
        this.entityData.set(DATA_INVISIBLE_GHOST, (Object)v);
    }

    public void lookAt(Entity entity, float maxYRotIncrease, float maxXRotIncrease) {
        super.lookAt(entity, maxYRotIncrease, maxXRotIncrease);
    }

    public void aiStep() {
        super.aiStep();
        boolean bl = this.isSunBurnTick();
        if (bl) {
            ItemStack itemStack = this.getItemBySlot(EquipmentSlot.HEAD);
            if (!itemStack.isEmpty()) {
                if (itemStack.isDamageableItem()) {
                    Item item = itemStack.getItem();
                    itemStack.setDamageValue(itemStack.getDamageValue() + this.random.nextInt(2));
                    if (itemStack.getDamageValue() >= itemStack.getMaxDamage()) {
                        this.onEquippedItemBroken(item, EquipmentSlot.HEAD);
                        this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
                    }
                }
                bl = false;
            }
            if (bl) {
                this.igniteForSeconds(8.0f);
            }
        }
        if (!this.level().isClientSide) {
            if (this.remainingCooldownBeforeLocatingNewGrave > 0) {
                --this.remainingCooldownBeforeLocatingNewGrave;
            }
            if (this.tickCount % 40 == 0 && !this.isGraveValid()) {
                this.gravePos = null;
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.hasGrave()) {
            tag.put("grave_pos", NbtUtils.writeBlockPos((BlockPos)this.gravePos));
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("grave_pos")) {
            this.gravePos = NbtUtils.readBlockPos((CompoundTag)tag, (String)"grave_pos").orElse(null);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_INVISIBLE_GHOST, (Object)false);
        builder.define(DATA_WEEPING, (Object)false);
        builder.define(LAST_POSE_CHANGE_TICK, (Object)0L);
        builder.define(DATA_ATTACK_TIMER, (Object)0);
    }

    static {
        DATA_INVISIBLE_GHOST = SynchedEntityData.defineId(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_WEEPING = SynchedEntityData.defineId(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        LAST_POSE_CHANGE_TICK = SynchedEntityData.defineId(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
        DATA_ATTACK_TIMER = SynchedEntityData.defineId(GhostEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    }

    public class GhostWeepGoal
    extends Goal {
        private final GhostEntity ghost;
        private Player targetPlayer;
        private int weepDuration = 0;
        private final int maxWeepTicks = 200;
        private final float chanceToWeep = 0.33f;

        public GhostWeepGoal(GhostEntity this$0, GhostEntity ghost) {
            this.ghost = ghost;
            this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.ghost.getTarget() != null) {
                return false;
            }
            if (Math.random() > (double)0.33f) {
                return false;
            }
            if (this.ghost.isOnFire()) {
                return false;
            }
            Player nearest = this.ghost.level().getNearestPlayer((Entity)this.ghost, 15.0);
            if (nearest == null) {
                return false;
            }
            double distance = this.ghost.distanceTo((Entity)nearest);
            if (distance > 5.0) {
                this.targetPlayer = nearest;
                this.weepDuration = 0;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.targetPlayer != null && (double)this.ghost.distanceTo((Entity)this.targetPlayer) > 5.0 && this.weepDuration < 200;
        }

        public void start() {
            this.ghost.weep();
            this.ghost.setWeeping(true);
        }

        public void stop() {
            this.ghost.endWeep();
            this.targetPlayer = null;
            this.weepDuration = 0;
            this.ghost.setWeeping(false);
        }

        public void tick() {
            if (this.targetPlayer == null) {
                return;
            }
            ++this.weepDuration;
            double distance = this.ghost.distanceTo((Entity)this.targetPlayer);
            if (distance <= 5.0) {
                this.stop();
                return;
            }
            if (this.ghost.isOnFire()) {
                this.stop();
                return;
            }
            double dx = this.ghost.getX() - this.targetPlayer.getX();
            double dz = this.ghost.getZ() - this.targetPlayer.getZ();
            float targetYaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
            float newYaw = Mth.rotateIfNecessary((float)this.ghost.getYRot(), (float)targetYaw, (float)5.0f);
            this.ghost.setYRot(newYaw);
            this.ghost.yHeadRot = newYaw;
            this.ghost.getNavigation().moveTo(this.ghost.getX() - dx * 0.05, this.ghost.getY(), this.ghost.getZ() - dz * 0.05, 1.0);
        }
    }

    class GhostLocateGraveGoal
    extends Goal {
        private static final int SEARCH_RADIUS = 20;
        private static final int COOLDOWN_BEFORE_LOCATING_NEW_GRAVE = 200;

        public boolean canUse() {
            return GhostEntity.this.remainingCooldownBeforeLocatingNewGrave <= 0 && GhostEntity.this.getGravePos() == null;
        }

        public void start() {
            GhostEntity.this.remainingCooldownBeforeLocatingNewGrave = 200;
            Optional<PoiRecord> nearbyGrave = this.findNearbyGraves();
            if (nearbyGrave.isPresent()) {
                GhostEntity.this.gravePos = nearbyGrave.get().getPos();
            }
        }

        private Optional<PoiRecord> findNearbyGraves() {
            BlockPos blockPos = GhostEntity.this.blockPosition();
            PoiManager poiManager = ((ServerLevel)GhostEntity.this.level()).getPoiManager();
            return poiManager.getInRange(holder -> holder.is(AllhallowsPoiTypes.GRAVESTONE.getKey()), blockPos, 20, PoiManager.Occupancy.ANY).findFirst();
        }

        public boolean canContinueToUse() {
            return false;
        }
    }

    class GhostGoToGraveGoal
    extends Goal {
        private int travellingTicks;

        GhostGoToGraveGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return GhostEntity.this.gravePos != null && !GhostEntity.this.isGraveValid() && GhostEntity.this.remainingCooldownBeforeLocatingNewGrave == 0;
        }

        public boolean canContinueToUse() {
            return GhostEntity.this.gravePos != null && !GhostEntity.this.closerThan(GhostEntity.this.gravePos, 2.0);
        }

        public void start() {
            this.travellingTicks = 0;
        }

        public void stop() {
            this.travellingTicks = 0;
            GhostEntity.this.navigation.stop();
        }

        public void tick() {
            if (GhostEntity.this.gravePos != null) {
                ++this.travellingTicks;
                if (!GhostEntity.this.navigation.isInProgress() && !GhostEntity.this.closerThan(GhostEntity.this.gravePos, 16.0)) {
                    GhostEntity.this.navigation.moveTo((double)GhostEntity.this.gravePos.getX(), (double)GhostEntity.this.gravePos.getY(), (double)GhostEntity.this.gravePos.getZ(), 1.0);
                }
                if (this.travellingTicks > 600) {
                    GhostEntity.this.gravePos = null;
                    GhostEntity.this.remainingCooldownBeforeLocatingNewGrave = 200;
                }
            }
        }
    }

    class GhostWanderGoal
    extends Goal {
        private static final int CHANCE_TO_WANDER = 20;
        private static final double SPEED = 1.0;
        private static final int HORIZONTAL_RANGE = 8;
        private static final int VERTICAL_RANGE = 6;

        GhostWanderGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return GhostEntity.this.getTarget() == null && GhostEntity.this.navigation.isDone() && GhostEntity.this.random.nextInt(20) == 0 && (GhostEntity.this.gravePos == null || GhostEntity.this.distanceToSqr(Vec3.atCenterOf((Vec3i)GhostEntity.this.gravePos)) < 64.0);
        }

        public boolean canContinueToUse() {
            return GhostEntity.this.navigation.isInProgress();
        }

        public void start() {
            Vec3 pos = this.getWanderPosition();
            if (pos != null) {
                GhostEntity.this.navigation.moveTo(pos.x, pos.y, pos.z, 1.0);
            }
        }

        @Nullable
        private Vec3 getWanderPosition() {
            Vec3 lookVec = GhostEntity.this.getViewVector(0.0f);
            Vec3 pos = null;
            if (GhostEntity.this.gravePos != null && GhostEntity.this.distanceToSqr(Vec3.atCenterOf((Vec3i)GhostEntity.this.gravePos)) < 128.0) {
                pos = AirRandomPos.getPosTowards((PathfinderMob)GhostEntity.this, (int)8, (int)6, (int)0, (Vec3)Vec3.atCenterOf((Vec3i)GhostEntity.this.gravePos), (double)0.3141592741012573);
            }
            if (pos == null) {
                pos = HoverRandomPos.getPos((PathfinderMob)GhostEntity.this, (int)8, (int)6, (double)lookVec.x, (double)lookVec.z, (float)1.5707964f, (int)3, (int)1);
            }
            if (pos == null) {
                pos = AirAndWaterRandomPos.getPos((PathfinderMob)GhostEntity.this, (int)8, (int)6, (int)-2, (double)lookVec.x, (double)lookVec.z, (double)1.5707963705062866);
            }
            return pos;
        }
    }
}

