/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.entity;

import com.google.common.annotations.VisibleForTesting;
import com.natephantom.init.AllhallowsBlockEntityTypes;
import com.natephantom.init.AllhallowsPoiTypes;
import com.natephantom.init.AllhallowsSounds;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1344;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1384;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5530;
import net.minecraft.class_5531;
import net.minecraft.class_5533;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class GhostEntity
extends class_1588 {
    public static final class_2940<Long> LAST_POSE_CHANGE_TICK;
    private static final class_2940<Boolean> DATA_INVISIBLE_GHOST;
    private static final class_2940<Boolean> DATA_WEEPING;
    private static final class_2940<Integer> DATA_ATTACK_TIMER;
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 weepAnimationState = new class_7094();
    public final class_7094 invisibleAnimationState = new class_7094();
    public final class_7094 appearAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private static final int COOLDOWN_BEFORE_LOCATING_NEW_GRAVE = 200;
    private int remainingCooldownBeforeLocatingNewGrave;
    @Nullable
    private class_2338 gravePos;
    private GhostGoToGraveGoal goToGraveGoal;
    private boolean isInvisible = false;
    private boolean justAttacked = false;
    private int invisibleTimer = 0;
    private final double weepRangeMax = 15.0;
    private final double weepRangeMin = 5.0;

    public GhostEntity(class_1299<? extends GhostEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5875(true);
        this.field_6194 = 5;
        this.field_6207 = new class_1331((class_1308)this, 10, true);
        this.field_6189 = new class_1407((class_1308)this, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 16.0).method_26868(class_5134.field_23721, 4.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23720, 0.35).method_26868(class_5134.field_47759, 1.0).method_26868(class_5134.field_23717, 24.0);
    }

    protected class_3414 method_5994() {
        return AllhallowsSounds.GHOST_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return AllhallowsSounds.GHOST_HURT.get();
    }

    protected class_3414 method_6002() {
        return AllhallowsSounds.GHOST_DEATH.get();
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1384((class_1314)this));
        this.field_6201.method_6277(2, (class_1352)new class_1344((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(4, (class_1352)new GhostWeepGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.2, true));
        this.field_6201.method_6277(3, (class_1352)new GhostLocateGraveGoal());
        this.goToGraveGoal = new GhostGoToGraveGoal();
        this.field_6201.method_6277(4, (class_1352)this.goToGraveGoal);
        this.field_6201.method_6277(7, (class_1352)new GhostWanderGoal());
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(9, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    private void setupAnimationStates() {
        boolean attackingNow;
        boolean weeping = this.isGhostWeeping();
        boolean invisible = this.isGhostInvisible();
        int attackTimer = this.getAttackTimer();
        boolean bl = attackingNow = attackTimer > 0;
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (invisible) {
            this.weepAnimationState.method_41325();
            this.attackAnimationState.method_41325();
            this.idleAnimationState.method_41325();
            this.appearAnimationState.method_41325();
            this.invisibleAnimationState.method_41324(this.field_6012);
            return;
        }
        if (weeping) {
            this.attackAnimationState.method_41325();
            this.idleAnimationState.method_41325();
            this.appearAnimationState.method_41325();
            this.invisibleAnimationState.method_41325();
            this.weepAnimationState.method_41324(this.field_6012);
            return;
        }
        if (attackingNow) {
            if (!this.attackAnimationState.method_41327()) {
                this.attackAnimationState.method_41322(this.field_6012);
            }
            this.weepAnimationState.method_41325();
            this.idleAnimationState.method_41325();
            return;
        }
        this.weepAnimationState.method_41325();
        this.attackAnimationState.method_41325();
        this.appearAnimationState.method_41325();
        this.invisibleAnimationState.method_41325();
        this.idleAnimationState.method_41324(this.field_6012);
    }

    private void handleInvisible() {
        if (this.method_5968() instanceof class_1657) {
            if (this.getGhostInvisibleFlag()) {
                --this.invisibleTimer;
                if (this.invisibleTimer <= 0) {
                    this.method_5648(false);
                    this.setGhostInvisibleFlag(false);
                }
            } else if (this.field_5974.method_43048(300) == 0) {
                this.method_5648(true);
                this.setGhostInvisibleFlag(true);
                this.invisibleTimer = 60 + this.field_5974.method_43048(40);
            }
        } else if (this.getGhostInvisibleFlag()) {
            this.method_5648(false);
            this.setGhostInvisibleFlag(false);
        }
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long lastPoseChangeTick) {
        this.field_6011.method_12778(LAST_POSE_CHANGE_TICK, (Object)lastPoseChangeTick);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            this.handleInvisible();
            int at = this.getAttackTimer();
            if (at > 0) {
                this.setAttackTimer(at - 1);
            }
        } else {
            this.setupAnimationStates();
        }
    }

    public void weep() {
        if (!this.isGhostWeeping()) {
            this.method_18380(class_4050.field_47248);
            this.method_32876((class_6880)class_5712.field_45148);
            this.method_5783(AllhallowsSounds.GHOST_WEEP.get(), 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
            this.resetLastPoseChangeTick(-this.method_37908().method_8510());
            this.setWeeping(true);
        }
    }

    public void endWeep() {
        if (this.isGhostWeeping()) {
            this.method_18380(class_4050.field_18076);
            this.method_32876((class_6880)class_5712.field_45148);
            this.resetLastPoseChangeTick(this.method_37908().method_8510());
            this.setWeeping(false);
        }
    }

    public boolean isGhostWeeping() {
        return (Boolean)this.field_6011.method_12789(DATA_WEEPING);
    }

    public boolean isGhostInvisible() {
        return this.isInvisible;
    }

    public void setWeeping(boolean weeping) {
        this.field_6011.method_12778(DATA_WEEPING, (Object)weeping);
    }

    public boolean method_6121(class_1297 target) {
        boolean success = super.method_6121(target);
        if (success && !this.method_37908().method_8608()) {
            this.setAttackTimer(10);
            this.method_5783(AllhallowsSounds.GHOST_ATTACK.get(), 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
        }
        return success;
    }

    public int getAttackTimer() {
        return (Integer)this.field_6011.method_12789(DATA_ATTACK_TIMER);
    }

    public void setAttackTimer(int ticks) {
        this.field_6011.method_12778(DATA_ATTACK_TIMER, (Object)ticks);
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6087(class_1297 entity) {
    }

    public void setGravePos(class_2338 gravePos) {
        this.gravePos = gravePos;
    }

    public boolean hasGrave() {
        return this.gravePos != null;
    }

    @Nullable
    public class_2338 getGravePos() {
        return this.gravePos;
    }

    private boolean closerThan(class_2338 pos, double distance) {
        return this.method_24515().method_19771((class_2382)pos, distance);
    }

    private boolean isTooFarFrom(class_2338 pos) {
        return !this.closerThan(pos, 32.0);
    }

    private boolean isGraveValid() {
        if (!this.hasGrave()) {
            return false;
        }
        if (this.isTooFarFrom(this.gravePos)) {
            return false;
        }
        class_2586 blockEntity = this.method_37908().method_8321(this.gravePos);
        return blockEntity != null && blockEntity.method_11017() == AllhallowsBlockEntityTypes.GRAVESTONE.get();
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 source) {
        return false;
    }

    public boolean getGhostInvisibleFlag() {
        return (Boolean)this.field_6011.method_12789(DATA_INVISIBLE_GHOST);
    }

    public void setGhostInvisibleFlag(boolean v) {
        this.field_6011.method_12778(DATA_INVISIBLE_GHOST, (Object)v);
    }

    public void method_5951(class_1297 entity, float maxYRotIncrease, float maxXRotIncrease) {
        super.method_5951(entity, maxYRotIncrease, maxXRotIncrease);
    }

    public void method_6007() {
        super.method_6007();
        boolean bl = this.method_5972();
        if (bl) {
            class_1799 itemStack = this.method_6118(class_1304.field_6169);
            if (!itemStack.method_7960()) {
                if (itemStack.method_7963()) {
                    class_1792 item = itemStack.method_7909();
                    itemStack.method_7974(itemStack.method_7919() + this.field_5974.method_43048(2));
                    if (itemStack.method_7919() >= itemStack.method_7936()) {
                        this.method_20235(item, class_1304.field_6169);
                        this.method_5673(class_1304.field_6169, class_1799.field_8037);
                    }
                }
                bl = false;
            }
            if (bl) {
                this.method_5639(8.0f);
            }
        }
        if (!this.method_37908().field_9236) {
            if (this.remainingCooldownBeforeLocatingNewGrave > 0) {
                --this.remainingCooldownBeforeLocatingNewGrave;
            }
            if (this.field_6012 % 40 == 0 && !this.isGraveValid()) {
                this.gravePos = null;
            }
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.hasGrave()) {
            tag.method_10566("grave_pos", class_2512.method_10692((class_2338)this.gravePos));
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("grave_pos")) {
            this.gravePos = class_2512.method_10691((class_2487)tag, (String)"grave_pos").orElse(null);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_INVISIBLE_GHOST, (Object)false);
        builder.method_56912(DATA_WEEPING, (Object)false);
        builder.method_56912(LAST_POSE_CHANGE_TICK, (Object)0L);
        builder.method_56912(DATA_ATTACK_TIMER, (Object)0);
    }

    static {
        DATA_INVISIBLE_GHOST = class_2945.method_12791(GhostEntity.class, (class_2941)class_2943.field_13323);
        DATA_WEEPING = class_2945.method_12791(GhostEntity.class, (class_2941)class_2943.field_13323);
        LAST_POSE_CHANGE_TICK = class_2945.method_12791(GhostEntity.class, (class_2941)class_2943.field_39965);
        DATA_ATTACK_TIMER = class_2945.method_12791(GhostEntity.class, (class_2941)class_2943.field_13327);
    }

    public class GhostWeepGoal
    extends class_1352 {
        private final GhostEntity ghost;
        private class_1657 targetPlayer;
        private int weepDuration = 0;
        private final int maxWeepTicks = 200;
        private final float chanceToWeep = 0.33f;

        public GhostWeepGoal(GhostEntity ghost) {
            this.ghost = ghost;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18406, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.ghost.method_5968() != null) {
                return false;
            }
            if (Math.random() > (double)0.33f) {
                return false;
            }
            if (this.ghost.method_5809()) {
                return false;
            }
            class_1657 nearest = this.ghost.method_37908().method_18460((class_1297)this.ghost, 15.0);
            if (nearest == null) {
                return false;
            }
            double distance = this.ghost.method_5739((class_1297)nearest);
            if (distance > 5.0) {
                this.targetPlayer = nearest;
                this.weepDuration = 0;
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            return this.targetPlayer != null && (double)this.ghost.method_5739((class_1297)this.targetPlayer) > 5.0 && this.weepDuration < 200;
        }

        public void method_6269() {
            this.ghost.weep();
            this.ghost.setWeeping(true);
        }

        public void method_6270() {
            this.ghost.endWeep();
            this.targetPlayer = null;
            this.weepDuration = 0;
            this.ghost.setWeeping(false);
        }

        public void method_6268() {
            if (this.targetPlayer == null) {
                return;
            }
            ++this.weepDuration;
            double distance = this.ghost.method_5739((class_1297)this.targetPlayer);
            if (distance <= 5.0) {
                this.method_6270();
                return;
            }
            if (this.ghost.method_5809()) {
                this.method_6270();
                return;
            }
            double dx = this.ghost.method_23317() - this.targetPlayer.method_23317();
            double dz = this.ghost.method_23321() - this.targetPlayer.method_23321();
            float targetYaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
            float newYaw = class_3532.method_20306((float)this.ghost.method_36454(), (float)targetYaw, (float)5.0f);
            this.ghost.method_36456(newYaw);
            this.ghost.field_6241 = newYaw;
            if (!GhostEntity.this.method_37908().field_9236) {
                this.ghost.method_5942().method_6337(this.ghost.method_23317() - dx * 0.05, this.ghost.method_23318(), this.ghost.method_23321() - dz * 0.05, 1.0);
            }
        }
    }

    class GhostLocateGraveGoal
    extends class_1352 {
        private static final int SEARCH_RADIUS = 20;
        private static final int COOLDOWN_BEFORE_LOCATING_NEW_GRAVE = 200;

        public boolean method_6264() {
            return GhostEntity.this.remainingCooldownBeforeLocatingNewGrave <= 0 && GhostEntity.this.getGravePos() == null;
        }

        public void method_6269() {
            GhostEntity.this.remainingCooldownBeforeLocatingNewGrave = 200;
            Optional<class_4156> nearbyGrave = this.findNearbyGraves();
            if (nearbyGrave.isPresent()) {
                GhostEntity.this.gravePos = nearbyGrave.get().method_19141();
            }
        }

        private Optional<class_4156> findNearbyGraves() {
            class_2338 blockPos = GhostEntity.this.method_24515();
            class_4153 poiManager = ((class_3218)GhostEntity.this.method_37908()).method_19494();
            return poiManager.method_19125(holder -> holder.method_40225(AllhallowsPoiTypes.GRAVESTONE.getKey()), blockPos, 20, class_4153.class_4155.field_18489).findFirst();
        }

        public boolean method_6266() {
            return false;
        }
    }

    class GhostGoToGraveGoal
    extends class_1352 {
        private int travellingTicks;

        GhostGoToGraveGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return GhostEntity.this.gravePos != null && !GhostEntity.this.isGraveValid() && GhostEntity.this.remainingCooldownBeforeLocatingNewGrave == 0;
        }

        public boolean method_6266() {
            return GhostEntity.this.gravePos != null && !GhostEntity.this.closerThan(GhostEntity.this.gravePos, 2.0);
        }

        public void method_6269() {
            this.travellingTicks = 0;
        }

        public void method_6270() {
            this.travellingTicks = 0;
            GhostEntity.this.field_6189.method_6340();
        }

        public void method_6268() {
            if (GhostEntity.this.gravePos != null) {
                ++this.travellingTicks;
                if (!GhostEntity.this.field_6189.method_23966() && !GhostEntity.this.closerThan(GhostEntity.this.gravePos, 16.0)) {
                    GhostEntity.this.field_6189.method_6337((double)GhostEntity.this.gravePos.method_10263(), (double)GhostEntity.this.gravePos.method_10264(), (double)GhostEntity.this.gravePos.method_10260(), 1.0);
                }
                if (this.travellingTicks > 600) {
                    GhostEntity.this.gravePos = null;
                    GhostEntity.this.remainingCooldownBeforeLocatingNewGrave = 200;
                }
            }
        }
    }

    class GhostWanderGoal
    extends class_1352 {
        private static final int CHANCE_TO_WANDER = 20;
        private static final double SPEED = 1.0;
        private static final int HORIZONTAL_RANGE = 8;
        private static final int VERTICAL_RANGE = 6;

        GhostWanderGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return GhostEntity.this.method_5968() == null && GhostEntity.this.field_6189.method_6357() && GhostEntity.this.field_5974.method_43048(20) == 0 && (GhostEntity.this.gravePos == null || GhostEntity.this.method_5707(class_243.method_24953((class_2382)GhostEntity.this.gravePos)) < 64.0);
        }

        public boolean method_6266() {
            return GhostEntity.this.field_6189.method_23966();
        }

        public void method_6269() {
            class_243 pos = this.getWanderPosition();
            if (pos != null) {
                GhostEntity.this.field_6189.method_6337(pos.field_1352, pos.field_1351, pos.field_1350, 1.0);
            }
        }

        @Nullable
        private class_243 getWanderPosition() {
            class_243 lookVec = GhostEntity.this.method_5828(0.0f);
            class_243 pos = null;
            if (GhostEntity.this.gravePos != null && GhostEntity.this.method_5707(class_243.method_24953((class_2382)GhostEntity.this.gravePos)) < 128.0) {
                pos = class_5531.method_31508((class_1314)GhostEntity.this, (int)8, (int)6, (int)0, (class_243)class_243.method_24953((class_2382)GhostEntity.this.gravePos), (double)0.3141592741012573);
            }
            if (pos == null) {
                pos = class_5533.method_31524((class_1314)GhostEntity.this, (int)8, (int)6, (double)lookVec.field_1352, (double)lookVec.field_1350, (float)1.5707964f, (int)3, (int)1);
            }
            if (pos == null) {
                pos = class_5530.method_31504((class_1314)GhostEntity.this, (int)8, (int)6, (int)-2, (double)lookVec.field_1352, (double)lookVec.field_1350, (double)1.5707963705062866);
            }
            return pos;
        }
    }
}

