/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.natephantom.AllhallowsMod;
import com.natephantom.block.GravestoneBlock;
import com.natephantom.block.entity.SpinningWheelBlockEntity;
import com.natephantom.init.AllhallowsBlockEntityTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpinningWheelBlock
extends BaseEntityBlock {
    public static final MapCodec<GravestoneBlock> CODEC = SpinningWheelBlock.simpleCodec(GravestoneBlock::new);
    public static final EnumProperty<Direction> FACING;
    private static final Map<Direction, VoxelShape> SHAPES;

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public SpinningWheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SpinningWheelBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof SpinningWheelBlockEntity) {
            SpinningWheelBlockEntity spinningWheel = (SpinningWheelBlockEntity)blockEntity;
            spinningWheel.startSpinning(level, pos, player);
            AllhallowsMod.LOGGER.info(String.valueOf(spinningWheel.isSpinning) + spinningWheel.spinTimer);
        }
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.4, (double)pos.getZ() + 0.5, 0.0, 0.01, 0.0);
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        if (blockEntityType != AllhallowsBlockEntityTypes.SPINNING_WHEEL.get()) {
            return null;
        }
        return (lvl, pos, state, entity) -> {
            if (!(entity instanceof SpinningWheelBlockEntity)) {
                return;
            }
            SpinningWheelBlockEntity spinningWheel = (SpinningWheelBlockEntity)entity;
            if (!lvl.isClientSide) {
                spinningWheel.serverTick(lvl, pos, state);
            }
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue(FACING));
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    static {
        SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)12.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)12.0), (Object)Direction.WEST, (Object)Block.box((double)5.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), (Object)Direction.EAST, (Object)Block.box((double)5.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0)));
        FACING = HorizontalDirectionalBlock.FACING;
    }
}

