/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.block.entity;

import com.natephantom.init.AllhallowsBlockEntityTypes;
import com.natephantom.init.AllhallowsItems;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinningWheelBlockEntity
extends BlockEntity {
    public boolean isSpinning = false;
    public int spinTimer = 0;
    private static final int SPINNING_TIME = 100;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"allhallows");

    public SpinningWheelBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)AllhallowsBlockEntityTypes.SPINNING_WHEEL.get(), pos, blockState);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SpinningWheelBlockEntity)) {
            return;
        }
        SpinningWheelBlockEntity spinningWheel = (SpinningWheelBlockEntity)blockEntity;
        if (spinningWheel.isSpinning) {
            --spinningWheel.spinTimer;
            if (!level.isClientSide && spinningWheel.spinTimer <= 0) {
                spinningWheel.spawnItemAbove(level, pos);
            }
        }
    }

    public void startSpinning(Level level, BlockPos pos, Player player) {
        Inventory inventory = player.getInventory();
        LOGGER.info("Attempt Spinning");
        if (this.hasIngredients(player)) {
            LOGGER.info("Has Ingredients");
            this.isSpinning = true;
            this.spinTimer = 100;
            this.markUpdated(pos, level.getBlockState(pos));
            level.playSound(null, pos, SoundEvents.UI_LOOM_SELECT_PATTERN, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.displayClientMessage(Component.nullToEmpty((String)"Spinning..."), true);
            boolean removedWool = false;
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (removedWool || !stack.is(ItemTags.WOOL)) continue;
                inventory.removeItem(i, 1);
                removedWool = true;
            }
        }
    }

    private boolean hasIngredients(Player player) {
        Inventory inventory = player.getInventory();
        boolean hasWool = false;
        ArrayList<String> missingItems = new ArrayList<String>();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!stack.is(ItemTags.WOOL) || stack.getCount() <= 0) continue;
            hasWool = true;
        }
        if (!hasWool) {
            missingItems.add("Wool");
        }
        if (!missingItems.isEmpty() && !this.isSpinning) {
            player.displayClientMessage((Component)Component.translatable((String)("Missing ingredients: " + String.join((CharSequence)", ", missingItems))), true);
            return false;
        }
        if (this.isSpinning) {
            player.displayClientMessage(Component.nullToEmpty((String)"Spinning..."), true);
            return false;
        }
        return hasWool;
    }

    private void spawnItemAbove(Level level, BlockPos pos) {
        if (level != null && !level.isClientSide) {
            LOGGER.info("Finished Spin");
            ItemStack yarnItem = new ItemStack(AllhallowsItems.YARN, 4);
            this.markUpdated(pos, level.getBlockState(pos));
            this.isSpinning = false;
            this.spinTimer = 0;
            level.playSound(null, pos, SoundEvents.UI_LOOM_TAKE_RESULT, SoundSource.BLOCKS, 1.0f, 1.0f);
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 1.0;
            double z = (double)pos.getZ() + 0.5;
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, yarnItem);
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("isSpinning", this.isSpinning);
        tag.putInt("spinTimer", this.spinTimer);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.isSpinning = tag.getBoolean("isSpinning");
        this.spinTimer = tag.getInt("spinTimer");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putBoolean("isSpinning", this.isSpinning);
        tag.putInt("spinTimer", this.spinTimer);
        return tag;
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
    }

    private void markUpdated(BlockPos pos, BlockState state) {
        this.setChanged();
        this.level.sendBlockUpdated(pos, state, state, 3);
    }
}

