/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.natephantom.client.entity.animation.GhostAnimation;
import com.natephantom.entity.GhostEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class GhostModel<T extends GhostEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftArm;
    private final ModelPart rightArm;

    public GhostModel(ModelPart root) {
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.head = this.body.getChild("head");
        this.leftArm = this.body.getChild("leftArm");
        this.rightArm = this.body.getChild("rightArm");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -3.0f, 8.0f, 17.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 23).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-11.8f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(28, 0).addBox(0.0f, -2.0f, -10.0f, 4.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-10.0f, (float)1.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(32, 14).addBox(-4.0f, -2.0f, -10.0f, 4.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-10.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.animate(((GhostEntity)((Object)entity)).idleAnimationState, GhostAnimation.ANIM_GHOST_IDLE, ageInTicks);
        this.animate(((GhostEntity)((Object)entity)).attackAnimationState, GhostAnimation.ANIM_GHOST_ATTACK, ageInTicks);
        this.animate(((GhostEntity)((Object)entity)).weepAnimationState, GhostAnimation.ANIM_GHOST_WEEP, ageInTicks);
        this.animate(((GhostEntity)((Object)entity)).invisibleAnimationState, GhostAnimation.ANIM_GHOST_INVISIBLE, ageInTicks);
        this.animate(((GhostEntity)((Object)entity)).appearAnimationState, GhostAnimation.ANIM_GHOST_APPEAR, ageInTicks);
    }
}

