/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.natephantom.client.entity.animation.PumpklingAnimation;
import com.natephantom.entity.PumpklingEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class PumpklingModel<T extends PumpklingEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart leg;
    private final ModelPart front_left;
    private final ModelPart back_left;
    private final ModelPart front_right;
    private final ModelPart back_right;
    private float jumpRotation;

    public PumpklingModel(ModelPart root) {
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.leg = this.body.getChild("leg");
        this.front_left = this.leg.getChild("front_left");
        this.back_left = this.leg.getChild("back_left");
        this.front_right = this.leg.getChild("front_right");
        this.back_right = this.leg.getChild("back_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(8, 20).addBox(-1.25f, -10.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.3f, -9.0f, -4.0f, 8.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(-2.3f, -13.0f, 0.0f, 5.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leg = body.addOrReplaceChild("leg", CubeListBuilder.create(), PartPose.offset((float)-3.3f, (float)-6.0f, (float)1.0f));
        PartDefinition front_left = leg.addOrReplaceChild("front_left", CubeListBuilder.create().texOffs(8, 15).addBox(-0.95f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)4.0f, (float)-3.0f));
        PartDefinition back_left = leg.addOrReplaceChild("back_left", CubeListBuilder.create().texOffs(16, 15).addBox(-0.95f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)7.0f, (float)4.0f, (float)1.0f));
        PartDefinition front_right = leg.addOrReplaceChild("front_right", CubeListBuilder.create().texOffs(0, 15).addBox(-0.7f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)4.0f, (float)-3.0f));
        PartDefinition back_right = leg.addOrReplaceChild("back_right", CubeListBuilder.create().texOffs(0, 20).addBox(-0.7f, -1.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)4.0f, (float)1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.animate(((PumpklingEntity)((Object)entity)).sitAnimationState, PumpklingAnimation.ANIM_PUMPKLING_SITTING, ageInTicks, 1.0f);
        this.animate(((PumpklingEntity)((Object)entity)).standAnimationState, PumpklingAnimation.ANIM_PUMPKLING_STAND, ageInTicks, 1.0f);
        this.animate(((PumpklingEntity)((Object)entity)).walkAnimationState, PumpklingAnimation.ANIM_PUMPKLING_WALK, ageInTicks, 1.0f);
        this.animate(((PumpklingEntity)((Object)entity)).idleSitAnimationState, PumpklingAnimation.ANIM_PUMPKLING_IDLE_SIT, ageInTicks, 1.0f);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTick);
        if (!entity.isInSittingPose()) {
            this.jumpRotation = Mth.sin((float)(((PumpklingEntity)((Object)entity)).getJumpCompletion(partialTick) * (float)Math.PI));
        }
    }

    public ModelPart root() {
        return this.root;
    }
}

