/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.client.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.natephantom.client.entity.model.AllhallowsModelLayers;
import com.natephantom.client.entity.model.WitchHatModel;
import com.natephantom.init.AllhallowsItems;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WitchHatRenderer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final EntityModelSet modelLoader;
    private static final ResourceLocation WITCH_HAT_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"allhallows", (String)"textures/models/armor/witch_hat.png");

    public WitchHatRenderer(LivingEntityRenderer<?, ?> context, EntityModelSet loader) {
        this((RenderLayerParent<?, ?>)context, loader, 1.0f, 1.0f, 1.0f);
    }

    public WitchHatRenderer(RenderLayerParent<T, M> context, EntityModelSet loader, float scaleX, float scaleY, float scaleZ) {
        super(context);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.modelLoader = loader;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack itemStack = livingEntity.getItemBySlot(EquipmentSlot.HEAD);
        if (!itemStack.isEmpty()) {
            Item item = itemStack.getItem();
            poseStack.pushPose();
            poseStack.scale(this.scaleX, this.scaleY, this.scaleZ);
            boolean bl = livingEntity instanceof ZombieVillager;
            if (livingEntity.isBaby()) {
                poseStack.translate(0.0f, 0.03125f, 0.0f);
                poseStack.scale(0.7f, 0.7f, 0.7f);
                poseStack.translate(0.0f, 1.0f, 0.0f);
            }
            ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            if (item == AllhallowsItems.WITCH_HAT.get()) {
                if (livingEntity.isBaby()) {
                    poseStack.scale(1.3425f, 1.3425f, 1.3425f);
                    poseStack.translate(0.0f, -0.803125f, 0.0f);
                } else {
                    poseStack.scale(1.0f, 1.0f, 1.0f);
                    poseStack.translate(0.0f, -0.825f, 0.0f);
                }
                if (bl) {
                    poseStack.translate(0.0f, -0.1f, 0.0f);
                }
                WitchHatModel witchHatModel = new WitchHatModel(this.modelLoader.bakeLayer(AllhallowsModelLayers.WITCH_HAT_LAYER));
                RenderType renderLayer = RenderType.armorCutoutNoCull((ResourceLocation)WITCH_HAT_LOCATION);
                RenderType glintRenderLayer = RenderType.armorEntityGlint();
                witchHatModel.renderToBuffer(poseStack, bufferSource.getBuffer(renderLayer), packedLight, OverlayTexture.NO_OVERLAY, -1);
            }
            poseStack.popPose();
        }
    }
}

