/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.entity;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PumpklingEntity
extends TamableAnimal {
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int jumpDelayTicks;
    @Nullable
    private TemptGoal temptGoal;
    public static final EntityDataAccessor<Long> LAST_POSE_CHANGE_TICK = SynchedEntityData.defineId(PumpklingEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    public final AnimationState sitAnimationState = new AnimationState();
    public final AnimationState idleSitAnimationState = new AnimationState();
    public final AnimationState standAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;

    public PumpklingEntity(EntityType<? extends PumpklingEntity> entityType, Level level) {
        super(entityType, level);
        this.jumpControl = new PumpklingJumpControl(this);
        this.moveControl = new PumpklingMoveControl(this);
        this.setSpeedModifier(0.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.level()));
        this.goalSelector.addGoal(1, (Goal)new PumpklingPanicGoal(this, 2.2));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(3, new PumpklingAvoidEntityGoal<Chicken>(this, Chicken.class, 4.0f, 2.2, 2.2));
        this.goalSelector.addGoal(3, new PumpklingAvoidEntityGoal<Pig>(this, Pig.class, 4.0f, 2.2, 2.2));
        this.goalSelector.addGoal(4, (Goal)new PumpklingTemptGoal(this, this, 1.25, Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH}), false));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 3.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.FOX_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.FOX_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.MAGMA_CUBE_SQUISH_SMALL;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.level().isClientSide) {
            this.setOrderedToSit(false);
            this.standUpInstantly();
        }
        return super.hurt(source, amount);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult interactionResult;
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)player)) {
                if (this.isFood(itemStack) && this.getHealth() < this.getMaxHealth()) {
                    if (!this.level().isClientSide()) {
                        this.usePlayerItem(player, hand, itemStack);
                        FoodProperties foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD);
                        this.heal(foodProperties != null ? (float)foodProperties.nutrition() : 1.0f);
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                InteractionResult interactionResult2 = super.mobInteract(player, hand);
                if (!interactionResult2.consumesAction()) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    if (this.isOrderedToSit()) {
                        this.sitDown();
                    } else {
                        this.standUp();
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                return interactionResult2;
            }
        } else if (this.isFood(itemStack)) {
            if (!this.level().isClientSide()) {
                this.usePlayerItem(player, hand, itemStack);
                this.tryToTame(player);
                this.setPersistenceRequired();
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if ((interactionResult = super.mobInteract(player, hand)).consumesAction()) {
            this.setPersistenceRequired();
        }
        return interactionResult;
    }

    private void setupAnimationStates() {
        this.idleAnimationTimeout = this.idleAnimationTimeout <= 0 ? this.random.nextInt(40) + 80 : --this.idleAnimationTimeout;
        if (this.isPumpklingSitting()) {
            this.standAnimationState.stop();
            this.walkAnimationState.stop();
            if (this.isInPoseTransition()) {
                this.sitAnimationState.startIfStopped(this.tickCount);
                this.idleSitAnimationState.stop();
            } else {
                this.sitAnimationState.stop();
                this.idleSitAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.sitAnimationState.stop();
            this.idleSitAnimationState.stop();
            this.standAnimationState.animateWhen(this.isInPoseTransition() && this.getPoseTime() >= 0L, this.tickCount);
        }
        boolean canWalk = !this.isVisuallySittingDown() && (this.jumping || this.getDeltaMovement().horizontalDistanceSqr() > 0.001);
        this.walkAnimationState.animateWhen(canWalk, this.tickCount);
    }

    protected void updateWalkAnimation(float partialTick) {
        float f = this.getPose() == Pose.STANDING ? Math.min(partialTick * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    protected void tickRidden(Player player, Vec3 travelVector) {
        super.tickRidden(player, travelVector);
        if (player.zza > 0.0f && this.isPumpklingSitting() && !this.isInPoseTransition()) {
            this.standUp();
        }
    }

    private boolean isVisuallySittingDown() {
        return this.isPumpklingSitting() && this.getPoseTime() < 40L && this.getPoseTime() >= 0L;
    }

    public boolean isInPoseTransition() {
        long l = this.getPoseTime();
        return l < (long)(this.isPumpklingSitting() ? 12 : 25);
    }

    public long getPoseTime() {
        return this.level().getGameTime() - Math.abs((Long)this.entityData.get(LAST_POSE_CHANGE_TICK));
    }

    public boolean isPumpklingSitting() {
        return (Long)this.entityData.get(LAST_POSE_CHANGE_TICK) < 0L;
    }

    public void sitDown() {
        if (!this.isPumpklingSitting()) {
            this.makeSound(SoundEvents.SLIME_SQUISH_SMALL);
            this.setPose(Pose.SITTING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(-this.level().getGameTime());
        }
    }

    public void standUp() {
        if (this.isPumpklingSitting()) {
            this.makeSound(SoundEvents.FOX_AMBIENT);
            this.setPose(Pose.STANDING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.resetLastPoseChangeTick(this.level().getGameTime());
        }
    }

    public void standUpInstantly() {
        this.setPose(Pose.STANDING);
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.resetLastPoseChangeTickToFullStand(this.level().getGameTime());
    }

    @VisibleForTesting
    public void resetLastPoseChangeTick(long lastPoseChangeTick) {
        this.entityData.set(LAST_POSE_CHANGE_TICK, (Object)lastPoseChangeTick);
    }

    private void resetLastPoseChangeTickToFullStand(long lastPoseChangedTick) {
        this.resetLastPoseChangeTick(Math.max(0L, lastPoseChangedTick - 52L - 1L));
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(Items.TORCH);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        return null;
    }

    private void tryToTame(Player player) {
        if (this.random.nextInt(3) == 0) {
            this.tame(player);
            this.setOrderedToSit(true);
            this.sitDown();
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LAST_POSE_CHANGE_TICK, (Object)0L);
    }

    public void tick() {
        super.tick();
        if (this.temptGoal != null && this.temptGoal.isRunning() && !this.isTame() && this.tickCount % 100 == 0) {
            this.playSound(SoundEvents.FOX_SNIFF, 1.0f, 1.0f);
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    protected float getJumpPower() {
        Path path;
        float f = 0.3f;
        if (this.horizontalCollision || this.moveControl.hasWanted() && this.moveControl.getWantedY() > this.getY() + 0.5) {
            f = 0.5f;
        }
        if ((path = this.navigation.getPath()) != null && !path.isDone()) {
            Vec3 vec3 = path.getNextEntityPos((Entity)this);
            if (vec3.y > this.getY() + 0.5) {
                f = 0.5f;
            }
        }
        if (this.moveControl.getSpeedModifier() <= 0.6) {
            f = 0.2f;
        }
        return super.getJumpPower(f / 0.42f);
    }

    public void setSpeedModifier(double speedModifier) {
        this.getNavigation().setSpeedModifier(speedModifier);
        this.moveControl.setWantedPosition(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ(), speedModifier);
    }

    public void jumpFromGround() {
        double e;
        super.jumpFromGround();
        double d = this.moveControl.getSpeedModifier();
        if (d > 0.0 && (e = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)1);
        }
    }

    public float getJumpCompletion(float partialTick) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + partialTick) / (float)this.jumpDuration;
    }

    public void startJumping() {
        this.setJumping(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void customServerAiStep() {
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if (this.onGround()) {
            PumpklingJumpControl pumpklingJumpControl;
            if (!this.wasOnGround) {
                this.setJumping(false);
                this.checkLandingDelay();
            }
            if (!(pumpklingJumpControl = (PumpklingJumpControl)this.jumpControl).wantJump()) {
                if (this.moveControl.hasWanted() && this.jumpDelayTicks == 0) {
                    Path path = this.navigation.getPath();
                    Vec3 vec3 = new Vec3(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ());
                    if (path != null && !path.isDone()) {
                        vec3 = path.getNextEntityPos((Entity)this);
                    }
                    this.facePoint(vec3.x, vec3.z);
                    this.startJumping();
                }
            } else if (!pumpklingJumpControl.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.onGround();
    }

    private void facePoint(double x, double z) {
        this.setYRot((float)(Mth.atan2((double)(z - this.getZ()), (double)(x - this.getX())) * 57.2957763671875) - 90.0f);
    }

    private void enableJumpControl() {
        ((PumpklingJumpControl)this.jumpControl).setCanJump(true);
    }

    private void disableJumpControl() {
        ((PumpklingJumpControl)this.jumpControl).setCanJump(false);
    }

    private void setLandingDelay() {
        this.jumpDelayTicks = this.moveControl.getSpeedModifier() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.setLandingDelay();
        this.disableJumpControl();
    }

    public void aiStep() {
        super.aiStep();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 1) {
            this.spawnSprintParticle();
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putLong("LastPoseTick", ((Long)this.entityData.get(LAST_POSE_CHANGE_TICK)).longValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        long l = compound.getLong("LastPoseTick");
        if (l < 0L) {
            this.setPose(Pose.SITTING);
        }
        this.resetLastPoseChangeTick(l);
    }

    public static class PumpklingJumpControl
    extends JumpControl {
        private final PumpklingEntity pumpkling;
        private boolean canJump;

        public PumpklingJumpControl(PumpklingEntity pumpkling) {
            super((Mob)pumpkling);
            this.pumpkling = pumpkling;
        }

        public boolean wantJump() {
            return this.jump;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void tick() {
            if (this.jump) {
                this.pumpkling.startJumping();
                this.jump = false;
            }
        }
    }

    private static class PumpklingMoveControl
    extends MoveControl {
        private final PumpklingEntity pumpkling;
        private double nextJumpSpeed;

        public PumpklingMoveControl(PumpklingEntity pumpkling) {
            super((Mob)pumpkling);
            this.pumpkling = pumpkling;
        }

        public void tick() {
            if (this.pumpkling.onGround() && !this.pumpkling.jumping && !((PumpklingJumpControl)this.pumpkling.jumpControl).wantJump()) {
                this.pumpkling.setSpeedModifier(0.0);
            } else if (this.hasWanted()) {
                this.pumpkling.setSpeedModifier(this.nextJumpSpeed);
            }
            super.tick();
        }

        public void setWantedPosition(double x, double y, double z, double speed) {
            if (this.pumpkling.isInWater()) {
                speed = 1.5;
            }
            super.setWantedPosition(x, y, z, speed);
            if (speed > 0.0) {
                this.nextJumpSpeed = speed;
            }
        }
    }

    static class PumpklingPanicGoal
    extends PanicGoal {
        private final PumpklingEntity pumpkling;

        public PumpklingPanicGoal(PumpklingEntity pumpkling, double speedModifier) {
            super((PathfinderMob)pumpkling, speedModifier);
            this.pumpkling = pumpkling;
        }

        public void tick() {
            super.tick();
            this.pumpkling.setSpeedModifier(this.speedModifier);
        }
    }

    static class PumpklingAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final PumpklingEntity pumpkling;

        public PumpklingAvoidEntityGoal(PumpklingEntity pumpkling, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super((PathfinderMob)pumpkling, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier);
            this.pumpkling = pumpkling;
        }
    }

    public class PumpklingTemptGoal
    extends TemptGoal {
        private final PumpklingEntity pumpkling;

        public PumpklingTemptGoal(PumpklingEntity this$0, PumpklingEntity mob, double speedModifier, Ingredient items, boolean canScare) {
            super((PathfinderMob)mob, speedModifier, (Predicate)items, canScare);
            this.pumpkling = mob;
        }

        public boolean canUse() {
            return !this.pumpkling.isPumpklingSitting() && super.canUse();
        }

        public boolean canContinueToUse() {
            return !this.pumpkling.isPumpklingSitting() && super.canContinueToUse();
        }
    }
}

