/*
 * Decompiled with CFR 0.152.
 */
package com.natephantom.block.entity;

import com.natephantom.init.AllhallowsBlockEntityTypes;
import com.natephantom.init.AllhallowsItems;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpinningWheelBlockEntity
extends class_2586 {
    public boolean isSpinning = false;
    public int spinTimer = 0;
    private static final int SPINNING_TIME = 100;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"allhallows");

    public SpinningWheelBlockEntity(class_2338 pos, class_2680 blockState) {
        super((class_2591)AllhallowsBlockEntityTypes.SPINNING_WHEEL.get(), pos, blockState);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof SpinningWheelBlockEntity)) {
            return;
        }
        SpinningWheelBlockEntity spinningWheel = (SpinningWheelBlockEntity)class_25862;
        if (spinningWheel.isSpinning) {
            --spinningWheel.spinTimer;
            if (!level.field_9236 && spinningWheel.spinTimer <= 0) {
                spinningWheel.spawnItemAbove(level, pos);
            }
        }
    }

    public void startSpinning(class_1937 level, class_2338 pos, class_1657 player) {
        class_1661 inventory = player.method_31548();
        LOGGER.info("Attempt Spinning");
        if (this.hasIngredients(player)) {
            LOGGER.info("Has Ingredients");
            this.isSpinning = true;
            this.spinTimer = 100;
            this.markUpdated(pos, level.method_8320(pos));
            level.method_8396(null, pos, class_3417.field_14920, class_3419.field_15245, 1.0f, 1.0f);
            player.method_7353(class_2561.method_30163((String)"Spinning..."), true);
            boolean removedWool = false;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                if (removedWool || !stack.method_31573(class_3489.field_15544)) continue;
                inventory.method_5434(i, 1);
                removedWool = true;
            }
        }
    }

    private boolean hasIngredients(class_1657 player) {
        class_1661 inventory = player.method_31548();
        boolean hasWool = false;
        ArrayList<String> missingItems = new ArrayList<String>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_31573(class_3489.field_15544) || stack.method_7947() <= 0) continue;
            hasWool = true;
        }
        if (!hasWool) {
            missingItems.add("Wool");
        }
        if (!missingItems.isEmpty() && !this.isSpinning) {
            player.method_7353((class_2561)class_2561.method_43471((String)("Missing ingredients: " + String.join((CharSequence)", ", missingItems))), true);
            return false;
        }
        if (this.isSpinning) {
            player.method_7353(class_2561.method_30163((String)"Spinning..."), true);
            return false;
        }
        return hasWool;
    }

    private void spawnItemAbove(class_1937 level, class_2338 pos) {
        if (level != null && !level.field_9236) {
            LOGGER.info("Finished Spin");
            class_1799 yarnItem = new class_1799(AllhallowsItems.YARN, 4);
            this.markUpdated(pos, level.method_8320(pos));
            this.isSpinning = false;
            this.spinTimer = 0;
            level.method_8396(null, pos, class_3417.field_15096, class_3419.field_15245, 1.0f, 1.0f);
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5;
            class_1542 itemEntity = new class_1542(level, x, y, z, yarnItem);
            level.method_8649((class_1297)itemEntity);
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        tag.method_10556("isSpinning", this.isSpinning);
        tag.method_10569("spinTimer", this.spinTimer);
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.isSpinning = tag.method_10577("isSpinning");
        this.spinTimer = tag.method_10550("spinTimer");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        tag.method_10556("isSpinning", this.isSpinning);
        tag.method_10569("spinTimer", this.spinTimer);
        return tag;
    }

    public void method_57569(class_2487 tag) {
        super.method_57569(tag);
    }

    private void markUpdated(class_2338 pos, class_2680 state) {
        this.method_5431();
        this.field_11863.method_8413(pos, state, state, 3);
    }
}

