/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.common.mode;

import de.nekeras.borderless.common.glfw.GlfwUtils;
import de.nekeras.borderless.common.glfw.GlfwWindowAttribute;
import de.nekeras.borderless.common.mode.FullscreenDisplayMode;
import de.nekeras.borderless.common.spi.MinecraftMonitor;
import de.nekeras.borderless.common.spi.MinecraftVideoMode;
import de.nekeras.borderless.common.spi.MinecraftWindow;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeWindowedFullscreenDisplay
implements FullscreenDisplayMode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NativeWindowedFullscreenDisplay.class);

    @Override
    public void apply(@Nonnull MinecraftWindow window) {
        FullscreenDisplayMode.super.apply(window);
        GlfwUtils.disableWindowAttribute(window, GlfwWindowAttribute.AUTO_ICONIFY);
        GLFW.glfwSetWindowAttrib((long)window.getHandle(), (int)131078, (int)0);
        GLFW.glfwSetWindowFocusCallback((long)window.getHandle(), (win, focused) -> {
            if (focused) {
                this.onFocusGained(window);
            } else {
                this.onFocusLost(window);
            }
        });
    }

    @Override
    public void reset(@Nonnull MinecraftWindow window) {
        FullscreenDisplayMode.super.reset(window);
        GLFW.glfwSetWindowFocusCallback((long)window.getHandle(), null);
    }

    private void onFocusGained(@Nonnull MinecraftWindow window) {
        MinecraftMonitor monitor = GlfwUtils.tryGetMonitor(window).orElse(null);
        if (monitor == null) {
            log.error("Could not find monitor for window");
        } else {
            MinecraftVideoMode videoMode = window.getPreferredFullscreenVideoMode().orElseGet(monitor::getCurrentMode);
            GLFW.glfwSetWindowMonitor((long)window.getHandle(), (long)monitor.getHandle(), (int)0, (int)0, (int)videoMode.getWidth(), (int)videoMode.getHeight(), (int)videoMode.getRefreshRate());
        }
    }

    private void onFocusLost(@Nonnull MinecraftWindow window) {
        GLFW.glfwSetWindowMonitor((long)window.getHandle(), (long)0L, (int)window.getX(), (int)window.getY(), (int)window.getWidth(), (int)window.getHeight(), (int)-1);
    }
}

