/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.forge.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import de.nekeras.borderless.common.FullscreenDisplayModeHolder;
import de.nekeras.borderless.common.spi.ConfigProvider;
import de.nekeras.borderless.common.spi.MinecraftWindow;
import de.nekeras.borderless.forge.client.ForgeReflectionUtils;
import de.nekeras.borderless.forge.client.listener.SizeChangedWindowEventHandler;
import de.nekeras.borderless.forge.client.provider.ForgeConfigProvider;
import de.nekeras.borderless.forge.client.provider.ForgeWindow;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public final class BorderlessWindowClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BorderlessWindowClient.class);
    private static final Window unwrappedWindow = Minecraft.getInstance().getWindow();
    private static final MinecraftWindow window = new ForgeWindow(unwrappedWindow);
    private static final ConfigProvider configProvider = new ForgeConfigProvider();
    private static final FullscreenDisplayModeHolder displayModeHolder = new FullscreenDisplayModeHolder(configProvider, window);

    private BorderlessWindowClient() {
    }

    public static void initMinecraft() {
        log.info("Overwriting Minecraft WindowEventListener");
        ForgeReflectionUtils.updateWindowEventListener(unwrappedWindow, oldListener -> new SizeChangedWindowEventHandler((WindowEventHandler)oldListener, displayModeHolder::setFullscreenDisplayModeFromConfig));
        log.info("Overwrite finished");
        displayModeHolder.setFullscreenDisplayModeFromConfig();
    }

    @Generated
    public static FullscreenDisplayModeHolder getDisplayModeHolder() {
        return displayModeHolder;
    }
}

