/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.forge.client.config;

import javax.annotation.Nonnull;
import lombok.Generated;
import net.minecraft.util.OptionEnum;

public enum FullscreenModeConfig implements OptionEnum
{
    BEST(0, "The best suitable fullscreen mode for the current operating system."),
    BORDERLESS(1, "A borderless fullscreen which sets the width and height of the window to the monitor's video mode and removing window borders."),
    NATIVE(2, "A native fullscreen which changes the monitor's window mode in order to apply the fullscreen. Focus loss behaviour can be manually configured using the 'focusLoss' option.");

    private static final String BASE_KEY = "borderless.config.fullscreen_mode.%s";
    private final int id;
    private final String comment;
    private final String translationKey;

    private FullscreenModeConfig(int id, String comment) {
        this.id = id;
        this.comment = comment;
        this.translationKey = String.format(BASE_KEY, this.name().toLowerCase());
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getKey() {
        return this.translationKey;
    }

    public String toString() {
        return this.translationKey;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }
}

