/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.api.screens;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.VersionUtils;
import studio.archetype.shutter.api.config.enums.MessageType;
import studio.archetype.shutter.api.config.enums.RecordingMode;
import studio.archetype.shutter.api.rendering.Messaging;
import studio.archetype.shutter.config.FfmpegRecordConfig;
import studio.archetype.shutter.pathing.CameraPathManager;
import studio.archetype.shutter.pathing.exceptions.PathTooSmallException;
import studio.archetype.shutter.recording.jobs.Jobs;
import studio.archetype.shutter.ui.widgets.PredicateTextboxWidget;
import studio.archetype.shutter.ui.widgets.TickTimeTextboxWidget;
import studio.archetype.shutter.util.Abstraction;
import studio.archetype.shutter.utils.AsyncUtils;
import studio.archetype.shutter.utils.TimeUnits;
import studio.archetype.shutter.utils.cli.CliUtils;

public abstract class AbstractRecordingScreen
extends class_437 {
    protected static final class_2561 TEXT_TITLE = new class_2588("ui.shutter.recording.title");
    protected static final class_2561 TEXT_SKIP = new class_2588("ui.shutter.recording.skip");
    protected static final class_2561 TEXT_START = new class_2588("ui.shutter.recording.start").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067});
    protected static final class_2561 TEXT_PATHTIME = new class_2588("ui.shutter.recording.pathtime");
    protected static final class_2561 TEXT_FILENAME = new class_2588("ui.shutter.recording.filename");
    protected static final String STRING_CODEC = class_1074.method_4662((String)"ui.shutter.recording.codec", (Object[])new Object[0]);
    protected static final String STRING_RENDER_MODE = class_1074.method_4662((String)"ui.shutter.recording.rendermode", (Object[])new Object[0]);
    protected static final String STRING_FRAMERATE = class_1074.method_4662((String)"ui.shutter.recording.framerate", (Object[])new Object[0]);
    protected static final String STRING_PRESET = class_1074.method_4662((String)"ui.shutter.recording.preset", (Object[])new Object[0]);
    protected FfmpegRecordConfig config;
    private TickTimeTextboxWidget pathTime;
    private PredicateTextboxWidget filename;
    private class_4185 startButton;
    private class_4286 skipCountdown;
    private int ticks;
    private String name;
    private CompletableFuture<Void> dummyFuture;
    private CompletableFuture<Boolean> ffmpegAvailable;
    protected class_4185.class_4241 START_ACTION = b -> {
        this.config.pathTimeTicks = this.pathTime.getTicks();
        class_310.method_1551().field_1755 = null;
        this.name = this.filename.method_1882();
        try {
            if (this.config.renderMode != RecordingMode.FRAMES && !this.ffmpegAvailable.get().booleanValue()) {
                Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.rec.failed", "msg.shutter.error.no_ffmpeg", new Object[0]);
                return;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (this.skipCountdown.method_20372()) {
            this.onCountdownDone.accept(null);
        } else {
            this.ticks = 60;
            this.dummyFuture = new CompletableFuture();
            AsyncUtils.queueAsync(this.dummyFuture, this.onCountdownDone, (Runnable)this.onCountdownTick);
        }
    };
    private final Runnable onCountdownTick = () -> {
        class_310 c = class_310.method_1551();
        if (this.ticks == 0) {
            VersionUtils.INSTANCE.clearTitle();
            this.dummyFuture.complete(null);
        } else {
            if (this.ticks == 60) {
                AbstractRecordingScreen.displayCountdownTitle(c, 3);
            }
            if (this.ticks == 40) {
                AbstractRecordingScreen.displayCountdownTitle(c, 2);
            }
            if (this.ticks == 20) {
                AbstractRecordingScreen.displayCountdownTitle(c, 1);
            }
            --this.ticks;
        }
    };
    private final Consumer<Void> onCountdownDone = v -> this.startRecording((class_1937)class_310.method_1551().field_1687, this.name);

    protected AbstractRecordingScreen(FfmpegRecordConfig config) {
        super(TEXT_TITLE);
        this.config = config;
    }

    protected void method_25426() {
        this.pathTime = this.createTickTimeWidget();
        this.filename = this.createFilenameWidget();
        this.method_20085((class_364)this.filename);
        this.startButton = this.createStartButton();
        this.skipCountdown = this.createSkipCountdownWidget();
        this.registerEnumWidgets();
        this.ffmpegAvailable = CliUtils.isCommandAvailableAsync((String)"ffmpeg");
    }

    public void method_25410(class_310 client, int width, int height) {
        String filename = this.filename.method_1882();
        String speed = this.pathTime.method_1882();
        TimeUnits unit = this.pathTime.getCurrentUnit();
        boolean toggleSkip = this.skipCountdown.method_20372();
        this.method_25423(client, width, height);
        this.filename.method_1852(filename);
        this.pathTime.method_1852(speed);
        this.pathTime.updateUnit(unit);
        if (toggleSkip) {
            this.skipCountdown.method_25306();
        }
    }

    public void method_25393() {
        this.pathTime.method_1865();
        this.filename.method_1865();
        this.startButton.field_22763 = this.pathTime.isValid() && this.filename.isValid();
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        AbstractRecordingScreen.method_27534((class_4587)matrices, (class_327)this.field_22793, (class_2561)this.field_22785, (int)(this.field_22789 / 2), (int)25, (int)class_124.field_1068.method_532());
        this.pathTime.method_25394(matrices, mouseX, mouseY, delta);
        this.filename.method_25394(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    protected abstract TickTimeTextboxWidget createTickTimeWidget();

    protected abstract PredicateTextboxWidget createFilenameWidget();

    protected abstract class_4185 createStartButton();

    protected abstract class_4286 createSkipCountdownWidget();

    protected abstract void registerEnumWidgets();

    private void startRecording(class_1937 w, String name) {
        try {
            CameraPathManager manager = Client.INSTANCE.getPathManager(Abstraction.worldId(w));
            if (manager.isVisualizing()) {
                manager.togglePathVisualization(false);
            }
            manager.startCameraPath((double)this.config.pathTimeTicks, false);
            Jobs.createNewJob((int)this.config.framerate.value, (String)name);
        }
        catch (PathTooSmallException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.not_enough_start", new Object[0]);
        }
    }

    private static void displayCountdownTitle(class_310 c, int seconds) {
        class_2585 class_25852 = new class_2585(String.valueOf(seconds));
        class_124[] class_124Array = new class_124[2];
        class_124Array[0] = class_124.field_1067;
        class_124Array[1] = switch (seconds) {
            case 3 -> class_124.field_1060;
            case 2 -> class_124.field_1054;
            case 1 -> class_124.field_1061;
            default -> class_124.field_1080;
        };
        class_5250 sec = class_25852.method_27695(class_124Array);
        class_5250 title = new class_2588("ui.shutter.recording.countdown1", new Object[]{sec}).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        class_5250 subtitle = new class_2588("ui.shutter.recording.countdown2").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080));
        VersionUtils.INSTANCE.setTitle((class_2561)title, (class_2561)subtitle, -1, 19, -1);
        c.field_1724.method_5783(class_3417.field_14627, 1.0f, 1.0f);
    }
}

