/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.cmd;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import studio.archetype.shutter.FabricClient;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.config.enums.MessageType;
import studio.archetype.shutter.api.rendering.Messaging;
import studio.archetype.shutter.cmd.PathTimeArgumentType;
import studio.archetype.shutter.config.ClientConfigManager;
import studio.archetype.shutter.config.ShutterClientConfig;
import studio.archetype.shutter.math.Vec3d;
import studio.archetype.shutter.pathing.CameraPathManager;
import studio.archetype.shutter.pathing.exceptions.PathEmptyException;
import studio.archetype.shutter.pathing.exceptions.PathNotFollowingException;
import studio.archetype.shutter.pathing.exceptions.PathTooSmallException;
import studio.archetype.shutter.recording.jobs.Jobs;
import studio.archetype.shutter.util.TimingUtils;
import studio.archetype.shutter.utils.Identifier;

public final class PathControlCommands {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"s").requires(src -> src.method_9259(4))).then(ClientCommandManager.literal((String)"help").executes(PathControlCommands::printHelp))).then(ClientCommandManager.literal((String)"?").executes(PathControlCommands::printHelp))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"record").executes(PathControlCommands::openRecording)).then(ClientCommandManager.literal((String)"abort").executes(PathControlCommands::abortRecording)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"start").executes(ctx -> PathControlCommands.startPath((CommandContext<FabricClientCommandSource>)ctx, ClientConfigManager.CLIENT_CONFIG.genSettings.pathTime, false))).then(ClientCommandManager.argument((String)"loop", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PathControlCommands.startPath((CommandContext<FabricClientCommandSource>)ctx, ClientConfigManager.CLIENT_CONFIG.genSettings.pathTime, BoolArgumentType.getBool((CommandContext)ctx, (String)"loop"))))).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"time", (ArgumentType)PathTimeArgumentType.pathTime()).executes(ctx -> PathControlCommands.startPath((CommandContext<FabricClientCommandSource>)ctx, PathTimeArgumentType.getTicks(ctx, "time"), false))).then(ClientCommandManager.argument((String)"loop", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PathControlCommands.startPath((CommandContext<FabricClientCommandSource>)ctx, PathTimeArgumentType.getTicks(ctx, "time"), BoolArgumentType.getBool((CommandContext)ctx, (String)"loop"))))))).then(ClientCommandManager.literal((String)"offset").executes(PathControlCommands::offsetPath))).then(ClientCommandManager.literal((String)"stop").executes(PathControlCommands::stopPath))).then(ClientCommandManager.literal((String)"clear").executes(PathControlCommands::clearPath))).then(ClientCommandManager.literal((String)"config").executes(PathControlCommands::openConfig)));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"shutter").redirect((CommandNode)node));
    }

    private static int printHelp(CommandContext<FabricClientCommandSource> ctx) {
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)new class_2588("msg.shutter.help.header"));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s select", "msg.shutter.help.cmd.select", Collections.singletonMap("path", true));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s start", "msg.shutter.help.cmd.start", (Map<String, Boolean>)ImmutableMap.of((Object)"time", (Object)true, (Object)"loop", (Object)true));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s stop", "msg.shutter.help.cmd.stop", null);
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s record", "msg.shutter.help.cmd.record", null);
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s clear", "msg.shutter.help.cmd.clear", null);
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s offset", "msg.shutter.help.cmd.offset", null);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)new class_2588("msg.shutter.help.line"));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s add", "msg.shutter.help.cmd.add", null);
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s set", "msg.shutter.help.cmd.set", Collections.singletonMap("index", false));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s remove", "msg.shutter.help.cmd.remove", Collections.singletonMap("index", false));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s goto", "msg.shutter.help.cmd.goto", Collections.singletonMap("index", false));
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)new class_2588("msg.shutter.help.line"));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s show", "msg.shutter.help.cmd.show", Collections.singletonMap("loop", true));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s hide", "msg.shutter.help.cmd.hide", null);
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s toggle", "msg.shutter.help.cmd.toggle", Collections.singletonMap("loop", true));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s config", "msg.shutter.help.cmd.config", null);
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)new class_2588("msg.shutter.help.line"));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s export", "msg.shutter.help.cmd.export", Collections.singletonMap("file", true));
        PathControlCommands.sendCommandHelpLine((FabricClientCommandSource)ctx.getSource(), "/s import", "msg.shutter.help.cmd.import", (Map<String, Boolean>)ImmutableMap.of((Object)"file", (Object)false, (Object)"relative", (Object)true));
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)new class_2588("msg.shutter.help.line"));
        return 1;
    }

    private static int startPath(CommandContext<FabricClientCommandSource> ctx, double pathTime, boolean loop) {
        try {
            CameraPathManager manager = Client.INSTANCE.getPathManager(Identifier.of((String)((FabricClientCommandSource)ctx.getSource()).getWorld().method_27983().method_29177().toString()));
            ClientConfigManager.CLIENT_CONFIG.genSettings.pathTime = pathTime;
            if (manager.isVisualizing() && loop) {
                manager.togglePathVisualization(true);
                manager.togglePathVisualization(true);
            }
            manager.startCameraPath(pathTime, loop);
            return 1;
        }
        catch (PathTooSmallException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.not_enough_start", new Object[0]);
            return 0;
        }
    }

    private static int stopPath(CommandContext<FabricClientCommandSource> ctx) {
        try {
            CameraPathManager manager = FabricClient.INSTANCE.getPathManager(Identifier.of((String)((FabricClientCommandSource)ctx.getSource()).getWorld().method_27983().method_29177().toString()));
            manager.stopCameraPath();
            Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.stopped_following", new Object[0]);
            return 1;
        }
        catch (PathNotFollowingException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEUTRAL, "msg.shutter.headline.cmd.failed", "msg.shutter.error.not_following", new Object[0]);
            return 0;
        }
    }

    private static int clearPath(CommandContext<FabricClientCommandSource> ctx) {
        try {
            FabricClient.INSTANCE.getPathManager(Identifier.of((String)((FabricClientCommandSource)ctx.getSource()).getWorld().method_27983().method_29177().toString())).clearPath(false);
            Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.path_cleared", new Object[0]);
            return 1;
        }
        catch (PathEmptyException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEUTRAL, "msg.shutter.headline.cmd.failed", "msg.shutter.error.path_empty", new Object[0]);
            return 0;
        }
    }

    private static int offsetPath(CommandContext<FabricClientCommandSource> ctx) {
        CameraPathManager manager = FabricClient.INSTANCE.getPathManager(Identifier.of((String)((FabricClientCommandSource)ctx.getSource()).getWorld().method_27983().method_29177().toString()));
        if (manager.getCurrentPath().getNodes().isEmpty()) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.offset_empty", new Object[0]);
            return 1;
        }
        class_4184 cam = ((FabricClientCommandSource)ctx.getSource()).getClient().field_1773.method_19418();
        Vec3d pos = new Vec3d(cam.method_19326().field_1352, cam.method_19326().field_1351, cam.method_19326().field_1350);
        manager.getCurrentPath().offset(pos);
        Messaging.INSTANCE.sendMessageWithPos(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.offset", pos, new Object[0]);
        return 1;
    }

    private static void sendCommandHelpLine(FabricClientCommandSource source, String command, String descriptor, Map<String, Boolean> arguments) {
        class_2585 hover = new class_2585("");
        if (arguments != null) {
            ArrayList args = new ArrayList();
            arguments.forEach((a, d) -> {
                String arg = "msg.shutter.help.arg." + a;
                args.add(new class_2585(d != false ? "[" : "<").method_10852((class_2561)new class_2588(arg)).method_10852((class_2561)new class_2585(d != false ? "]: " : ">: ")).method_10852((class_2561)new class_2588(arg + ".desc")));
            });
            ListIterator argsIt = args.listIterator();
            while (argsIt.hasNext()) {
                hover.method_10852((class_2561)argsIt.next());
                if (!argsIt.hasNext()) continue;
                hover.method_10852((class_2561)new class_2585("\n"));
            }
            argsIt.remove();
            args.clear();
        } else {
            hover.method_10852((class_2561)new class_2588("msg.shutter.help.arg.none"));
        }
        class_5250 ult = new class_2585("\u00a72" + command + " \u00a78- \u00a7r").method_10852((class_2561)new class_2588(descriptor)).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover.method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}))).method_10977(class_124.field_1080));
        source.sendFeedback((class_2561)ult);
    }

    private static int openConfig(CommandContext<FabricClientCommandSource> ctx) {
        TimingUtils.schedule(1, () -> {
            ConfigScreenProvider provider = (ConfigScreenProvider)AutoConfig.getConfigScreen(ShutterClientConfig.class, (class_437)((FabricClientCommandSource)ctx.getSource()).getClient().field_1755);
            provider.setOptionFunction((gen, field) -> "config.shutter." + field.getName());
            ((FabricClientCommandSource)ctx.getSource()).getClient().method_1507(provider.get());
        });
        return 1;
    }

    private static int openRecording(CommandContext<FabricClientCommandSource> ctx) {
        TimingUtils.schedule(1, () -> Client.INSTANCE.createRecordScreen());
        return 1;
    }

    private static int abortRecording(CommandContext<FabricClientCommandSource> ctx) {
        try {
            if (Jobs.abortRecording((CameraPathManager)FabricClient.INSTANCE.getPathManager(Identifier.of((String)((FabricClientCommandSource)ctx.getSource()).getWorld().method_27983().method_29177().toString())))) {
                Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.abort_rec", new Object[0]);
            } else {
                Messaging.INSTANCE.sendMessage(MessageType.NEUTRAL, "msg.shutter.headline.cmd.failed", "msg.shutter.error.abort_fail", new Object[0]);
            }
        }
        catch (PathNotFollowingException pathNotFollowingException) {
            // empty catch block
        }
        return 1;
    }
}

