/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.cmd;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.IOException;
import net.fabricmc.fabric.api.client.command.v1.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v1.FabricClientCommandSource;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import studio.archetype.shutter.FabricClient;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.config.enums.MessageType;
import studio.archetype.shutter.api.rendering.Messaging;
import studio.archetype.shutter.math.Vec3d;
import studio.archetype.shutter.pathing.CameraPath;
import studio.archetype.shutter.pathing.CameraPathManager;
import studio.archetype.shutter.pathing.exceptions.PathException;
import studio.archetype.shutter.util.Abstraction;
import studio.archetype.shutter.utils.Identifier;

public final class PathManagementCommands {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"s").requires(src -> src.method_9259(4))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"select").executes(ctx -> PathManagementCommands.selectPath((CommandContext<FabricClientCommandSource>)ctx, CameraPathManager.DEFAULT_PATH))).then(ClientCommandManager.argument((String)"path", (ArgumentType)StringArgumentType.word()).executes(ctx -> PathManagementCommands.selectPath((CommandContext<FabricClientCommandSource>)ctx, Client.id((String)StringArgumentType.getString((CommandContext)ctx, (String)"path"))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"export").executes(ctx -> PathManagementCommands.exportFile((CommandContext<FabricClientCommandSource>)ctx, null))).then(ClientCommandManager.argument((String)"filename", (ArgumentType)StringArgumentType.word()).executes(ctx -> PathManagementCommands.exportFile((CommandContext<FabricClientCommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"filename")))))).then(ClientCommandManager.literal((String)"import").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"filename", (ArgumentType)StringArgumentType.word()).executes(ctx -> PathManagementCommands.importFile((CommandContext<FabricClientCommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"filename"), false))).then(ClientCommandManager.argument((String)"relative", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PathManagementCommands.importFile((CommandContext<FabricClientCommandSource>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"filename"), BoolArgumentType.getBool((CommandContext)ctx, (String)"relative")))))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"shutter").redirect((CommandNode)node));
    }

    private static int selectPath(CommandContext<FabricClientCommandSource> ctx, Identifier id) {
        CameraPathManager manager = FabricClient.INSTANCE.getPathManager(Abstraction.worldId((class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld()));
        boolean isNew = manager.hasPath(id);
        if (!isNew) {
            manager.setCurrentPath(id);
            Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.select_new", new Object[]{id.value()});
        } else if (manager.setCurrentPath(id)) {
            if (id.equals((Object)CameraPathManager.DEFAULT_PATH)) {
                Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.select_default", new Object[0]);
            } else {
                Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.select", new Object[]{id.value()});
            }
        } else {
            Messaging.INSTANCE.sendMessage(MessageType.NEUTRAL, "msg.shutter.headline.cmd.failed", "msg.shutter.error.select_already", new Object[]{id.value()});
        }
        return 1;
    }

    private static int exportFile(CommandContext<FabricClientCommandSource> ctx, String name) {
        CameraPath path = FabricClient.INSTANCE.getPathManager(Abstraction.worldId((class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld())).getCurrentPath();
        if (path.export(name == null ? path.getId().value() : name)) {
            Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.export", new Object[]{name + ".json"});
        } else {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.export", new Object[0]);
        }
        return 1;
    }

    private static int uploadFile(CommandContext<FabricClientCommandSource> ctx, String name) {
        CameraPath path = FabricClient.INSTANCE.getPathManager(Abstraction.worldId((class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld())).getCurrentPath();
        if (!path.exportHastebin(name == null ? path.getId().value() : name)) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.upload", new Object[0]);
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)new class_2588("msg.shutter.error.hastebin", new Object[]{"Failed to encode Path!"}));
        }
        return 1;
    }

    private static int importFile(CommandContext<FabricClientCommandSource> ctx, String name, boolean relative) {
        try {
            JsonElement e = Client.INSTANCE.getSaveFile().importJson(name);
            FabricClient.INSTANCE.getPathManager(Abstraction.worldId((class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld())).importJson(e, relative ? Abstraction.vec3d(((FabricClientCommandSource)ctx.getSource()).getPlayer().method_19538()) : Vec3d.ZERO);
            Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.import", new Object[]{name});
        }
        catch (IOException | PathException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.import", new Object[0]);
            ((FabricClientCommandSource)ctx.getSource()).sendError((class_2561)new class_2588("msg.shutter.error.io", new Object[]{e.getMessage()}));
        }
        return 1;
    }
}

