/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import studio.archetype.shutter.api.config.CameraPathSettings;
import studio.archetype.shutter.api.config.ClientConfig;
import studio.archetype.shutter.api.config.PathGenerationSettings;
import studio.archetype.shutter.api.config.enums.DirectionalBeamStyle;
import studio.archetype.shutter.api.config.enums.NotificationTarget;
import studio.archetype.shutter.api.config.enums.PathDetail;
import studio.archetype.shutter.api.config.enums.PathStyle;

@Config(name="shutter")
public class ShutterClientConfig
implements ConfigData,
ClientConfig {
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
    public NotificationTarget notificationTarget = NotificationTarget.TOAST;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public final ShutterPathGenerationSettings genSettings = new ShutterPathGenerationSettings();
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.CollapsibleObject
    public final ShutterCameraPathSettings pathSettings = new ShutterCameraPathSettings();

    public NotificationTarget getNotificationTarget() {
        return this.notificationTarget;
    }

    public PathGenerationSettings getGenerationSettings() {
        return this.genSettings;
    }

    public CameraPathSettings getPathSettings() {
        return this.pathSettings;
    }

    public static class ShutterPathGenerationSettings
    implements PathGenerationSettings {
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public PathDetail curveDetail = PathDetail.LOW;
        @ConfigEntry.Gui.Tooltip
        public double pathTime = 100.0;
        @ConfigEntry.Gui.Tooltip
        public boolean hideUi = false;
        @ConfigEntry.Gui.Tooltip
        public boolean hideArmorStands = true;
        @ConfigEntry.Gui.Tooltip
        public boolean hideEntityLabels = false;

        public PathDetail getPathDetail() {
            return this.curveDetail;
        }

        public double getPathTime() {
            return this.pathTime;
        }

        public boolean shouldHideUI() {
            return this.hideUi;
        }

        public boolean shouldHideArmorStands() {
            return this.hideArmorStands;
        }

        public boolean shouldHideEntityLabels() {
            return this.hideEntityLabels;
        }
    }

    public static class ShutterCameraPathSettings
    implements CameraPathSettings {
        @ConfigEntry.Gui.Tooltip
        public boolean showNodeHead = false;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.BoundedDiscrete(max=100L, min=0L)
        public int nodeTransparency = 50;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public DirectionalBeamStyle showDirectionalBeam = DirectionalBeamStyle.HIDE;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.Gui.EnumHandler(option=ConfigEntry.Gui.EnumHandler.EnumDisplayOption.BUTTON)
        public PathStyle pathStyle = PathStyle.LINE;
        @ConfigEntry.Gui.Tooltip
        @ConfigEntry.ColorPicker
        public int pathColour = 0xFFFFFF;

        public boolean showNodeHeads() {
            return this.showNodeHead;
        }

        public int getNodeTransparency() {
            return this.nodeTransparency;
        }

        public DirectionalBeamStyle showDirectionalBeam() {
            return this.showDirectionalBeam;
        }

        public PathStyle getPathStyle() {
            return this.pathStyle;
        }

        public int getPathColour() {
            return this.pathColour;
        }
    }
}

