/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.ByteBuffer;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.ConfigScreenProvider;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1074;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5218;
import org.lwjgl.opengl.GL11;
import studio.archetype.shutter.CommandFilter;
import studio.archetype.shutter.FabricEvents;
import studio.archetype.shutter.InputHandler;
import studio.archetype.shutter.VersionUtils19;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.CommandWrapper;
import studio.archetype.shutter.api.EventWrapper;
import studio.archetype.shutter.api.VersionUtils;
import studio.archetype.shutter.api.config.ClientConfig;
import studio.archetype.shutter.api.config.FfmpegConfig;
import studio.archetype.shutter.api.config.SaveFile;
import studio.archetype.shutter.api.entities.AbstractFreecamEntity;
import studio.archetype.shutter.api.pathing.PathFollower;
import studio.archetype.shutter.api.pathing.PathIterator;
import studio.archetype.shutter.api.pathing.PreviewRenderer;
import studio.archetype.shutter.api.rendering.AbstractPreviewRenderer;
import studio.archetype.shutter.api.rendering.Messaging;
import studio.archetype.shutter.camera.FabricPathFollower;
import studio.archetype.shutter.camera.FabricPathIterator;
import studio.archetype.shutter.cmd.PathControlCommands;
import studio.archetype.shutter.cmd.PathManagementCommands;
import studio.archetype.shutter.cmd.PathNodeCommands;
import studio.archetype.shutter.cmd.PathVisualCommands;
import studio.archetype.shutter.config.ClientConfigManager;
import studio.archetype.shutter.config.FabricSaveFile;
import studio.archetype.shutter.config.ShutterClientConfig;
import studio.archetype.shutter.entity.FreecamEntity;
import studio.archetype.shutter.entity.FreecamEntityRenderer;
import studio.archetype.shutter.events.WorldRenderedCallback;
import studio.archetype.shutter.pathing.CameraPathManager;
import studio.archetype.shutter.recording.jobs.Jobs;
import studio.archetype.shutter.rendering.ShutterPreviewRenderer;
import studio.archetype.shutter.rendering.ShutterRenderLayers;
import studio.archetype.shutter.ui.FabricMessaging;
import studio.archetype.shutter.ui.screen.RecordingScreen;
import studio.archetype.shutter.util.TimingUtils;
import studio.archetype.shutter.utils.AsyncUtils;
import studio.archetype.shutter.utils.ByteBufferPool;
import studio.archetype.shutter.utils.Identifier;
import studio.archetype.shutter.utils.ScreenSize;

@Environment(value=EnvType.CLIENT)
public class FabricClient
extends Client
implements ClientModInitializer {
    private EventWrapper eventWrapper;
    private AbstractPreviewRenderer previewRenderer;
    private PathFollower follower;
    private PathIterator iterator;
    private SaveFile saveFile;
    private CommandWrapper commandWrapper;

    public void onInitializeClient() {
        INSTANCE = this;
        this.init();
        ClientConfigManager.register();
        InputHandler.setupKeybinds();
        TimingUtils.init();
        WorldRenderedCallback.EVENT.register(l -> Jobs.onRenderEvent());
        this.saveFile = FabricSaveFile.getSaveFile();
        this.commandWrapper = new CommandFilter();
        this.eventWrapper = new FabricEvents();
        AsyncUtils.init();
        this.previewRenderer = new ShutterPreviewRenderer();
        VersionUtils.INSTANCE = new VersionUtils19();
        this.follower = new FabricPathFollower();
        this.iterator = new FabricPathIterator();
        ClientCommandRegistrationCallback.EVENT.register((dis, registryAccess) -> {
            PathControlCommands.register((CommandDispatcher<FabricClientCommandSource>)dis);
            PathNodeCommands.register((CommandDispatcher<FabricClientCommandSource>)dis);
            PathVisualCommands.register((CommandDispatcher<FabricClientCommandSource>)dis);
            PathManagementCommands.register((CommandDispatcher<FabricClientCommandSource>)dis);
        });
        WorldRenderEvents.AFTER_ENTITIES.register(this::setupRenderer);
        new ShutterRenderLayers().setupRenderLayers();
    }

    public PathFollower getPathFollower() {
        return this.follower;
    }

    public PathIterator getPathIterator() {
        return this.iterator;
    }

    public SaveFile getSaveFile() {
        return this.saveFile;
    }

    public ClientConfig getClientConfig() {
        return ClientConfigManager.CLIENT_CONFIG;
    }

    public FfmpegConfig getFfmpegConfig() {
        return ClientConfigManager.FFMPEG_CONFIG;
    }

    public CommandWrapper getCommandWrapper() {
        return this.commandWrapper;
    }

    public EventWrapper getEventWrapper() {
        return this.eventWrapper;
    }

    public PreviewRenderer getPreviewRenderer() {
        return this.previewRenderer;
    }

    private void setupRenderer(WorldRenderContext ctx) {
        ctx.world().method_16107().method_15405(Client.id((String)"path_render").toString());
        class_4597.class_4598 provider = class_4597.method_22991((class_287)new class_287(256));
        ((AbstractPreviewRenderer)this.getPreviewRenderer()).render(ctx.matrixStack(), (class_4597)provider, ctx.camera(), 0xF000F0);
        provider.method_22993();
    }

    public AbstractFreecamEntity createFreecamEntity(class_243 pos, float pitch, float yaw, float roll, class_1937 w) {
        return new FreecamEntity(pos, pitch, yaw, roll, w);
    }

    public void setupEntity() {
        EntityRendererRegistry.register(FreecamEntity.TYPE, FreecamEntityRenderer::new);
    }

    public void createRecordScreen() {
        class_310.method_1551().method_1507((class_437)new RecordingScreen(ClientConfigManager.FFMPEG_CONFIG));
    }

    public void createSettingsScreen() {
        class_310 c = class_310.method_1551();
        ConfigScreenProvider provider = (ConfigScreenProvider)AutoConfig.getConfigScreen(ShutterClientConfig.class, (class_437)c.field_1755);
        provider.setOptionFunction((gen, field) -> "config.shutter." + field.getName());
        c.method_1507(provider.get());
    }

    public CameraPathManager getPathManager(Identifier id) {
        if (class_310.method_1551().method_1496()) {
            String worldFileName = class_310.method_1551().method_1576().method_27050(class_5218.field_24188).toFile().getParentFile().getName();
            Map managers = this.saveFile.getLocalWorldSaves(worldFileName);
            return managers.computeIfAbsent(id, world -> new CameraPathManager());
        }
        if (class_310.method_1551().method_1562() == null) {
            return null;
        }
        String ip = class_310.method_1551().method_1562().method_2872().method_10755().toString();
        return this.saveFile.getRemoteServerSaves(ip).computeIfAbsent(id, world -> new CameraPathManager());
    }

    public long getWindowHandle() {
        return class_310.method_1551().method_22683().method_4490();
    }

    public ScreenSize getWindowSize() {
        return new ScreenSize(class_310.method_1551().method_22683().method_4480(), class_310.method_1551().method_22683().method_4507());
    }

    public String translate(String key) {
        return class_1074.method_4662((String)key, (Object[])new Object[0]);
    }

    public ByteBuffer readColorData(int x, int y, ScreenSize size) {
        ByteBuffer buffer = ByteBufferPool.allocate((int)(size.getWidth() * size.getHeight() * 4));
        class_276 fb = class_310.method_1551().method_1522();
        fb.method_1235(true);
        GL11.glReadPixels((int)x, (int)y, (int)size.getWidth(), (int)size.getHeight(), (int)6408, (int)5121, (ByteBuffer)buffer);
        fb.method_1240();
        buffer.rewind();
        return buffer;
    }

    public void setupMessaging() {
        Messaging.INSTANCE = new FabricMessaging();
    }
}

