/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.camera;

import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import studio.archetype.shutter.FabricClient;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.CommandWrapper;
import studio.archetype.shutter.api.config.enums.MessageType;
import studio.archetype.shutter.api.entities.AbstractFreecamEntity;
import studio.archetype.shutter.api.pathing.PathIterator;
import studio.archetype.shutter.api.rendering.Messaging;
import studio.archetype.shutter.extensions.CameraExt;
import studio.archetype.shutter.math.Vec3d;
import studio.archetype.shutter.pathing.CameraPath;
import studio.archetype.shutter.pathing.PathNode;

public class FabricPathIterator
implements PathIterator {
    private CameraPath currentPath;
    private int index;
    private AbstractFreecamEntity entity;
    private CommandWrapper.GameMode oldGamemode;
    private Vec3d oldPos;
    private int oldFov;
    private float oldRoll;
    private float oldPitch;
    private float oldYaw;

    public boolean isIterating() {
        return this.currentPath != null && this.entity != null;
    }

    public void begin(CameraPath path) {
        if (path.getNodes().size() < 2 || class_310.method_1551().field_1724 == null) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.not_enough_show", new Object[0]);
            return;
        }
        this.currentPath = path;
        this.index = 0;
        class_310 c = class_310.method_1551();
        class_746 p = c.field_1724;
        PathNode node = (PathNode)this.currentPath.getNodes().get(this.index);
        this.oldGamemode = this.getModeFromVanilla(c.field_1761.method_2920());
        this.oldPos = new Vec3d(p.method_19538().method_10216(), p.method_19538().method_10214(), p.method_19538().method_10215());
        this.oldFov = (Integer)c.field_1690.method_41808().method_41753();
        this.oldPitch = p.method_5695(1.0f);
        this.oldYaw = p.method_5705(1.0f);
        this.oldRoll = ((CameraExt)c.field_1773.method_19418()).getRoll(1.0f);
        class_243 pos = new class_243(node.getPosition().x(), node.getPosition().y(), node.getPosition().z());
        this.entity = ((FabricClient)Client.INSTANCE).createFreecamEntity(pos, node.getPitch(), node.getYaw(), node.getRoll(), (class_1937)c.field_1687);
        Client.INSTANCE.getZoomHandler().setZoom((double)node.getZoom());
        Client.INSTANCE.getCommandWrapper().changeGameMode(CommandWrapper.GameMode.SPECTATOR);
        c.method_1504((class_1297)this.entity);
    }

    public void next() {
        ++this.index;
        if (this.index > this.currentPath.getNodes().size() - 1) {
            this.index = 0;
        }
        this.setCameraToNode((PathNode)this.currentPath.getNodes().get(this.index));
    }

    public void previous() {
        --this.index;
        if (this.index < 0) {
            this.index = this.currentPath.getNodes().size() - 1;
        }
        this.setCameraToNode((PathNode)this.currentPath.getNodes().get(this.index));
    }

    public void end() {
        this.entity.method_5768();
        this.currentPath = null;
        this.index = 0;
        class_310 c = class_310.method_1551();
        class_746 p = c.field_1724;
        Client.INSTANCE.getCommandWrapper().teleportClient(this.oldPos, (double)this.oldPitch, (double)this.oldYaw);
        c.field_1690.method_41808().method_41748((Object)this.oldFov);
        ((CameraExt)c.field_1773.method_19418()).setRoll(this.oldRoll);
        Client.INSTANCE.getCommandWrapper().changeGameMode(this.oldGamemode);
        c.method_1504((class_1297)p);
    }

    private void setCameraToNode(PathNode node) {
        class_310 c = class_310.method_1551();
        class_746 p = c.field_1724;
        assert (p != null);
        Vec3d position = node.getPosition();
        this.entity.method_23327(position.x(), position.y(), position.z());
        this.entity.setRotation(node.getPitch(), node.getYaw(), node.getRoll());
        this.entity.updatePrev();
        FabricClient.INSTANCE.getZoomHandler().setZoom((double)node.getZoom());
        FabricClient.INSTANCE.getCommandWrapper().teleportClient(node.getPosition(), (double)node.getPitch(), (double)node.getYaw());
    }

    private CommandWrapper.GameMode getModeFromVanilla(class_1934 mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case class_1934.field_9220 -> CommandWrapper.GameMode.CREATIVE;
            case class_1934.field_9215 -> CommandWrapper.GameMode.SURVIVAL;
            case class_1934.field_9216 -> CommandWrapper.GameMode.ADVENTURE;
            case class_1934.field_9219 -> CommandWrapper.GameMode.SPECTATOR;
        };
    }
}

