/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import studio.archetype.shutter.FabricClient;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.config.enums.MessageType;
import studio.archetype.shutter.api.rendering.Messaging;
import studio.archetype.shutter.extensions.CameraExt;
import studio.archetype.shutter.math.Vec3d;
import studio.archetype.shutter.pathing.CameraPath;
import studio.archetype.shutter.pathing.PathNode;
import studio.archetype.shutter.util.Abstraction;

public final class PathNodeCommands {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"s").requires(src -> src.method_9259(4))).then(ClientCommandManager.literal((String)"add").executes(PathNodeCommands::addNode))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> PathNodeCommands.removeNode((CommandContext<FabricClientCommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> PathNodeCommands.setNode((CommandContext<FabricClientCommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(ClientCommandManager.literal((String)"goto").then(ClientCommandManager.argument((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> PathNodeCommands.gotoNode((CommandContext<FabricClientCommandSource>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index"))))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"shutter").redirect((CommandNode)node));
    }

    private static int addNode(CommandContext<FabricClientCommandSource> ctx) {
        class_310 c = ((FabricClientCommandSource)ctx.getSource()).getClient();
        class_4184 cam = c.field_1773.method_19418();
        Client shutter = FabricClient.INSTANCE;
        PathNode node = new PathNode(new Vec3d(cam.method_19326().method_10216(), cam.method_19326().method_10214(), cam.method_19326().method_10215()), cam.method_19329(), cam.method_19330() % 360.0f, ((CameraExt)cam).getRoll(1.0f), (float)shutter.getZoomHandler().getZoom());
        shutter.getPathManager(Abstraction.worldId((class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld())).addNode(node);
        return 1;
    }

    private static int removeNode(CommandContext<FabricClientCommandSource> ctx, int index) {
        class_310 c = ((FabricClientCommandSource)ctx.getSource()).getClient();
        CameraPath path = FabricClient.INSTANCE.getPathManager(Abstraction.worldId((class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld())).getCurrentPath();
        try {
            path.removeNode(index);
            Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.remove_node", new Object[]{index});
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.remove_node", new Object[]{index});
            return 0;
        }
    }

    private static int setNode(CommandContext<FabricClientCommandSource> ctx, int index) {
        class_310 c = ((FabricClientCommandSource)ctx.getSource()).getClient();
        CameraPath path = FabricClient.INSTANCE.getPathManager(Abstraction.worldId((class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld())).getCurrentPath();
        try {
            class_4184 cam = c.field_1773.method_19418();
            PathNode node = new PathNode(new Vec3d(cam.method_19326().method_10216(), cam.method_19326().method_10214(), cam.method_19326().method_10215()), cam.method_19329(), cam.method_19330() % 360.0f, ((CameraExt)cam).getRoll(1.0f), (float)Client.INSTANCE.getZoomHandler().getZoom());
            path.setNode(node, index);
            Messaging.INSTANCE.sendMessageWithPos(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.set_node", node.getPosition(), new Object[]{index});
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.set_node", new Object[]{index});
            return 0;
        }
    }

    private static int gotoNode(CommandContext<FabricClientCommandSource> ctx, int index) {
        class_310 c = ((FabricClientCommandSource)ctx.getSource()).getClient();
        CameraPath path = FabricClient.INSTANCE.getPathManager(Abstraction.worldId((class_1937)((FabricClientCommandSource)ctx.getSource()).getWorld())).getCurrentPath();
        try {
            PathNode node = (PathNode)path.getNodes().get(index);
            Vec3d position = node.getPosition().add(0.0, -1.62, 0.0);
            Client.INSTANCE.getCommandWrapper().teleportClient(position, (double)node.getPitch(), (double)node.getYaw());
            ((CameraExt)c.field_1773.method_19418()).setRoll(node.getRoll());
            Client.INSTANCE.getZoomHandler().setZoom((double)node.getZoom());
            Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.go_to_node", new Object[]{index});
            return 1;
        }
        catch (IndexOutOfBoundsException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.go_to_node", new Object[]{index});
            return 0;
        }
    }
}

