/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.cmd;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;

public class PathTimeArgumentType
implements ArgumentType<Double> {
    private static final ImmutableList<String> EXAMPLES = ImmutableList.of((Object)"77.9", (Object)"22.2t", (Object)"5.25s", (Object)"3.75m", (Object)"1.0025h");

    private PathTimeArgumentType() {
    }

    public static PathTimeArgumentType pathTime() {
        return new PathTimeArgumentType();
    }

    public static double getTicks(CommandContext<?> context, String name) {
        return (Double)context.getArgument(name, Double.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public Double parse(StringReader reader) throws CommandSyntaxException {
        double multiplier;
        double value = reader.readDouble();
        try {
            char type = reader.read();
            if (type != 's' && type != 'm' && type != 'h' && type != 't') {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedSymbol().createWithContext((ImmutableStringReader)reader, (Object)"t/s/m/h");
            }
            multiplier = switch (type) {
                case 's' -> 20.0;
                case 'm' -> 1200.0;
                case 'h' -> 72000.0;
                default -> 1.0;
            };
        }
        catch (StringIndexOutOfBoundsException e) {
            multiplier = 1.0;
        }
        return value * multiplier;
    }
}

