/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_746;
import studio.archetype.shutter.FabricClient;
import studio.archetype.shutter.api.config.enums.MessageType;
import studio.archetype.shutter.api.rendering.Messaging;
import studio.archetype.shutter.pathing.CameraPathManager;
import studio.archetype.shutter.pathing.exceptions.PathTooSmallException;
import studio.archetype.shutter.util.Abstraction;

public final class PathVisualCommands {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode node = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"s").requires(src -> src.method_9259(4))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"show").executes(ctx -> PathVisualCommands.showPath((CommandContext<FabricClientCommandSource>)ctx, false))).then(ClientCommandManager.argument((String)"loop", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PathVisualCommands.showPath((CommandContext<FabricClientCommandSource>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"loop")))))).then(ClientCommandManager.literal((String)"hide").executes(PathVisualCommands::hidePath))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggle").executes(ctx -> PathVisualCommands.togglePath((CommandContext<FabricClientCommandSource>)ctx, false))).then(ClientCommandManager.argument((String)"loop", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> PathVisualCommands.togglePath((CommandContext<FabricClientCommandSource>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"loop"))))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"shutter").redirect((CommandNode)node));
    }

    private static int showPath(CommandContext<FabricClientCommandSource> ctx, boolean loop) {
        class_746 p = ((FabricClientCommandSource)ctx.getSource()).getPlayer();
        CameraPathManager manager = FabricClient.INSTANCE.getPathManager(Abstraction.worldId(p.method_5770()));
        try {
            if (manager.isVisualizing()) {
                Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.showing_path", new Object[0]);
            } else {
                manager.togglePathVisualization(loop);
                Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.showing_path", new Object[0]);
            }
            return 1;
        }
        catch (PathTooSmallException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEUTRAL, "msg.shutter.headline.cmd.failed", "msg.shutter.error.not_enough_show", new Object[0]);
            return 0;
        }
    }

    private static int hidePath(CommandContext<FabricClientCommandSource> ctx) {
        class_746 p = ((FabricClientCommandSource)ctx.getSource()).getPlayer();
        CameraPathManager manager = FabricClient.INSTANCE.getPathManager(Abstraction.worldId(p.method_5770()));
        try {
            if (manager.isVisualizing()) {
                manager.togglePathVisualization(false);
                Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.hiding_path", new Object[0]);
            } else {
                Messaging.INSTANCE.sendMessage(MessageType.NEUTRAL, "msg.shutter.headline.cmd.failed", "msg.shutter.error.hiding_path", new Object[0]);
            }
            return 1;
        }
        catch (PathTooSmallException pathTooSmallException) {
            return 0;
        }
    }

    private static int togglePath(CommandContext<FabricClientCommandSource> ctx, boolean loop) {
        class_746 p = ((FabricClientCommandSource)ctx.getSource()).getPlayer();
        CameraPathManager manager = FabricClient.INSTANCE.getPathManager(Abstraction.worldId(p.method_5770()));
        try {
            if (manager.togglePathVisualization(loop)) {
                Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.showing_path", new Object[0]);
            } else {
                Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.hiding_path", new Object[0]);
            }
            return 1;
        }
        catch (PathTooSmallException e) {
            Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.not_enough_show", new Object[0]);
            return 0;
        }
    }
}

