/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter;

import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1937;
import net.minecraft.class_304;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.config.enums.MessageType;
import studio.archetype.shutter.api.rendering.Messaging;
import studio.archetype.shutter.config.ClientConfigManager;
import studio.archetype.shutter.extensions.CameraExt;
import studio.archetype.shutter.pathing.PathNode;
import studio.archetype.shutter.pathing.exceptions.PathEmptyException;
import studio.archetype.shutter.pathing.exceptions.PathNotFollowingException;
import studio.archetype.shutter.pathing.exceptions.PathTooSmallException;
import studio.archetype.shutter.util.Abstraction;

public class InputHandler {
    private static final float ROT_FACTOR = 0.5f;
    private static final double ZOOM_FACTOR = (double)0.1f;
    private static class_304 rollLeft;
    private static class_304 rollRight;
    private static class_304 rollReset;
    private static class_304 zoomIn;
    private static class_304 zoomOut;
    private static class_304 zoomReset;
    private static class_304 actionKey;
    private static class_304 createNode;
    private static class_304 visualizePath;
    private static class_304 startPath;
    private static class_304 clearPath;
    private static class_304 openConfig;
    private static class_304 movePreviousNode;
    private static class_304 moveNextNode;
    private static class_304 toggleIterationMode;

    public static void setupKeybinds() {
        rollLeft = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.roll_left", class_3675.class_307.field_1668, 324, "category.shutter.keybinds"));
        rollRight = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.roll_right", class_3675.class_307.field_1668, 326, "category.shutter.keybinds"));
        rollReset = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.roll_reset", class_3675.class_307.field_1668, 327, "category.shutter.keybinds"));
        zoomIn = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.zoom_in", class_3675.class_307.field_1668, 328, "category.shutter.keybinds"));
        zoomOut = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.zoom_out", class_3675.class_307.field_1668, 322, "category.shutter.keybinds"));
        zoomReset = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.zoom_reset", class_3675.class_307.field_1668, 329, "category.shutter.keybinds"));
        createNode = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.create_node", class_3675.class_307.field_1668, 325, "category.shutter.keybinds"));
        visualizePath = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.visualize_path", class_3675.class_307.field_1668, 320, "category.shutter.keybinds"));
        startPath = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.start_path", class_3675.class_307.field_1668, 335, "category.shutter.keybinds"));
        openConfig = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.open_config", class_3675.class_307.field_1668, 333, "category.shutter.keybinds"));
        movePreviousNode = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.previous_node", class_3675.class_307.field_1668, 321, "category.shutter.keybinds"));
        moveNextNode = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.next_node", class_3675.class_307.field_1668, 323, "category.shutter.keybinds"));
        toggleIterationMode = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.toggle_iteration", class_3675.class_307.field_1668, 334, "category.shutter.keybinds"));
        actionKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.factor_mod", class_3675.class_307.field_1668, 90, "category.shutter.keybinds"));
        clearPath = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.shutter.cam.clear_path", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "category.shutter.keybinds"));
        ClientTickEvents.END_CLIENT_TICK.register(c -> {
            if (c.field_1724 == null) {
                return;
            }
            Client shutter = Client.INSTANCE;
            if (!shutter.getPathFollower().isFollowing() && !shutter.getPathIterator().isIterating()) {
                if (rollLeft.method_1434()) {
                    ((CameraExt)c.field_1773.method_19418()).addRoll(-0.5f * (float)(actionKey.method_1434() ? 10 : 1));
                }
                if (rollRight.method_1434()) {
                    ((CameraExt)c.field_1773.method_19418()).addRoll(0.5f * (float)(actionKey.method_1434() ? 10 : 1));
                }
                if (zoomIn.method_1434()) {
                    shutter.getZoomHandler().setZoom(class_3532.method_15350((double)(shutter.getZoomHandler().getZoom() - (double)0.1f * (double)(actionKey.method_1434() ? 10 : 1)), (double)(-c.field_1690.field_1826 + 0.1), (double)(179.9 - c.field_1690.field_1826)));
                }
                if (zoomOut.method_1434()) {
                    shutter.getZoomHandler().setZoom(class_3532.method_15350((double)(shutter.getZoomHandler().getZoom() + (double)0.1f * (double)(actionKey.method_1434() ? 10 : 1)), (double)(-c.field_1690.field_1826 + 0.1), (double)(179.9 - c.field_1690.field_1826)));
                }
                if (rollReset.method_1436()) {
                    ((CameraExt)c.field_1773.method_19418()).setRoll(0.0f);
                }
                if (zoomReset.method_1436()) {
                    shutter.getZoomHandler().resetZoom();
                }
                if (createNode.method_1436()) {
                    class_4184 cam = c.field_1773.method_19418();
                    PathNode node = new PathNode(Abstraction.vec3d(cam.method_19326()), cam.method_19329(), cam.method_19330() % 360.0f, ((CameraExt)cam).getRoll(1.0f), (float)shutter.getZoomHandler().getZoom());
                    shutter.getPathManager(Abstraction.worldId((class_1937)c.field_1687)).addNode(node);
                }
            }
            if (visualizePath.method_1436()) {
                try {
                    if (Client.INSTANCE.getPathManager(Abstraction.worldId((class_1937)c.field_1687)).togglePathVisualization(actionKey.method_1434())) {
                        if (!shutter.getPathFollower().isFollowing()) {
                            Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.showing_path", new Object[0]);
                        }
                    } else if (!shutter.getPathFollower().isFollowing()) {
                        Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.hiding_path", new Object[0]);
                    }
                }
                catch (PathTooSmallException e) {
                    Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.not_enough_show", new Object[0]);
                }
            }
            if (openConfig.method_1436()) {
                Client.INSTANCE.createSettingsScreen();
            }
            if (startPath.method_1436() && !shutter.getPathIterator().isIterating()) {
                try {
                    shutter.getPathManager(Abstraction.worldId((class_1937)c.field_1687)).stopCameraPath();
                }
                catch (PathNotFollowingException e) {
                    try {
                        shutter.getPathManager(Abstraction.worldId((class_1937)c.field_1687)).startCameraPath(ClientConfigManager.CLIENT_CONFIG.genSettings.pathTime, actionKey.method_1434());
                    }
                    catch (PathTooSmallException ex) {
                        Messaging.INSTANCE.sendMessage(MessageType.NEGATIVE, "msg.shutter.headline.cmd.failed", "msg.shutter.error.not_enough_start", new Object[0]);
                    }
                }
            }
            if (clearPath.method_1436()) {
                try {
                    Client.INSTANCE.getPathManager(Abstraction.worldId((class_1937)c.field_1687)).clearPath(false);
                    Messaging.INSTANCE.sendMessage(MessageType.POSITIVE, "msg.shutter.headline.cmd.success", "msg.shutter.ok.path_cleared", new Object[0]);
                }
                catch (PathEmptyException e) {
                    Messaging.INSTANCE.sendMessage(MessageType.NEUTRAL, "msg.shutter.headline.cmd.failed", "msg.shutter.error.path_empty", new Object[0]);
                }
            }
            if (toggleIterationMode.method_1436() && !shutter.getPathFollower().isFollowing()) {
                if (shutter.getPathIterator().isIterating()) {
                    shutter.getPathIterator().end();
                } else {
                    shutter.getPathIterator().begin(shutter.getPathManager(Abstraction.worldId((class_1937)c.field_1687)).getCurrentPath());
                }
            }
            if (shutter.getPathIterator().isIterating()) {
                if (moveNextNode.method_1436()) {
                    shutter.getPathIterator().next();
                }
                if (movePreviousNode.method_1436()) {
                    shutter.getPathIterator().previous();
                }
            }
        });
    }
}

