/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import org.apache.commons.io.IOUtils;
import org.lwjgl.stb.STBImageWrite;
import studio.archetype.shutter.api.config.SaveFile;
import studio.archetype.shutter.pathing.CameraPathManager;
import studio.archetype.shutter.recording.frames.Frame;
import studio.archetype.shutter.utils.Identifier;
import studio.archetype.shutter.utils.ScreenSize;

public class FabricSaveFile
implements SaveFile {
    private static final Path SHUTTER_DIR = FabricLoader.getInstance().getGameDir().resolve("shutter");
    private static final Path SHUTTER_REC_DIR = SHUTTER_DIR.resolve("recordings");
    private static final File PATH_FILE = SHUTTER_DIR.resolve("shutter_paths.nbt").toFile();
    private final Map<String, Map<Identifier, CameraPathManager>> remoteServerSaves;
    private final Map<String, Map<Identifier, CameraPathManager>> localWorldSaves;
    private static final Codec<Map<Identifier, CameraPathManager>> CODEC_MANAGER = Codec.unboundedMap((Codec)Identifier.CODEC, (Codec)CameraPathManager.CODEC).fieldOf("WorldData").codec().xmap(HashMap::new, map -> map);
    private static final Codec<FabricSaveFile> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, CODEC_MANAGER).fieldOf("Server").forGetter(o -> o.remoteServerSaves), (App)Codec.unboundedMap((Codec)Codec.STRING, CODEC_MANAGER).fieldOf("Local").forGetter(o -> o.localWorldSaves)).apply((Applicative)i, FabricSaveFile::new));

    public static FabricSaveFile getSaveFile() {
        try {
            if (!PATH_FILE.exists()) {
                SHUTTER_DIR.toFile().mkdirs();
                return new FabricSaveFile();
            }
            class_2520 shutter = class_2507.method_30613((File)PATH_FILE).method_10580("Shutter");
            return (FabricSaveFile)((Pair)((DataResult)class_2509.field_11560.withDecoder(CODEC).apply(shutter)).result().orElseThrow(() -> new IOException("Failed to parse save data!"))).getFirst();
        }
        catch (IOException e) {
            System.out.println("Shutter: Failed to read save data!");
            e.printStackTrace();
            return new FabricSaveFile();
        }
    }

    private FabricSaveFile() {
        this.remoteServerSaves = new HashMap<String, Map<Identifier, CameraPathManager>>();
        this.localWorldSaves = new HashMap<String, Map<Identifier, CameraPathManager>>();
    }

    private FabricSaveFile(Map<String, Map<Identifier, CameraPathManager>> remote, Map<String, Map<Identifier, CameraPathManager>> local) {
        this.remoteServerSaves = new HashMap<String, Map<Identifier, CameraPathManager>>(remote);
        this.localWorldSaves = new HashMap<String, Map<Identifier, CameraPathManager>>(local);
    }

    public void save() {
        try {
            Optional nbt = ((DataResult)class_2509.field_11560.withEncoder(CODEC).apply(this)).resultOrPartial(System.out::println);
            if (nbt.isPresent()) {
                class_2487 tag = new class_2487();
                tag.method_10566("Shutter", (class_2520)nbt.get());
                class_2507.method_30614((class_2487)tag, (File)PATH_FILE);
            } else {
                System.out.println("Shutter: Failed to encode data!");
            }
        }
        catch (IOException e) {
            System.out.println("Shutter: Failed to save data!");
            e.printStackTrace();
        }
    }

    public Map<Identifier, CameraPathManager> getLocalWorldSaves(String saveFile) {
        if (!this.localWorldSaves.containsKey(saveFile)) {
            this.localWorldSaves.put(saveFile, new HashMap());
            System.out.println("Created new entry");
        }
        return this.localWorldSaves.get(saveFile);
    }

    public Map<Identifier, CameraPathManager> getRemoteServerSaves(String ip) {
        if (!this.remoteServerSaves.containsKey(ip)) {
            this.remoteServerSaves.put(ip, new HashMap());
        }
        return this.remoteServerSaves.get(ip);
    }

    public boolean exportJson(String name, JsonElement json) {
        boolean bl;
        FileOutputStream stream = new FileOutputStream(SHUTTER_DIR.resolve(name + ".json").toFile());
        try {
            IOUtils.write((String)json.toString(), (OutputStream)stream, (Charset)Charset.defaultCharset());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.out.println("Failed to export path!");
                e.printStackTrace();
                return false;
            }
        }
        ((OutputStream)stream).close();
        return bl;
    }

    public JsonElement importJson(String id) throws IOException {
        File f = SHUTTER_DIR.resolve(id + ".json").toFile();
        return new JsonParser().parse(IOUtils.toString((InputStream)new FileInputStream(f), (Charset)Charset.defaultCharset()));
    }

    public Path getShutterDir() {
        return SHUTTER_DIR;
    }

    public Path getShutterRecDir() {
        return SHUTTER_REC_DIR;
    }

    public File getShutterPathFile() {
        return PATH_FILE;
    }

    public void saveFrameImage(File path, ScreenSize size, Frame frame) {
        STBImageWrite.stbi_write_png((CharSequence)path.getAbsolutePath(), (int)size.getWidth(), (int)size.getHeight(), (int)4, (ByteBuffer)frame.getData(), (int)0);
    }
}

