/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.rendering;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1068;
import net.minecraft.class_1160;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3879;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.config.enums.DirectionalBeamStyle;
import studio.archetype.shutter.api.config.enums.PathStyle;
import studio.archetype.shutter.api.rendering.AbstractPreviewRenderer;
import studio.archetype.shutter.api.rendering.ShutterRenderLayer;
import studio.archetype.shutter.math.Vec3d;
import studio.archetype.shutter.pathing.CameraPath;
import studio.archetype.shutter.pathing.InterpolationData;
import studio.archetype.shutter.pathing.PathNode;
import studio.archetype.shutter.util.DrawUtils;

public class ShutterPreviewRenderer
extends AbstractPreviewRenderer {
    private static final NodeModel NODE_MODEL = new NodeModel();
    private CameraPath path;
    private boolean shouldLoop;

    public void enable(CameraPath path, boolean loop) {
        this.path = path;
        this.shouldLoop = loop;
    }

    public void disable() {
        this.path = null;
    }

    @Override
    public void render(class_4587 stack, class_4597 provider, class_4184 camera, int light) {
        if (this.path == null || Client.INSTANCE.getPathIterator().isIterating() || Client.INSTANCE.getPathFollower().isFollowing()) {
            return;
        }
        stack.method_22903();
        this.offsetStackByCamera(stack, camera);
        Map pathData = this.path.getInterpolatedData(this.shouldLoop);
        PathStyle style = Client.INSTANCE.getClientConfig().getPathSettings().getPathStyle();
        DirectionalBeamStyle directionalBeam = Client.INSTANCE.getClientConfig().getPathSettings().showDirectionalBeam();
        for (int i = 0; i < this.path.getNodes().size(); ++i) {
            PathNode node = (PathNode)this.path.getNodes().get(i);
            LinkedList steps = (LinkedList)pathData.get(node);
            if (steps != null) {
                Vec3d previous = ((InterpolationData)steps.getFirst()).getPosition();
                for (InterpolationData point : steps) {
                    Vec3d p = point.getPosition();
                    if (!(style != PathStyle.LINE && style != PathStyle.ADVANCED || point.equals(steps.getFirst()))) {
                        DrawUtils.renderLine(p, previous, this.getColour(this.path.getNodes(), node, false), provider.getBuffer(ShutterRenderLayer.SHUTTER_LINE), stack.method_23760());
                        previous = point.getPosition();
                    }
                    if (style == PathStyle.CUBES || style == PathStyle.ADVANCED) {
                        DrawUtils.renderCube(p, 0.1f, this.getColour(this.path.getNodes(), node, false), provider.getBuffer(ShutterRenderLayer.SHUTTER_CUBE), stack.method_23760());
                    }
                    if (directionalBeam != DirectionalBeamStyle.ADVANCED) continue;
                    DrawUtils.renderLine(p, DrawUtils.getOffsetPoint(p, (float)point.getRotation().x(), (float)point.getRotation().y(), 2.0), this.getColour(this.path.getNodes(), node, true), provider.getBuffer(ShutterRenderLayer.SHUTTER_DIR), stack.method_23760());
                }
            }
            if (Client.INSTANCE.getClientConfig().getPathSettings().showNodeHeads()) {
                this.renderNodeHead(node, stack, provider, light);
                this.renderTextLabel(stack, provider, node.getPosition(), (class_2561)new class_2585("#" + i), camera, light);
                if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
                    this.renderTextLabel(stack, provider, node.getPosition().add(0.0, 0.5, 0.0), (class_2561)new class_2585("Value: " + node.getYaw()), camera, light);
                    if (steps != null) {
                        this.renderTextLabel(stack, provider, node.getPosition().add(0.0, 1.0, 0.0), (class_2561)new class_2585("Determined: " + ((InterpolationData)steps.getFirst()).getRotation().y()), camera, light);
                    }
                }
            } else if (style == PathStyle.ADVANCED) {
                DrawUtils.renderCube(node.getPosition(), 0.2f, this.getColour(this.path.getNodes(), node, true), provider.getBuffer(ShutterRenderLayer.SHUTTER_CUBE), stack.method_23760());
            }
            if (directionalBeam == DirectionalBeamStyle.HIDE) continue;
            DrawUtils.renderLine(node.getPosition(), DrawUtils.getOffsetPoint(node.getPosition(), node.getPitch(), node.getYaw(), 2.0), this.getColour(this.path.getNodes(), node, true), provider.getBuffer(ShutterRenderLayer.SHUTTER_DIR), stack.method_23760());
        }
        stack.method_22909();
    }

    private void renderNodeHead(PathNode node, class_4587 stack, class_4597 provider, int light) {
        stack.method_22903();
        stack.method_22904(node.getPosition().x(), node.getPosition().y() - 0.25, node.getPosition().z());
        stack.method_22905(-1.0f, -1.0f, -1.0f);
        stack.method_22904(0.0, -0.25, 0.0);
        stack.method_22907(class_1160.field_20704.method_23214(node.getYaw()));
        stack.method_22907(class_1160.field_20703.method_23214(node.getPitch()));
        stack.method_22907(class_1160.field_20707.method_23214(node.getRoll()));
        stack.method_22904(0.0, 0.25, 0.0);
        class_4588 vertexConsumer = provider.getBuffer(this.getNodeRenderLayer());
        NODE_MODEL.method_2828(stack, vertexConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, (float)Client.INSTANCE.getClientConfig().getPathSettings().getNodeTransparency() / 100.0f);
        stack.method_22909();
    }

    private class_1921 getNodeRenderLayer() {
        class_310 minecraftClient = class_310.method_1551();
        GameProfile profile = new GameProfile(NodeModel.ID, "CameraHead");
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmZiNWVlZTQwYzNkZDY2ODNjZWM4ZGQxYzZjM2ZjMWIxZjAxMzcxNzg2NjNkNzYxMDljZmUxMmVkN2JmMjc4ZSJ9fX0="));
        Map map = minecraftClient.method_1582().method_4654(profile);
        return map.containsKey(MinecraftProfileTexture.Type.SKIN) ? class_1921.method_23580((class_2960)minecraftClient.method_1582().method_4656((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN)) : class_1921.method_23578((class_2960)class_1068.method_4648((UUID)class_1657.method_7271((GameProfile)profile)));
    }

    private static class NodeModel
    extends class_3879 {
        private static final UUID ID = UUID.fromString("bda14eb8-3246-4637-947f-d550e2f32387");
        private static final String TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmZiNWVlZTQwYzNkZDY2ODNjZWM4ZGQxYzZjM2ZjMWIxZjAxMzcxNzg2NjNkNzYxMDljZmUxMmVkN2JmMjc4ZSJ9fX0=";
        private final class_630 modelPart;

        public NodeModel() {
            super(class_1921::method_23580);
            class_630.class_628 head = new class_630.class_628(0, 0, -4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, 0.0f, 0.0f, false, 64.0f, 64.0f);
            class_630.class_628 hat = new class_630.class_628(32, 0, -4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.25f, 0.25f, 0.25f, false, 64.0f, 64.0f);
            this.modelPart = new class_630(Collections.singletonList(head), Collections.singletonMap("hat", new class_630(Collections.singletonList(hat), Collections.emptyMap())));
        }

        public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
            this.modelPart.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        }
    }
}

