/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.camera;

import java.util.LinkedList;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import studio.archetype.shutter.FabricClient;
import studio.archetype.shutter.api.Client;
import studio.archetype.shutter.api.CommandWrapper;
import studio.archetype.shutter.api.entities.AbstractFreecamEntity;
import studio.archetype.shutter.api.pathing.PathFollower;
import studio.archetype.shutter.config.ClientConfigManager;
import studio.archetype.shutter.extensions.CameraExt;
import studio.archetype.shutter.pathing.CameraPath;
import studio.archetype.shutter.pathing.InterpolationData;
import studio.archetype.shutter.pathing.PathNode;

public class FabricPathFollower
implements PathFollower {
    private CameraPath path;
    private boolean loop;
    private AbstractFreecamEntity entity;
    private PathNode currentNode;
    private LinkedList<InterpolationData> currentSegmentData = new LinkedList();
    private int nodeIndex;
    private int segmentIndex;
    private double segmentTime;
    private double tickCounter;
    private CommandWrapper.GameMode oldGamemode;
    private class_243 oldPos;
    private double oldFov;
    private float oldRoll;
    private boolean oldHideHud;

    public FabricPathFollower() {
        Client.INSTANCE.getEventWrapper().CLIENT_TICK_END(() -> {
            if (this.path == null) {
                return;
            }
            this.tick(class_310.method_1551().method_1488());
        });
    }

    public void start(CameraPath path, double pathTime, boolean loop) {
        class_310 c = class_310.method_1551();
        this.path = path;
        this.loop = loop;
        this.oldGamemode = this.getModeFromVanilla(c.field_1761.method_2920());
        this.oldPos = c.field_1724.method_19538();
        this.oldFov = FabricClient.INSTANCE.getZoomHandler().getZoom();
        this.oldRoll = ((CameraExt)c.field_1773.method_19418()).getRoll(1.0f);
        this.oldHideHud = c.field_1690.field_1842;
        this.nodeIndex = 0;
        this.tickCounter = 0.0;
        this.segmentIndex = 1;
        this.currentNode = (PathNode)path.getNodes().get(0);
        this.currentSegmentData = (LinkedList)path.getInterpolatedData(loop).get(this.currentNode);
        this.segmentTime = pathTime / (double)path.getInterpolatedData(loop).size() / (double)(this.currentSegmentData.size() - 1);
        if (!this.oldHideHud && ClientConfigManager.CLIENT_CONFIG.genSettings.hideUi) {
            c.field_1690.field_1842 = true;
        }
        Client.INSTANCE.getCommandWrapper().changeGameMode(CommandWrapper.GameMode.SPECTATOR);
        class_243 pos = new class_243(this.currentNode.getPosition().x(), this.currentNode.getPosition().y(), this.currentNode.getPosition().z());
        this.entity = ((FabricClient)Client.INSTANCE).createFreecamEntity(pos, 0.0f, 0.0f, this.currentNode.getRoll(), (class_1937)c.field_1687);
        c.method_1504((class_1297)this.entity);
        c.field_1724.method_20620(this.currentNode.getPosition().x(), this.currentNode.getPosition().y(), this.currentNode.getPosition().z());
    }

    public void end() {
        this.path = null;
        this.entity.method_5768();
        class_310 c = class_310.method_1551();
        c.method_1504((class_1297)c.field_1724);
        c.field_1724.method_23327(this.oldPos.method_10216(), this.oldPos.method_10214(), this.oldPos.method_10215());
        c.field_1690.field_1842 = this.oldHideHud;
        Client.INSTANCE.getCommandWrapper().changeGameMode(this.oldGamemode);
        Client.INSTANCE.getZoomHandler().setZoom(this.oldFov);
        ((CameraExt)c.field_1773.method_19418()).setRoll(this.oldRoll);
    }

    public void tick(float tickDelta) {
        float delta = (float)Math.min((double)((float)this.tickCounter) / this.segmentTime, 1.0);
        InterpolationData cur = this.currentSegmentData.get(this.segmentIndex);
        InterpolationData prev = this.currentSegmentData.get(this.segmentIndex - 1);
        class_243 target = new class_243(class_3532.method_16436((double)delta, (double)prev.getPosition().x(), (double)cur.getPosition().x()), class_3532.method_16436((double)delta, (double)prev.getPosition().y(), (double)cur.getPosition().y()), class_3532.method_16436((double)delta, (double)prev.getPosition().z(), (double)cur.getPosition().z()));
        float pitch = class_3532.method_16439((float)delta, (float)((float)prev.getRotation().x()), (float)((float)cur.getRotation().x()));
        float yaw = class_3532.method_16439((float)delta, (float)((float)prev.getRotation().y()), (float)((float)cur.getRotation().y())) % 360.0f;
        float roll = class_3532.method_16439((float)delta, (float)((float)prev.getRotation().z()), (float)((float)cur.getRotation().z()));
        double zoom = class_3532.method_16439((float)delta, (float)prev.getZoom(), (float)cur.getZoom());
        this.entity.updatePrev();
        this.entity.method_23327(target.field_1352, target.field_1351, target.field_1350);
        this.entity.setRotation(pitch, yaw, roll);
        FabricClient.INSTANCE.getZoomHandler().setZoom(zoom);
        this.tickCounter += (double)(1.0f + tickDelta);
        if (delta >= 1.0f || this.tickCounter >= this.segmentTime) {
            this.segmentIndex = (int)((double)this.segmentIndex + this.tickCounter / this.segmentTime);
            this.tickCounter %= this.segmentTime;
            if (this.segmentIndex >= this.currentSegmentData.size()) {
                this.segmentIndex = 1;
                ++this.nodeIndex;
                if (this.nodeIndex >= this.path.getNodes().size() - (this.loop ? 0 : 1)) {
                    if (!this.loop) {
                        this.end();
                    } else {
                        this.nodeIndex = 0;
                        this.tickCounter = 0.0;
                        this.segmentIndex = 1;
                        this.currentNode = (PathNode)this.path.getNodes().get(0);
                        this.currentSegmentData = (LinkedList)this.path.getInterpolatedData(this.loop).get(this.currentNode);
                    }
                } else {
                    this.currentNode = (PathNode)this.path.getNodes().get(this.nodeIndex);
                    this.currentSegmentData = (LinkedList)this.path.getInterpolatedData(this.loop).get(this.currentNode);
                }
            }
        }
    }

    public boolean isFollowing() {
        return this.path != null;
    }

    private CommandWrapper.GameMode getModeFromVanilla(class_1934 mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case class_1934.field_9220, class_1934.field_9218 -> CommandWrapper.GameMode.CREATIVE;
            case class_1934.field_9215 -> CommandWrapper.GameMode.SURVIVAL;
            case class_1934.field_9216 -> CommandWrapper.GameMode.ADVENTURE;
            case class_1934.field_9219 -> CommandWrapper.GameMode.SPECTATOR;
        };
    }
}

