/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.ui.widgets;

import net.minecraft.class_2561;
import net.minecraft.class_4185;
import org.apache.commons.lang3.math.NumberUtils;
import studio.archetype.shutter.ui.widgets.EnumButtonWidget;
import studio.archetype.shutter.ui.widgets.PredicateTextboxWidget;
import studio.archetype.shutter.utils.TimeUnits;

public class TickTimeTextboxWidget
extends PredicateTextboxWidget {
    private final EnumButtonWidget<TimeUnits> unitButton;
    private float value;
    private TimeUnits currentUnit;

    public TickTimeTextboxWidget(int x, int y, int width, int height, class_2561 label, float initialValue, TimeUnits initialUnit) {
        super(x, y, width - (height + height / 4), height, label);
        this.currentUnit = initialUnit;
        this.unitButton = new EnumButtonWidget<TimeUnits>("Unit", x + this.field_22758 + this.field_22759 / 4, y, height, height, TimeUnits.SECONDS, this::updateUnit);
        this.unitButton.setPrefix(false);
        this.setValidPredicate(this::parseValue);
        this.method_1852(String.valueOf(initialValue));
        this.method_1880(32);
    }

    public int getTicks() {
        return (int)TimeUnits.convert((float)this.value, (TimeUnits)this.currentUnit, (TimeUnits)TimeUnits.TICKS);
    }

    public class_4185 getButton() {
        return this.unitButton;
    }

    public void updateUnit(TimeUnits unit) {
        this.currentUnit = unit;
    }

    public TimeUnits getCurrentUnit() {
        return this.currentUnit;
    }

    private boolean parseValue(String text) {
        if (NumberUtils.isParsable((String)text)) {
            if (this.currentUnit.isFloatingPoint) {
                try {
                    this.value = Float.parseFloat(text);
                    return true;
                }
                catch (NumberFormatException ex) {
                    return false;
                }
            }
            try {
                this.value = Integer.parseInt(text);
                return true;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }
}

