/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.util;

import java.util.stream.Stream;
import net.minecraft.class_1159;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import studio.archetype.shutter.api.VersionUtils;
import studio.archetype.shutter.math.Vec3d;

public class DrawUtils {
    public static void quadOffsetAxis(Vec3d pos, double radius, class_2350 dir, Vec3d colour, class_4588 consumer, class_1159 model) {
        class_2382 dirVector = dir.method_10163();
        Vec3d offset = pos.add(new Vec3d((double)dirVector.method_10263() * radius, (double)dirVector.method_10264() * radius, (double)dirVector.method_10260() * radius));
        Vec3d[] points = new Vec3d[4];
        switch (dir.method_10166()) {
            case field_11048: {
                points[0] = offset.add(new Vec3d(0.0, radius, radius));
                points[1] = offset.add(new Vec3d(0.0, -radius, radius));
                points[2] = offset.add(new Vec3d(0.0, -radius, -radius));
                points[3] = offset.add(new Vec3d(0.0, radius, -radius));
                break;
            }
            case field_11052: {
                points[0] = offset.add(new Vec3d(radius, 0.0, radius));
                points[1] = offset.add(new Vec3d(radius, 0.0, -radius));
                points[2] = offset.add(new Vec3d(-radius, 0.0, -radius));
                points[3] = offset.add(new Vec3d(-radius, 0.0, radius));
                break;
            }
            case field_11051: {
                points[0] = offset.add(new Vec3d(radius, radius, 0.0));
                points[1] = offset.add(new Vec3d(-radius, radius, 0.0));
                points[2] = offset.add(new Vec3d(-radius, -radius, 0.0));
                points[3] = offset.add(new Vec3d(radius, -radius, 0.0));
            }
        }
        if (dir.method_10171().method_10181() < 0) {
            Vec3d t = points[1];
            points[1] = points[3];
            points[3] = t;
        }
        for (Vec3d point : points) {
            consumer.method_22918(model, (float)point.x(), (float)point.y(), (float)point.z()).method_22915((float)colour.x(), (float)colour.y(), (float)colour.z(), 1.0f).method_1344();
        }
    }

    public static void renderCube(Vec3d pos, float radius, Vec3d colour, class_4588 consumer, class_4587.class_4665 stack) {
        Stream.of(class_2350.values()).forEach(dir -> DrawUtils.quadOffsetAxis(pos, radius, dir, colour, consumer, VersionUtils.INSTANCE.getModelMatrix(stack)));
    }

    public static void renderLine(Vec3d pos, Vec3d pos2, Vec3d colour, class_4588 consumer, class_4587.class_4665 stack) {
        consumer.method_22918(VersionUtils.INSTANCE.getModelMatrix(stack), (float)pos.x(), (float)pos.y(), (float)pos.z()).method_22915((float)colour.x(), (float)colour.y(), (float)colour.z(), 1.0f).method_1344();
        consumer.method_22918(VersionUtils.INSTANCE.getModelMatrix(stack), (float)pos2.x(), (float)pos2.y(), (float)pos2.z()).method_22915((float)colour.x(), (float)colour.y(), (float)colour.z(), 1.0f).method_1344();
    }

    public static Vec3d getOffsetPoint(Vec3d pos, float pitch, float yaw, double distance) {
        Vec3d dir = DrawUtils.getRotationVector(pitch, yaw);
        return pos.add(new Vec3d(dir.x() * distance, dir.y() * distance, dir.z() * distance));
    }

    public static Vec3d getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new Vec3d((double)(i * j), (double)(-k), (double)(h * j));
    }
}

