/*
 * Decompiled with CFR 0.152.
 */
package studio.archetype.shutter.util;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;

public class TimingUtils {
    private static final List<Job> jobs = new ArrayList<Job>();

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(t -> jobs.removeIf(Job::tick));
    }

    public static void schedule(int ticks, Runnable runnable) {
        jobs.add(new Job(ticks, runnable));
    }

    private static class Job {
        private final Runnable runnable;
        private int timer;

        public Job(int timer, Runnable runnable) {
            this.runnable = runnable;
            this.timer = timer;
        }

        public boolean tick() {
            if (this.timer-- == 0) {
                this.runnable.run();
                return true;
            }
            return false;
        }
    }
}

