/*
 * Decompiled with CFR 0.152.
 */
package net.bagelvulture.tutorialmod.block.entity.custom;

import java.util.Optional;
import net.bagelvulture.tutorialmod.block.entity.ImplementedInventory;
import net.bagelvulture.tutorialmod.block.entity.ModBlockEntities;
import net.bagelvulture.tutorialmod.recipe.ModRecipes;
import net.bagelvulture.tutorialmod.recipe.PinkRecipe;
import net.bagelvulture.tutorialmod.recipe.PinkRecipeInput;
import net.bagelvulture.tutorialmod.screen.custom.PinkScreenHandler;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class PinkBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338>,
ImplementedInventory {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> PinkBlockEntity.this.progress;
                case 1 -> PinkBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    PinkBlockEntity.this.progress = value;
                }
                case 1: {
                    PinkBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;

    public PinkBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.PINK_BE, pos, state);
    }

    public class_2338 getScreenOpeningData(class_3222 player) {
        return this.field_11867;
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.tutorialmod.pink");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new PinkScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        nbt.method_10569("pink.progress", this.progress);
        nbt.method_10569("pink.max_progress", this.maxProgress);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
        this.progress = nbt.method_10550("pink.progress");
        this.maxProgress = nbt.method_10550("pink.max_progress");
        super.method_11014(nbt, registryLookup);
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        Optional<class_8786<PinkRecipe>> recipeEntry = this.getCurrentRecipe();
        if (recipeEntry.isPresent()) {
            PinkRecipe pinkRecipe = (PinkRecipe)recipeEntry.get().comp_1933();
            if (this.progress == 0) {
                this.maxProgress = pinkRecipe.pinkingTime();
            }
            this.increaseCraftingProgress();
            PinkBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void craftItem() {
        Optional<class_8786<PinkRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        PinkRecipe pinkRecipe = (PinkRecipe)recipe.get().comp_1933();
        class_1799 output = pinkRecipe.output();
        this.method_5434(0, pinkRecipe.inputCount());
        this.method_5447(1, new class_1799((class_1935)output.method_7909(), this.method_5438(1).method_7947() + output.method_7947()));
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        Optional<class_8786<PinkRecipe>> recipeEntry = this.getCurrentRecipe();
        if (recipeEntry.isEmpty()) {
            return;
        }
        PinkRecipe recipe = (PinkRecipe)recipeEntry.get().comp_1933();
        class_1799 result = recipe.output();
        if (this.canInsertItemIntoOutputSlot(result) && this.canInsertAmountIntoOutputSlot(result.method_7947())) {
            ++this.progress;
        }
    }

    private boolean hasRecipe() {
        Optional<class_8786<PinkRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        class_1799 output = ((PinkRecipe)recipe.get().comp_1933()).output();
        return this.canInsertAmountIntoOutputSlot(output.method_7947()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<class_8786<PinkRecipe>> getCurrentRecipe() {
        return this.method_10997().method_8433().method_8132(ModRecipes.PINK_TYPE, (class_9695)new PinkRecipeInput((class_1799)this.inventory.get(0)), this.method_10997());
    }

    private boolean canInsertItemIntoOutputSlot(class_1799 output) {
        return this.method_5438(1).method_7960() || this.method_5438(1).method_7909() == output.method_7909();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.method_5438(1).method_7960() ? 64 : this.method_5438(1).method_7914();
        int currentCount = this.method_5438(1).method_7947();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }
}

