/*
 * Decompiled with CFR 0.152.
 */
package net.bagelvulture.tutorialmod.item.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.bagelvulture.tutorialmod.item.ModArmorMaterials;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_6880;

public class ModArmorItem
extends class_1738 {
    private static final Map<class_6880<class_1741>, List<class_1293>> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put(ModArmorMaterials.BEVULTRIUM_ARMOR_MATERIAL, List.of(new class_1293(class_1294.field_5910, 200, 255, false, false), new class_1293(class_1294.field_5920, 4000, 3, false, false))).build();

    public ModArmorItem(class_6880<class_1741> material, class_1738.class_8051 type, class_1792.class_1793 settings) {
        super(material, type, settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        if (!world.method_8608() && entity instanceof class_1657 && this.hasFullSuitOfArmorOn(player = (class_1657)entity)) {
            this.evaluateArmorEffects(player);
        }
        super.method_7888(stack, world, entity, slot, selected);
    }

    private void evaluateArmorEffects(class_1657 player) {
        for (Map.Entry<class_6880<class_1741>, List<class_1293>> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            class_6880<class_1741> mapArmorMaterial = entry.getKey();
            List<class_1293> mapStatusEffects = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorMaterial, player)) continue;
            this.addStatusEffectForMaterial(player, mapArmorMaterial, mapStatusEffects);
        }
    }

    private void addStatusEffectForMaterial(class_1657 player, class_6880<class_1741> mapArmorMaterial, List<class_1293> mapStatusEffect) {
        boolean hasPlayerEffect = mapStatusEffect.stream().allMatch(statusEffectInstance -> player.method_6059(statusEffectInstance.method_5579()));
        if (!hasPlayerEffect) {
            for (class_1293 instance : mapStatusEffect) {
                player.method_6092(new class_1293(instance.method_5579(), instance.method_5584(), instance.method_5578(), instance.method_5591(), instance.method_5581()));
            }
        }
    }

    private boolean hasFullSuitOfArmorOn(class_1657 player) {
        class_1799 boots = player.method_31548().method_7372(0);
        class_1799 leggings = player.method_31548().method_7372(1);
        class_1799 breastplate = player.method_31548().method_7372(2);
        class_1799 helmet = player.method_31548().method_7372(3);
        return !helmet.method_7960() && !breastplate.method_7960() && !leggings.method_7960() && !boots.method_7960();
    }

    private boolean hasCorrectArmorOn(class_6880<class_1741> material, class_1657 player) {
        for (class_1799 armorStack : player.method_31548().field_7548) {
            if (armorStack.method_7909() instanceof class_1738) continue;
            return false;
        }
        class_1738 boots = (class_1738)player.method_31548().method_7372(0).method_7909();
        class_1738 leggings = (class_1738)player.method_31548().method_7372(1).method_7909();
        class_1738 breastplate = (class_1738)player.method_31548().method_7372(2).method_7909();
        class_1738 helmet = (class_1738)player.method_31548().method_7372(3).method_7909();
        return helmet.method_7686() == material && breastplate.method_7686() == material && leggings.method_7686() == material && boots.method_7686() == material;
    }
}

