/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.GlobalRender;
import at.hannibal2.skyhanni.events.DrawScreenAfterEvent;
import at.hannibal2.skyhanni.events.GuiRenderItemEvent;
import at.hannibal2.skyhanni.events.RenderInventoryItemTipEvent;
import at.hannibal2.skyhanni.events.RenderItemTipEvent;
import at.hannibal2.skyhanni.events.RenderObject;
import at.hannibal2.skyhanni.mixins.transformers.gui.AccessorGuiContainer;
import at.hannibal2.skyhanni.utils.GuiRenderUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.compat.DrawContextUtils;
import at.hannibal2.skyhanni.utils.compat.InventoryCompat;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lat/hannibal2/skyhanni/data/ItemTipHelper;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderItemEvent$RenderOverlayEvent$GuiRenderItemPost;", "event", "", "onRenderItemOverlayPost", "(Lat/hannibal2/skyhanni/events/GuiRenderItemEvent$RenderOverlayEvent$GuiRenderItemPost;)V", "Lat/hannibal2/skyhanni/events/DrawScreenAfterEvent;", "onRenderInventoryItemOverlayPost", "(Lat/hannibal2/skyhanni/events/DrawScreenAfterEvent;)V", "1.8.9"})
public final class ItemTipHelper {
    @NotNull
    public static final ItemTipHelper INSTANCE = new ItemTipHelper();

    private ItemTipHelper() {
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderItemOverlayPost(@NotNull GuiRenderItemEvent.RenderOverlayEvent.GuiRenderItemPost event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        ItemStack itemStack = event2.getStack();
        if (itemStack == null) {
            return;
        }
        ItemStack stack = itemStack;
        RenderItemTipEvent itemTipEvent = new RenderItemTipEvent(stack, new ArrayList());
        itemTipEvent.post();
        if (itemTipEvent.getRenderObjects().isEmpty()) {
            return;
        }
        for (RenderObject renderObject : itemTipEvent.getRenderObjects()) {
            String text = renderObject.getText();
            int x = event2.getX() + 17 + renderObject.getOffsetX();
            int y = event2.getY() + 9 + renderObject.getOffsetY();
            RenderUtils.INSTANCE.drawSlotText(event2, x, y, text, 1.0f);
        }
    }

    @HandleEvent(onlyOnSkyblock=true, priority=-2)
    public final void onRenderInventoryItemOverlayPost(@NotNull DrawScreenAfterEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (GlobalRender.INSTANCE.getRenderDisabled()) {
            return;
        }
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (!(gui instanceof GuiChest)) {
            return;
        }
        String inventoryName = InventoryUtils.INSTANCE.openInventoryName();
        int guiLeft = ((AccessorGuiContainer)gui).getGuiLeft();
        int guiTop = ((AccessorGuiContainer)gui).getGuiTop();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179084_k();
        DrawContextUtils.INSTANCE.pushMatrix();
        DrawContextUtils.INSTANCE.translate(0.0f, 0.0f, 300.0f);
        for (Slot slot : ((GuiChest)gui).field_147002_h.field_75151_b) {
            ItemStack stack;
            if (InventoryCompat.INSTANCE.orNull(slot.func_75211_c()) == null) continue;
            Intrinsics.checkNotNull(slot);
            RenderInventoryItemTipEvent itemTipEvent = new RenderInventoryItemTipEvent(inventoryName, slot, stack, null, 0, 0, false, 120, null);
            itemTipEvent.post();
            String stackTip = itemTipEvent.getStackTip();
            if (((CharSequence)stackTip).length() == 0) continue;
            int xDisplayPosition = slot.field_75223_e;
            int yDisplayPosition = slot.field_75221_f;
            int x = guiLeft + xDisplayPosition + 17 + itemTipEvent.getOffsetX() - (itemTipEvent.getAlignLeft() ? fontRenderer.func_78256_a(stackTip) : 0);
            int y = guiTop + yDisplayPosition + 9 + itemTipEvent.getOffsetY();
            GuiRenderUtils.drawString$default(GuiRenderUtils.INSTANCE, stackTip, x, y, -1, false, 16, null);
        }
        DrawContextUtils.INSTANCE.popMatrix();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }
}

