/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.entity;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.SkyHanniRenderEntityEvent;
import at.hannibal2.skyhanni.events.entity.EntityOpacityActiveEvent;
import at.hannibal2.skyhanni.events.entity.EntityOpacityEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.events.render.EntityRenderLayersEvent;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import com.google.common.base.Predicate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001d\u0010\u0017\u001a\u00020\u00042\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lat/hannibal2/skyhanni/data/entity/EntityOpacityManager;", "", "<init>", "()V", "", "onSecondPassed", "onTick", "Lnet/minecraft/entity/EntityLivingBase;", "entity", "", "canChangeOpacity", "(Lnet/minecraft/entity/EntityLivingBase;)Z", "", "opacity", "(Lnet/minecraft/entity/EntityLivingBase;)I", "Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Pre;", "event", "onPreRender", "(Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Pre;)V", "Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Post;", "onPostRender", "(Lat/hannibal2/skyhanni/events/SkyHanniRenderEntityEvent$Post;)V", "Lat/hannibal2/skyhanni/events/render/EntityRenderLayersEvent$Pre;", "onRender", "(Lat/hannibal2/skyhanni/events/render/EntityRenderLayersEvent$Pre;)V", "shouldHide", "Z", "", "entities", "Ljava/util/Map;", "active", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nEntityOpacityManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityOpacityManager.kt\nat/hannibal2/skyhanni/data/entity/EntityOpacityManager\n+ 2 EntityUtils.kt\nat/hannibal2/skyhanni/utils/EntityUtils\n*L\n1#1,91:1\n148#2:92\n46#2:93\n149#2,9:94\n196#2,9:103\n*S KotlinDebug\n*F\n+ 1 EntityOpacityManager.kt\nat/hannibal2/skyhanni/data/entity/EntityOpacityManager\n*L\n36#1:92\n36#1:93\n36#1:94,9\n36#1:103,9\n*E\n"})
public final class EntityOpacityManager {
    @NotNull
    public static final EntityOpacityManager INSTANCE = new EntityOpacityManager();
    private static boolean shouldHide;
    @NotNull
    private static Map<EntityLivingBase, Integer> entities;
    private static boolean active;

    private EntityOpacityManager() {
    }

    @HandleEvent(eventType=SecondPassedEvent.class)
    public final void onSecondPassed() {
        EntityOpacityActiveEvent event2 = new EntityOpacityActiveEvent();
        event2.post();
        active = event2.isActive();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(eventType=SkyHanniTickEvent.class, onlyOnSkyblock=true)
    public final void onTick() {
        List list;
        void this_$iv$iv$iv;
        void this_$iv$iv;
        void $this$iv;
        if (!active) {
            return;
        }
        Map entities = new LinkedHashMap();
        EntityUtils entityUtils = EntityUtils.INSTANCE;
        double radius$iv = 80.0;
        void this_$iv$iv2 = $this$iv;
        boolean $i$f$getALWAYS = false;
        Function1 predicate$iv = EntityUtils.ALWAYS.1.INSTANCE;
        boolean $i$f$getEntitiesNextToPlayer = false;
        void var10_11 = $this$iv;
        LorenzVec location$iv$iv = LocationUtils.INSTANCE.playerLocation();
        boolean $i$f$getEntitiesNearby = false;
        void var11_12 = this_$iv$iv;
        Function1 predicate$iv$iv$iv = new Function1<EntityLivingBase, Boolean>(location$iv$iv, radius$iv, predicate$iv){
            final /* synthetic */ LorenzVec $location;
            final /* synthetic */ double $radius;
            final /* synthetic */ Function1 $predicate;
            {
                this.$location = $location;
                this.$radius = $radius;
                this.$predicate = $predicate;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Boolean invoke(Entity it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return LocationUtils.INSTANCE.distanceTo(it, this.$location) < this.$radius && (Boolean)this.$predicate.invoke(it) != false;
            }
        };
        boolean $i$f$getEntitiesInBox = false;
        void var14_15 = this_$iv$iv$iv;
        AxisAlignedBB aabb$iv$iv$iv$iv = location$iv$iv.boundingCenter(radius$iv);
        boolean $i$f$getEntitiesInBoundingBox = false;
        WorldClient worldClient = MinecraftCompat.INSTANCE.getLocalWorldOrNull();
        if (worldClient == null) {
            list = CollectionsKt.emptyList();
        } else {
            WorldClient world$iv$iv$iv$iv = worldClient;
            Function1 function1 = new Function1<EntityLivingBase, Boolean>(predicate$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                {
                    this.$predicate = $predicate;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Boolean invoke(Entity it) {
                    return it != null && (Boolean)this.$predicate.invoke(it) != false;
                }
            };
            List list2 = world$iv$iv$iv$iv.func_175647_a(EntityLivingBase.class, aabb$iv$iv$iv$iv, new Predicate(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter(function, "function");
                    this.function = function;
                }

                public final /* synthetic */ boolean apply(@Nullable Object p0) {
                    return (Boolean)this.function.invoke(p0);
                }
            });
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, "getEntitiesWithinAABB(...)");
        }
        for (EntityLivingBase entity : list) {
            EntityOpacityEvent<EntityLivingBase> event2 = new EntityOpacityEvent<EntityLivingBase>(entity);
            event2.post();
            Integer n = event2.getOpacity();
            if (n == null) continue;
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it;
            entities.put(entity, n2);
        }
        EntityOpacityManager.entities = entities;
    }

    private final boolean canChangeOpacity(EntityLivingBase entity) {
        EntityLivingBase[] entityLivingBaseArray = new EntityLivingBase[]{entity};
        return CollectionUtils.INSTANCE.containsKeys(entities, entityLivingBaseArray) && this.opacity(entity) < 100;
    }

    private final int opacity(EntityLivingBase entity) {
        Integer n = entities.get(entity);
        if (n == null) {
            throw new IllegalStateException("can not read opacity bc not in map".toString());
        }
        return n;
    }

    @HandleEvent
    public final void onPreRender(@NotNull SkyHanniRenderEntityEvent.Pre<EntityLivingBase> event2) {
        boolean canChangeOpacity;
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!active) {
            return;
        }
        shouldHide = canChangeOpacity = this.canChangeOpacity((EntityLivingBase)event2.getEntity());
        if (!canChangeOpacity) {
            return;
        }
        int opacity = this.opacity((EntityLivingBase)event2.getEntity());
        if (opacity <= 0) {
            event2.cancel();
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)opacity / 100.0f));
    }

    @HandleEvent
    public final void onPostRender(@NotNull SkyHanniRenderEntityEvent.Post<EntityLivingBase> event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!active) {
            return;
        }
        if (!this.canChangeOpacity((EntityLivingBase)event2.getEntity())) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
    }

    @HandleEvent
    public final void onRender(@NotNull EntityRenderLayersEvent.Pre<EntityLivingBase> event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!active) {
            return;
        }
        if (!this.canChangeOpacity((EntityLivingBase)event2.getEntity())) {
            return;
        }
        if (!shouldHide) {
            return;
        }
        event2.cancel();
    }

    static {
        entities = MapsKt.emptyMap();
    }
}

