/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data.mob;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.WorldChangeEvent;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u000f\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u0017\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bR \u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00110\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lat/hannibal2/skyhanni/data/mob/LineToMobHandler;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/data/mob/Mob;", "mob", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "color", "", "width", "", "depth", "Lkotlin/Function0;", "condition", "", "register", "(Lat/hannibal2/skyhanni/data/mob/Mob;Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;IZLkotlin/jvm/functions/Function0;)V", "Lat/hannibal2/skyhanni/data/mob/LineToMobHandler$LineSettings;", "settings", "(Lat/hannibal2/skyhanni/data/mob/Mob;Lat/hannibal2/skyhanni/data/mob/LineToMobHandler$LineSettings;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn;", "event", "onMobDeSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "", "lines", "Ljava/util/Map;", "LineSettings", "1.8.9"})
public final class LineToMobHandler {
    @NotNull
    public static final LineToMobHandler INSTANCE = new LineToMobHandler();
    @NotNull
    private static final Map<Mob, LineSettings> lines = new LinkedHashMap();

    private LineToMobHandler() {
    }

    public final void register(@NotNull Mob mob, @NotNull ChromaColour color, int width, boolean depth, @NotNull Function0<Boolean> condition) {
        Intrinsics.checkNotNullParameter(mob, "mob");
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(condition, "condition");
        this.register(mob, new LineSettings(color, width, depth, condition));
    }

    public final void register(@NotNull Mob mob, @NotNull LineSettings settings) {
        Intrinsics.checkNotNullParameter(mob, "mob");
        Intrinsics.checkNotNullParameter(settings, "settings");
        lines.put(mob, settings);
    }

    @HandleEvent
    public final void onMobDeSpawn(@NotNull MobEvent.DeSpawn event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        lines.remove(event2.getMob());
    }

    @HandleEvent(eventType=WorldChangeEvent.class)
    public final void onWorldChange() {
        lines.clear();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (lines.isEmpty()) {
            return;
        }
        for (Map.Entry<Mob, LineSettings> entry : lines.entrySet()) {
            Mob mob = entry.getKey();
            LineSettings settings = entry.getValue();
            if (!settings.getCondition().invoke().booleanValue() || !Mob.canBeSeen$default(mob, null, 1, null)) continue;
            WorldRenderUtils.INSTANCE.drawLineToEye(event2, mob.getCenterCords(), settings.getColor(), settings.getWidth(), settings.getDepth());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J>\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\u00062\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u000fJ\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010\u0011R\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010$\u001a\u0004\b%\u0010\u0013\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/data/mob/LineToMobHandler$LineSettings;", "", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "color", "", "width", "", "depth", "Lkotlin/Function0;", "condition", "<init>", "(Lio/github/notenoughupdates/moulconfig/ChromaColour;IZLkotlin/jvm/functions/Function0;)V", "component1", "()Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "component2", "()I", "component3", "()Z", "component4", "()Lkotlin/jvm/functions/Function0;", "copy", "(Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;IZLkotlin/jvm/functions/Function0;)Lat/hannibal2/skyhanni/data/mob/LineToMobHandler$LineSettings;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/deps/moulconfig/ChromaColour;", "getColor", "()Lio/github/notenoughupdates/moulconfig/ChromaColour;", "I", "getWidth", "Z", "getDepth", "Lkotlin/jvm/functions/Function0;", "getCondition", "1.8.9"})
    public static final class LineSettings {
        @NotNull
        private final ChromaColour color;
        private final int width;
        private final boolean depth;
        @NotNull
        private final Function0<Boolean> condition;

        public LineSettings(@NotNull ChromaColour color, int width, boolean depth, @NotNull Function0<Boolean> condition) {
            Intrinsics.checkNotNullParameter(color, "color");
            Intrinsics.checkNotNullParameter(condition, "condition");
            this.color = color;
            this.width = width;
            this.depth = depth;
            this.condition = condition;
        }

        @NotNull
        public final ChromaColour getColor() {
            return this.color;
        }

        public final int getWidth() {
            return this.width;
        }

        public final boolean getDepth() {
            return this.depth;
        }

        @NotNull
        public final Function0<Boolean> getCondition() {
            return this.condition;
        }

        @NotNull
        public final ChromaColour component1() {
            return this.color;
        }

        public final int component2() {
            return this.width;
        }

        public final boolean component3() {
            return this.depth;
        }

        @NotNull
        public final Function0<Boolean> component4() {
            return this.condition;
        }

        @NotNull
        public final LineSettings copy(@NotNull ChromaColour color, int width, boolean depth, @NotNull Function0<Boolean> condition) {
            Intrinsics.checkNotNullParameter(color, "color");
            Intrinsics.checkNotNullParameter(condition, "condition");
            return new LineSettings(color, width, depth, condition);
        }

        public static /* synthetic */ LineSettings copy$default(LineSettings lineSettings, ChromaColour chromaColour, int n, boolean bl, Function0 function0, int n2, Object object) {
            if ((n2 & 1) != 0) {
                chromaColour = lineSettings.color;
            }
            if ((n2 & 2) != 0) {
                n = lineSettings.width;
            }
            if ((n2 & 4) != 0) {
                bl = lineSettings.depth;
            }
            if ((n2 & 8) != 0) {
                function0 = lineSettings.condition;
            }
            return lineSettings.copy(chromaColour, n, bl, function0);
        }

        @NotNull
        public String toString() {
            return "LineSettings(color=" + this.color + ", width=" + this.width + ", depth=" + this.depth + ", condition=" + this.condition + ')';
        }

        public int hashCode() {
            int result2 = this.color.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.width);
            result2 = result2 * 31 + Boolean.hashCode(this.depth);
            result2 = result2 * 31 + this.condition.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LineSettings)) {
                return false;
            }
            LineSettings lineSettings = (LineSettings)other;
            if (!Intrinsics.areEqual(this.color, lineSettings.color)) {
                return false;
            }
            if (this.width != lineSettings.width) {
                return false;
            }
            if (this.depth != lineSettings.depth) {
                return false;
            }
            return Intrinsics.areEqual(this.condition, lineSettings.condition);
        }
    }
}

