/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.internal;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class RenderUtils {
    public static void drawOpenCloseTriangle(boolean isOpen, double x, double y, double width, double height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        worldrenderer.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        if (isOpen) {
            worldrenderer.func_181662_b(x, y, 0.0).func_181675_d();
            worldrenderer.func_181662_b(x + width / 2.0, y + height, 0.0).func_181675_d();
            worldrenderer.func_181662_b(x + width, y, 0.0).func_181675_d();
        } else {
            worldrenderer.func_181662_b(x, y + height, 0.0).func_181675_d();
            worldrenderer.func_181662_b(x + width, y + height / 2.0, 0.0).func_181675_d();
            worldrenderer.func_181662_b(x, y, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawFloatingRectDark(int x, int y, int width, int height) {
        RenderUtils.drawFloatingRectDark(x, y, width, height, true);
    }

    public static void drawFloatingRectDark(int x, int y, int width, int height, boolean shadow) {
        int alpha = -268435456;
        if (OpenGlHelper.func_148822_b()) {
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        } else {
            alpha = -16777216;
        }
        int main = alpha | 0x202026;
        int light = -13619146;
        int dark = -15724522;
        Gui.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + height), (int)light);
        Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + width), (int)(y + 1), (int)light);
        Gui.func_73734_a((int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height), (int)dark);
        Gui.func_73734_a((int)(x + 1), (int)(y + height - 1), (int)(x + width - 1), (int)(y + height), (int)dark);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)main);
        if (shadow) {
            Gui.func_73734_a((int)(x + width), (int)(y + 2), (int)(x + width + 2), (int)(y + height + 2), (int)0x70000000);
            Gui.func_73734_a((int)(x + 2), (int)(y + height), (int)(x + width), (int)(y + height + 2), (int)0x70000000);
        }
    }

    public static void drawFloatingRect(int x, int y, int width, int height) {
        RenderUtils.drawFloatingRectWithAlpha(x, y, width, height, 255, true);
    }

    public static void drawFloatingRectWithAlpha(int x, int y, int width, int height, int alpha, boolean shadow) {
        int main = alpha << 24 | 0xC0C0C0;
        int light = alpha << 24 | 0xF0F0F0;
        int dark = alpha << 24 | 0x909090;
        Gui.func_73734_a((int)x, (int)y, (int)(x + 1), (int)(y + height), (int)light);
        Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + width), (int)(y + 1), (int)light);
        Gui.func_73734_a((int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height), (int)dark);
        Gui.func_73734_a((int)(x + 1), (int)(y + height - 1), (int)(x + width - 1), (int)(y + height), (int)dark);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)main);
        if (shadow) {
            Gui.func_73734_a((int)(x + width), (int)(y + 2), (int)(x + width + 2), (int)(y + height + 2), (int)(alpha * 3 / 5 << 24));
            Gui.func_73734_a((int)(x + 2), (int)(y + height), (int)(x + width), (int)(y + height + 2), (int)(alpha * 3 / 5 << 24));
        }
    }

    public static void drawTexturedRect(float x, float y, float width, float height) {
        RenderUtils.drawTexturedRect(x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, int filter2) {
        RenderUtils.drawTexturedRect(x, y, width, height, 0.0f, 1.0f, 0.0f, 1.0f, filter2);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax) {
        RenderUtils.drawTexturedRect(x, y, width, height, uMin, uMax, vMin, vMax, 9728);
    }

    public static void drawTexturedRect(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax, int filter2) {
        GlStateManager.func_179147_l();
        GL14.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        RenderUtils.drawTexturedRectNoBlend(x, y, width, height, uMin, uMax, vMin, vMax, filter2);
        GlStateManager.func_179084_k();
    }

    public static void drawTexturedRectNoBlend(float x, float y, float width, float height, float uMin, float uMax, float vMin, float vMax, int filter2) {
        GlStateManager.func_179098_w();
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter2);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter2);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181673_a((double)uMin, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181673_a((double)uMax, (double)vMax).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181673_a((double)uMax, (double)vMin).func_181675_d();
        worldrenderer.func_181662_b((double)x, (double)y, 0.0).func_181673_a((double)uMin, (double)vMin).func_181675_d();
        tessellator.func_78381_a();
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
    }

    public static void drawGradientRect(int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        worldrenderer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        worldrenderer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }
}

