/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.dungeon.DungeonConfig;
import at.hannibal2.skyhanni.events.RenderEntityOutlineEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonTeammateOutlines;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/RenderEntityOutlineEvent;", "event", "", "onRenderEntityOutlines", "(Lat/hannibal2/skyhanni/events/RenderEntityOutlineEvent;)V", "", "isEnabled", "()Z", "Lnet/minecraft/entity/Entity;", "entity", "Ljava/awt/Color;", "getEntityOutlineColor", "(Lnet/minecraft/entity/Entity;)Ljava/awt/Color;", "Lat/hannibal2/skyhanni/config/features/dungeon/DungeonConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dungeon/DungeonConfig;", "config", "1.8.9"})
public final class DungeonTeammateOutlines {
    @NotNull
    public static final DungeonTeammateOutlines INSTANCE = new DungeonTeammateOutlines();

    private DungeonTeammateOutlines() {
    }

    private final DungeonConfig getConfig() {
        return SkyHanniMod.feature.getDungeon();
    }

    @HandleEvent
    public final void onRenderEntityOutlines(@NotNull RenderEntityOutlineEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (this.isEnabled() && event2.getType() == RenderEntityOutlineEvent.Type.XRAY) {
            event2.queueEntitiesToOutline(DungeonTeammateOutlines::onRenderEntityOutlines$lambda$0);
        }
    }

    private final boolean isEnabled() {
        return DungeonApi.INSTANCE.inDungeon() && this.getConfig().getHighlightTeammates();
    }

    private final Color getEntityOutlineColor(Entity entity) {
        Color color;
        if (!(entity instanceof EntityOtherPlayerMP) || ((EntityOtherPlayerMP)entity).func_96124_cp() == null) {
            return null;
        }
        Team team = ((EntityOtherPlayerMP)entity).func_96124_cp();
        Intrinsics.checkNotNull(team, "null cannot be cast to non-null type net.minecraft.scoreboard.ScorePlayerTeam");
        ScorePlayerTeam team2 = (ScorePlayerTeam)team;
        if (team2.func_178770_i() == Team.EnumVisible.NEVER) {
            return null;
        }
        String string = team2.func_96668_e();
        Intrinsics.checkNotNullExpressionValue(string, "getColorPrefix(...)");
        String colorFormat = StringUtils.INSTANCE.getFormatFromString(string);
        if (colorFormat.length() >= 2) {
            LorenzColor lorenzColor = LorenzColor.Companion.toLorenzColor(colorFormat.charAt(1));
            color = lorenzColor != null ? lorenzColor.toColor() : null;
        } else {
            color = null;
        }
        return color;
    }

    private static final Color onRenderEntityOutlines$lambda$0(Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        return INSTANCE.getEntityOutlineColor(entity);
    }
}

