/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.hoppity;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiEasterEvent;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiEvents;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiPlayer;
import at.hannibal2.skyhanni.data.jsonobjects.other.HypixelApiRabbits;
import at.hannibal2.skyhanni.data.jsonobjects.repo.HoppityEggLocationsJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.NeuProfileDataLoadedEvent;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.event.hoppity.HoppityEggsManager;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFApi;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u001f\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ)\u0010\u001f\u001a\u00020\u00102\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b!\u0010\u0003J\u0017\u0010#\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'R&\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070)0(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R:\u0010.\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00070\u001d0\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010/\u001a\u0004\b0\u0010+\"\u0004\b1\u0010 R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b5\u00103R\u0016\u00107\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u00109\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u00108\u00a8\u0006:"}, d2={"Lat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocations;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/data/IslandType;", "islandType", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getEggsIn", "(Lat/hannibal2/skyhanni/data/IslandType;)Ljava/util/Set;", "location", "", "hasCollectedEgg", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Z", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "event", "", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "saveNearestEgg", "island", "saveEggLocation", "(Lat/hannibal2/skyhanni/data/IslandType;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/NeuProfileDataLoadedEvent;", "onNeuProfileDataLoaded", "(Lat/hannibal2/skyhanni/events/NeuProfileDataLoadedEvent;)V", "", "locations", "loadApiCollectedEggs", "(Ljava/util/Map;)V", "toggleDebug", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "", "getCollectedEggStorage", "()Ljava/util/Map;", "collectedEggStorage", "", "apiEggLocations", "Ljava/util/Map;", "getApiEggLocations", "setApiEggLocations", "getIslandLocations", "()Ljava/util/Set;", "islandLocations", "getIslandCollectedLocations", "islandCollectedLocations", "loadedNeuThisProfile", "Z", "showEggLocationsDebug", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nHoppityEggLocations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoppityEggLocations.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocations\n+ 2 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 3 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 4 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n13#2,7:157\n21#2,6:174\n167#3,5:164\n172#3,4:170\n24#4:169\n2341#5,14:180\n1611#5,9:201\n1863#5:210\n1864#5:212\n1620#5:213\n1863#5,2:215\n381#6,7:194\n1#7:211\n1#7:214\n*S KotlinDebug\n*F\n+ 1 HoppityEggLocations.kt\nat/hannibal2/skyhanni/features/event/hoppity/HoppityEggLocations\n*L\n49#1:157,7\n49#1:174,6\n49#1:164,5\n49#1:170,4\n49#1:169\n54#1:180,14\n92#1:201,9\n92#1:210\n92#1:212\n92#1:213\n117#1:215,2\n69#1:194,7\n92#1:211\n*E\n"})
public final class HoppityEggLocations {
    @NotNull
    public static final HoppityEggLocations INSTANCE = new HoppityEggLocations();
    @NotNull
    private static Map<IslandType, ? extends Map<String, LorenzVec>> apiEggLocations = MapsKt.emptyMap();
    private static boolean loadedNeuThisProfile;
    private static boolean showEggLocationsDebug;

    private HoppityEggLocations() {
    }

    private final Map<IslandType, Set<LorenzVec>> getCollectedEggStorage() {
        Object object = CFApi.INSTANCE.getProfileStorage();
        if (object == null || (object = ((ProfileSpecificStorage.CFStorage)object).getCollectedEggLocations()) == null) {
            object = new LinkedHashMap();
        }
        return object;
    }

    @NotNull
    public final Map<IslandType, Map<String, LorenzVec>> getApiEggLocations() {
        return apiEggLocations;
    }

    public final void setApiEggLocations(@NotNull Map<IslandType, ? extends Map<String, LorenzVec>> map2) {
        Intrinsics.checkNotNullParameter(map2, "<set-?>");
        apiEggLocations = map2;
    }

    @NotNull
    public final Set<LorenzVec> getIslandLocations() {
        Set<LorenzVec> set;
        Map<String, LorenzVec> map2 = apiEggLocations.get((Object)SkyBlockUtils.INSTANCE.getCurrentIsland());
        if ((map2 != null && (map2 = map2.values()) != null ? CollectionsKt.toSet((Iterable)((Object)map2)) : (set = null)) == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<LorenzVec> getIslandCollectedLocations() {
        Set<LorenzVec> set = this.getCollectedEggStorage().get((Object)SkyBlockUtils.INSTANCE.getCurrentIsland());
        Set<LorenzVec> set2 = set != null ? CollectionsKt.toSet((Iterable)set) : null;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        return set2;
    }

    @NotNull
    public final Set<LorenzVec> getEggsIn(@NotNull IslandType islandType) {
        Intrinsics.checkNotNullParameter((Object)islandType, "islandType");
        Set<LorenzVec> set = this.getCollectedEggStorage().get((Object)islandType);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    public final boolean hasCollectedEgg(@NotNull LorenzVec location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.getIslandCollectedLocations().contains(location);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event2) {
        Object object;
        Intrinsics.checkNotNullParameter(event2, "event");
        String constant$iv = "HoppityEggLocations";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event2).getGson();
        boolean $i$f$getConstant = false;
        Object object2 = event2;
        try {
            Object $this$getRepoData_u24lambda_u2414$iv$iv;
            void this_$iv$iv;
            AbstractRepoReloadEvent $this$getConstant_u24lambda_u242$iv = object2;
            boolean bl = false;
            AbstractRepoManager<?> abstractRepoManager = $this$getConstant_u24lambda_u242$iv.getManager();
            String directory$iv$iv = "constants";
            boolean $i$f$getRepoData = false;
            Object object3 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object3;
                boolean bl2 = false;
                String path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                JsonElement json$iv$iv = jsonElement;
                Gson $this$fromJson$iv$iv$iv = gson$iv;
                boolean $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType(Reflection.typeOf(HoppityEggLocationsJson.class)));
                Intrinsics.checkNotNullExpressionValue(object4, "fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(object4);
            }
            catch (Throwable bl2) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object3 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl(object3);
            if (throwable != null) {
                Throwable e$iv$iv = throwable;
                boolean bl3 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + '\'', e$iv$iv);
                throw new KotlinNothingValueException();
            }
            Object constantData$iv = object3;
            $this$getConstant_u24lambda_u242$iv.getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable bl) {
            object2 = Result.constructor-impl(ResultKt.createFailure(bl));
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl4 = false;
                ((AbstractRepoReloadEvent)event2).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event2).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + '\'', it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        HoppityEggLocationsJson data2 = (HoppityEggLocationsJson)object;
        apiEggLocations = data2.getApiEggLocations();
    }

    public final void saveNearestEgg() {
        Object v0;
        Iterable $this$minByOrNull$iv = this.getIslandLocations();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                LorenzVec it = (LorenzVec)minElem$iv;
                boolean bl = false;
                double minValue$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it);
                do {
                    Object e$iv = iterator$iv.next();
                    LorenzVec it2 = (LorenzVec)e$iv;
                    $i$a$-minByOrNull-HoppityEggLocations$saveNearestEgg$location$1 = false;
                    double v$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it2);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        LorenzVec lorenzVec = v0;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec location = lorenzVec;
        if (LocationUtils.INSTANCE.distanceSqToPlayer(location) > 100.0) {
            Pair[] pairArray = new Pair[]{TuplesKt.to("island", SkyBlockUtils.INSTANCE.getCurrentIsland()), TuplesKt.to("distanceSqToPlayer", LocationUtils.INSTANCE.distanceSqToPlayer(location)), TuplesKt.to("playerLocation", LocationUtils.INSTANCE.playerLocation()), TuplesKt.to("closestKnownEgg", location)};
            ErrorManager.INSTANCE.skyHanniError("Player far from any known egg location!", pairArray);
            throw new KotlinNothingValueException();
        }
        this.saveEggLocation(SkyBlockUtils.INSTANCE.getCurrentIsland(), location);
    }

    private final void saveEggLocation(IslandType island, LorenzVec location) {
        Set set;
        Map<IslandType, Set<LorenzVec>> $this$getOrPut$iv = this.getCollectedEggStorage();
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get((Object)island);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(island, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        Set locations = set;
        ((Collection)locations).add(location);
    }

    @HandleEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        loadedNeuThisProfile = false;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onNeuProfileDataLoaded(@NotNull NeuProfileDataLoadedEvent event2) {
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(event2, "event");
        if (loadedNeuThisProfile || !HoppityEggsManager.INSTANCE.getConfig().getWaypoints().getLoadFromNeuPv()) {
            return;
        }
        Object object = event2.getCurrentPlayerData();
        if (object == null || (object = ((HypixelApiPlayer)object).getEvents()) == null || (object = ((HypixelApiEvents)object).getEaster()) == null || (object = ((HypixelApiEasterEvent)object).getRabbits()) == null || (object = ((HypixelApiRabbits)object).getCollectedLocations()) == null) {
            return;
        }
        Map<String, List<String>> rawLocations = object;
        loadedNeuThisProfile = true;
        List apiCollectedLocations = CollectionsKt.flatten((Iterable)rawLocations.values());
        Map collectedEggsApiData = new LinkedHashMap();
        for (Map.Entry<IslandType, ? extends Map<String, LorenzVec>> object3 : apiEggLocations.entrySet()) {
            void $this$mapNotNullTo$iv$iv;
            IslandType island = object3.getKey();
            Map<String, LorenzVec> locationNameToCoords = object3.getValue();
            $this$mapNotNull$iv = apiCollectedLocations;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                LorenzVec it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if ((LorenzVec)locationNameToCoords.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List coords = (List)destination$iv$iv;
            collectedEggsApiData.put(island, CollectionsKt.toMutableSet(coords));
        }
        Iterable iterable = this.getCollectedEggStorage().values();
        int island = 0;
        for (Object e : iterable) {
            void it;
            $this$mapNotNull$iv = (Set)e;
            int n = island;
            boolean bl = false;
            int n2 = it.size();
            island = n + n2;
        }
        int storedEggLocationCount = island;
        int n = apiCollectedLocations.size() - storedEggLocationCount;
        if (n <= 0) {
            return;
        }
        String locationStr = StringUtils.pluralize$default(StringUtils.INSTANCE, n, "location", "locations", false, 8, null);
        String message = PlatformUtils.INSTANCE.getIS_LEGACY() ? "Click here to load " + n + " more collected egg " + locationStr + " from NEU PV!" : "Click here to load " + n + " more collected egg " + locationStr + " from SkyBlock Profile Viewer!";
        ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, message, () -> HoppityEggLocations.onNeuProfileDataLoaded$lambda$4(collectedEggsApiData), null, 0L, false, null, true, false, 188, null);
    }

    private final void loadApiCollectedEggs(Map<IslandType, ? extends Set<LorenzVec>> locations) {
        for (Map.Entry<IslandType, ? extends Set<LorenzVec>> entry : locations.entrySet()) {
            IslandType island = entry.getKey();
            Set<LorenzVec> coordinates = entry.getValue();
            Iterable $this$forEach$iv = coordinates;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LorenzVec it = (LorenzVec)element$iv;
                boolean bl = false;
                INSTANCE.saveEggLocation(island, it);
            }
        }
    }

    private final void toggleDebug() {
        showEggLocationsDebug = !showEggLocationsDebug;
        String enabledDisabled = showEggLocationsDebug ? "\u00a7aEnabled" : "\u00a7cDisabled";
        ChatUtils.chat$default(ChatUtils.INSTANCE, enabledDisabled + " hoppity egg location debug viewer.", false, null, false, false, null, 62, null);
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!showEggLocationsDebug) {
            return;
        }
        Map<String, LorenzVec> map2 = apiEggLocations.get((Object)SkyBlockUtils.INSTANCE.getCurrentIsland());
        if (map2 == null) {
            return;
        }
        Map<String, LorenzVec> apiLocations = map2;
        Set<LorenzVec> collectedLocations = this.getIslandCollectedLocations();
        for (Map.Entry<String, LorenzVec> entry : apiLocations.entrySet()) {
            String name2 = entry.getKey();
            LorenzVec location = entry.getValue();
            boolean isCollected = collectedLocations.contains(location);
            ChromaColour color = isCollected ? LorenzColor.toChromaColor$default(LorenzColor.GREEN, 0, 0, 3, null) : LorenzColor.toChromaColor$default(LorenzColor.RED, 0, 0, 3, null);
            WorldRenderUtils.drawColor$default(WorldRenderUtils.INSTANCE, event2, location, color, false, 0.5f, false, 16, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, location.up(0.5), "\u00a7a" + name2, 1.2, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            if (!(LocationUtils.INSTANCE.distanceSqToPlayer(location) < 100.0)) continue;
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, location.up(0.5), LorenzVec.toCleanString$default(location, null, 1, null), 1.0, 12.0f, 0.0, 0.0, false, false, null, 496, null);
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        event2.register("shtoggleegglocationdebug", HoppityEggLocations::onCommandRegistration$lambda$7);
    }

    private static final Unit onNeuProfileDataLoaded$lambda$4(Map $collectedEggsApiData) {
        Intrinsics.checkNotNullParameter($collectedEggsApiData, "$collectedEggsApiData");
        INSTANCE.loadApiCollectedEggs($collectedEggsApiData);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Updated Hoppity egg location data!", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$7$lambda$6(String[] it) {
        Intrinsics.checkNotNullParameter(it, "it");
        INSTANCE.toggleDebug();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$7(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        $this$register.setDescription("Shows Hoppity egg locations with their internal API names and status.");
        $this$register.setCategory(CommandCategory.DEVELOPER_TEST);
        $this$register.callback(HoppityEggLocations::onCommandRegistration$lambda$7$lambda$6);
        return Unit.INSTANCE;
    }
}

