/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing.trophy;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.fishing.trophyfishing.GeyserFishingConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumParticleTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\bJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lat/hannibal2/skyhanni/features/fishing/trophy/GeyserFishing;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "event", "", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "hideGeyserParticles", "", "shouldProcessParticles", "()Z", "Lat/hannibal2/skyhanni/config/features/fishing/trophyfishing/GeyserFishingConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/trophyfishing/GeyserFishingConfig;", "config", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "geyserOffset", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "geyser", "Lnet/minecraft/util/AxisAlignedBB;", "geyserBox", "Lnet/minecraft/util/AxisAlignedBB;", "1.8.9"})
public final class GeyserFishing {
    @NotNull
    public static final GeyserFishing INSTANCE = new GeyserFishing();
    @NotNull
    private static final LorenzVec geyserOffset = new LorenzVec(0.1f, 0.6f, 0.1f);
    @Nullable
    private static LorenzVec geyser;
    @Nullable
    private static AxisAlignedBB geyserBox;

    private GeyserFishing() {
    }

    private final GeyserFishingConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getTrophyFishing().getGeyserOptions();
    }

    @HandleEvent(priority=1, receiveCancelled=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.shouldProcessParticles()) {
            return;
        }
        ReceiveParticleEvent $this$onReceiveParticle_u24lambda_u240 = event2;
        boolean bl = false;
        if ($this$onReceiveParticle_u24lambda_u240.getType() != EnumParticleTypes.CLOUD || $this$onReceiveParticle_u24lambda_u240.getCount() != 15 || !($this$onReceiveParticle_u24lambda_u240.getSpeed() == 0.05f) || !Intrinsics.areEqual($this$onReceiveParticle_u24lambda_u240.getOffset(), geyserOffset)) {
            return;
        }
        LorenzVec lorenzVec = geyser = event2.getLocation();
        if (lorenzVec == null) {
            return;
        }
        LorenzVec potentialGeyser = lorenzVec;
        geyserBox = new AxisAlignedBB(potentialGeyser.getX() - (double)2, 117.9, potentialGeyser.getZ() - (double)2, potentialGeyser.getX() + (double)2, 117.91, potentialGeyser.getZ() + (double)2);
        if (this.getConfig().getHideParticles() && FishingApi.INSTANCE.getBobber() != null) {
            this.hideGeyserParticles(event2);
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        geyser = null;
        geyserBox = null;
    }

    @HandleEvent(onlyOnIsland=IslandType.CRIMSON_ISLE)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.getConfig().getDrawBox()) {
            return;
        }
        AxisAlignedBB axisAlignedBB = geyserBox;
        if (axisAlignedBB == null) {
            return;
        }
        AxisAlignedBB geyserBox = axisAlignedBB;
        LorenzVec lorenzVec = geyser;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec geyser = lorenzVec;
        if (LocationUtils.INSTANCE.distanceToPlayerIgnoreY(geyser) > 96.0) {
            return;
        }
        if (this.getConfig().getOnlyWithRod() && !FishingApi.INSTANCE.getHoldingLavaRod()) {
            return;
        }
        ChromaColour color = this.getConfig().getBoxColor();
        WorldRenderUtils.drawFilledBoundingBox$default(WorldRenderUtils.INSTANCE, event2, geyserBox, color, 0.0f, false, false, 28, null);
    }

    private final void hideGeyserParticles(ReceiveParticleEvent event2) {
        EntityFishHook entityFishHook = FishingApi.INSTANCE.getBobber();
        if (entityFishHook == null) {
            return;
        }
        EntityFishHook bobber = entityFishHook;
        LorenzVec lorenzVec = geyser;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec geyser = lorenzVec;
        if (LocationUtils.INSTANCE.distanceTo((Entity)bobber, event2.getLocation()) < 3.0 && LocationUtils.INSTANCE.distanceTo((Entity)bobber, geyser) < 3.0) {
            event2.cancel();
        }
    }

    private final boolean shouldProcessParticles() {
        return IslandType.CRIMSON_ISLE.isCurrent() && Intrinsics.areEqual(SkyBlockUtils.INSTANCE.getGraphArea(), "Blazing Volcano") && (this.getConfig().getHideParticles() || this.getConfig().getDrawBox());
    }
}

