/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.gui.quiver;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.combat.QuiverConfig;
import at.hannibal2.skyhanni.data.ArrowType;
import at.hannibal2.skyhanni.data.QuiverApi;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.QuiverUpdateEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonCompleteEvent;
import at.hannibal2.skyhanni.events.kuudra.KuudraCompleteEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonApi;
import at.hannibal2.skyhanni.features.nether.kuudra.KuudraApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzRarity;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001d\u0010\t\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u000f\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001d\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00070!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lat/hannibal2/skyhanni/features/gui/quiver/QuiverWarning;", "", "<init>", "()V", "", "onInstanceComplete", "", "Lat/hannibal2/skyhanni/data/ArrowType;", "arrows", "instanceAlert", "(Ljava/util/Set;)V", "", "amount", "lowQuiverAlert", "(I)V", "Lat/hannibal2/skyhanni/events/QuiverUpdateEvent;", "event", "onQuiverUpdate", "(Lat/hannibal2/skyhanni/events/QuiverUpdateEvent;)V", "onWorldChange", "", "inInstance", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/combat/QuiverConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/QuiverConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastLowQuiverReminder", "J", "", "arrowsInInstance", "Ljava/util/Set;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nQuiverWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuiverWarning.kt\nat/hannibal2/skyhanni/features/gui/quiver/QuiverWarning\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n865#2,2:88\n1557#2:90\n1628#2,3:91\n*S KotlinDebug\n*F\n+ 1 QuiverWarning.kt\nat/hannibal2/skyhanni/features/gui/quiver/QuiverWarning\n*L\n36#1:88,2\n47#1:90\n47#1:91,3\n*E\n"})
public final class QuiverWarning {
    @NotNull
    public static final QuiverWarning INSTANCE = new QuiverWarning();
    private static long lastLowQuiverReminder = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final Set<ArrowType> arrowsInInstance = new LinkedHashSet();

    private QuiverWarning() {
    }

    private final QuiverConfig getConfig() {
        return SkyHanniMod.feature.getCombat().getQuiverConfig();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(eventTypes={DungeonCompleteEvent.class, KuudraCompleteEvent.class})
    public final void onInstanceComplete() {
        void var3_2;
        void $this$filterTo$iv;
        Iterable iterable = arrowsInInstance;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            ArrowType it = (ArrowType)element$iv;
            boolean bl = false;
            if (!(QuiverApi.INSTANCE.getAmount(it) <= INSTANCE.getConfig().getLowQuiverAmount())) continue;
            destination$iv.add(element$iv);
        }
        Set arrows = (Set)var3_2;
        arrowsInInstance.clear();
        if (!((Collection)arrows).isEmpty() && this.getConfig().getReminderAfterRun()) {
            DelayedRun.INSTANCE.runNextTick(() -> QuiverWarning.onInstanceComplete$lambda$1(arrows));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void instanceAlert(Set<ArrowType> arrows) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = arrows;
        StringUtils stringUtils = StringUtils.INSTANCE;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void arrowType;
            ArrowType arrowType2 = (ArrowType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = NeuItems.INSTANCE.getItemStackOrNull(arrowType.getInternalName());
            if (object == null || (object = ItemUtils.INSTANCE.getItemRarityOrNull((ItemStack)object)) == null || (object = ((LorenzRarity)((Object)object)).getChatColorCode()) == null) {
                object = "\u00a7f";
            }
            Object rarity = object;
            collection.add((String)rarity + arrowType.getArrow());
        }
        String arrowsText = StringUtils.createCommaSeparatedList$default(stringUtils, (List)destination$iv$iv, null, 1, null);
        TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7cLow on arrows!", null, 0L, null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16382, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Low on " + arrowsText + '!', false, null, false, false, null, 62, null);
        SoundUtils.INSTANCE.repeatSound(100L, 30, SoundUtils.INSTANCE.getPlingSound());
    }

    private final void lowQuiverAlert(int amount) {
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastLowQuiverReminder), DurationKt.toDuration(30, DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastLowQuiverReminder = SimpleTimeMark.Companion.now-uFjCsEo();
        TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7cLow on arrows!", null, 0L, null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16382, null);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Low on arrows \u00a7e(" + NumberUtil.INSTANCE.addSeparators(amount) + " left)", false, null, false, false, null, 62, null);
    }

    @HandleEvent
    public final void onQuiverUpdate(@NotNull QuiverUpdateEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        int amount = event2.getCurrentAmount();
        ArrowType arrowType = event2.getCurrentArrow();
        if (arrowType == null) {
            return;
        }
        ArrowType arrow = arrowType;
        if (Intrinsics.areEqual(arrow, QuiverApi.INSTANCE.getNONE_ARROW_TYPE())) {
            return;
        }
        if (this.inInstance()) {
            arrowsInInstance.add(arrow);
        }
        if (amount > this.getConfig().getLowQuiverAmount()) {
            return;
        }
        if (this.getConfig().getLowQuiverNotification()) {
            this.lowQuiverAlert(amount);
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        arrowsInInstance.clear();
    }

    private final boolean inInstance() {
        return DungeonApi.INSTANCE.inDungeon() || KuudraApi.INSTANCE.getInKuudra();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 35, "inventory.quiverAlert", "combat.quiverConfig.lowQuiverNotification", null, 8, null);
    }

    private static final Unit onInstanceComplete$lambda$1(Set $arrows) {
        Intrinsics.checkNotNullParameter($arrows, "$arrows");
        INSTANCE.instanceAlert($arrows);
        return Unit.INSTANCE;
    }
}

