/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.enoughupdates.EnoughUpdatesManager;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.api.storage.StorageApi;
import at.hannibal2.skyhanni.api.storage.StorageApiKt;
import at.hannibal2.skyhanni.api.storage.StorageSearchConsumer;
import at.hannibal2.skyhanni.api.storage.StorageSearchConsumerKt;
import at.hannibal2.skyhanni.api.storage.StorageSearchResult;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArgument;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArguments;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierUtils;
import at.hannibal2.skyhanni.features.inventory.storage.ItemTagManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0006\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u0017\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0012J\u0017\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0012J\u0017\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0012J\u0017\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0012J\u0017\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0012J\u000f\u0010\u001c\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u0017\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0007R\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001c\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lat/hannibal2/skyhanni/features/inventory/SearchItem;", "", "<init>", "()V", "", "text", "clean", "(Ljava/lang/String;)Ljava/lang/String;", "", "collectItemIds", "()Ljava/util/Set;", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "", "commandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "tag", "tagCurrentItem", "(Ljava/lang/String;)V", "removeTagFromCurrentItem", "searchByTag", "query", "searchByDisplayName", "searchByDescription", "id", "searchByItemId", "raw", "searchByUuidString", "listAllTags", "uuid", "formatDashedUuid", "Lkotlin/text/Regex;", "formattingCodeRegex", "Lkotlin/text/Regex;", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "nameSuggestionProvider", "Lcom/mojang/brigadier/suggestion/SuggestionProvider;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nSearchItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchItem.kt\nat/hannibal2/skyhanni/features/inventory/SearchItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 BrigadierBuilder.kt\nat/hannibal2/skyhanni/config/commands/brigadier/BrigadierBuilder\n*L\n1#1,284:1\n1#2:285\n216#3,2:286\n168#4,9:288\n168#4,9:297\n168#4,9:306\n162#4,15:315\n168#4,9:330\n168#4,9:339\n162#4,15:348\n*S KotlinDebug\n*F\n+ 1 SearchItem.kt\nat/hannibal2/skyhanni/features/inventory/SearchItem\n*L\n263#1:286,2\n56#1:288,9\n72#1:297,9\n83#1:306,9\n95#1:315,15\n107#1:330,9\n119#1:339,9\n133#1:348,15\n*E\n"})
public final class SearchItem {
    @NotNull
    public static final SearchItem INSTANCE = new SearchItem();
    @NotNull
    private static final Regex formattingCodeRegex = new Regex("\u00a7.");
    @NotNull
    private static final SuggestionProvider<Object> nameSuggestionProvider = SearchItem::nameSuggestionProvider$lambda$2;

    private SearchItem() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String clean(String text) {
        if (text == null) return "";
        String it = text;
        boolean bl = false;
        String string = formattingCodeRegex.replace((CharSequence)it, "");
        if (string == null) return "";
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string3 = string2;
        if (string2 != null) return string3;
        return "";
    }

    private final Set<String> collectItemIds() {
        return EnoughUpdatesManager.INSTANCE.getAllSkyblockItemIds();
    }

    @HandleEvent
    public final void commandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        event2.registerBrigadier("shtagitem", SearchItem::commandRegistration$lambda$6);
        event2.registerBrigadier("searchitem", SearchItem::commandRegistration$lambda$27);
        event2.registerBrigadier("removeitemtag", SearchItem::commandRegistration$lambda$29);
        event2.registerBrigadier("listitemtags", SearchItem::commandRegistration$lambda$31);
    }

    private final void tagCurrentItem(String tag) {
        String displayName;
        boolean success;
        ItemStack heldItem = InventoryUtils.INSTANCE.getItemInHand();
        if (heldItem == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "You must be holding an item to tag it!", false, 2, null);
            return;
        }
        NBTTagCompound extraAttributes = SkyBlockItemModifierUtils.INSTANCE.getExtraAttributes(heldItem);
        if (extraAttributes == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "This item doesn't have SkyBlock data!", false, 2, null);
            return;
        }
        String uuid = SkyBlockItemModifierUtils.INSTANCE.getItemUuid(heldItem);
        CharSequence charSequence = uuid;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "This item doesn't have a UUID! Only unique SkyBlock items can be tagged.", false, 2, null);
            return;
        }
        String string = heldItem.func_82833_r();
        if (string == null) {
            string = "Unknown Item";
        }
        if (success = ItemTagManager.INSTANCE.addTag(uuid, tag, displayName = string)) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aSuccessfully tagged \u00a7e" + displayName + " \u00a7awith \u00a7b" + tag, false, null, false, false, null, 62, null);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Use \u00a7e/searchitem tag " + tag + " \u00a77to find this item later!", false, null, false, false, null, 62, null);
        }
    }

    private final void removeTagFromCurrentItem() {
        ItemStack heldItem = InventoryUtils.INSTANCE.getItemInHand();
        if (heldItem == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "You must be holding an item to remove its tag!", false, 2, null);
            return;
        }
        String uuid = SkyBlockItemModifierUtils.INSTANCE.getItemUuid(heldItem);
        CharSequence charSequence = uuid;
        if (charSequence == null || StringsKt.isBlank(charSequence)) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "This item doesn't have a UUID!", false, 2, null);
            return;
        }
        ItemTagManager.INSTANCE.removeTag(uuid);
    }

    private final void searchByTag(String tag) {
        String uuid = ItemTagManager.INSTANCE.getUuidByTag(tag);
        if (uuid == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "No item found with tag: \u00a7b" + tag, false, 2, null);
            List<String> suggestions = ItemTagManager.INSTANCE.searchTags(tag);
            if (!((Collection)suggestions).isEmpty()) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Did you mean: \u00a7e" + CollectionsKt.joinToString$default(CollectionsKt.take((Iterable)suggestions, 5), "\u00a77, \u00a7e", null, null, 0, null, null, 62, null), false, null, false, false, null, 62, null);
            }
            return;
        }
        List<StorageSearchResult> results = StorageSearchConsumerKt.filterByUuid(StorageApi.INSTANCE.search(), StringUtils.INSTANCE.parseUUID(this.formatDashedUuid(uuid))).getResults();
        if (!((Collection)results).isEmpty()) {
            if (results.size() == 1) {
                CollectionsKt.first(results).runAccess(false);
            } else {
                StorageApiKt.outputToChat(results);
            }
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Tagged item \u00a7b" + tag + " \u00a77not found in storage", false, null, false, false, null, 62, null);
        }
    }

    private final void searchByDisplayName(String query) {
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Searching display names for: \u00a7e" + query, false, null, false, false, null, 62, null);
        String pattern = query;
        StorageApiKt.outputToChat(StorageApi.INSTANCE.searchByName(pattern, true));
    }

    private final void searchByDescription(String query) {
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Searching lore for regex: \u00a7e" + query, false, null, false, false, null, 62, null);
        StorageApiKt.outputToChat(StorageSearchConsumerKt.filterByDescription(StorageApi.INSTANCE.search(), query, true).getResults());
    }

    private final void searchByItemId(String id) {
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Searching by item id: \u00a7e" + id, false, null, false, false, null, 62, null);
        StorageSearchConsumer storageSearchConsumer = StorageApi.INSTANCE.search();
        String string = id.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
        StorageApiKt.outputToChat(StorageSearchConsumerKt.filterByItemId(storageSearchConsumer, string, true).getResults());
    }

    private final void searchByUuidString(String raw) {
        Object object;
        String dashed = this.formatDashedUuid(raw);
        Object object2 = this;
        try {
            SearchItem $this$searchByUuidString_u24lambda_u2432 = object2;
            boolean bl = false;
            object = Result.constructor-impl(UUID.fromString(dashed));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        UUID uuid = (UUID)(Result.isFailure-impl(object2) ? null : object2);
        if (uuid == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Invalid UUID: " + raw, false, 2, null);
            return;
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Searching for UUID: \u00a7e" + dashed, false, null, false, false, null, 62, null);
        StorageApiKt.outputToChat(StorageSearchConsumerKt.filterByUuid(StorageApi.INSTANCE.search(), uuid).getResults());
    }

    private final void listAllTags() {
        Map<String, String> allTaggedItems = ItemTagManager.INSTANCE.getAllTaggedItems();
        if (allTaggedItems.isEmpty()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77No tagged items found. Use \u00a7e/shtagitem <tag> \u00a77to tag items!", false, null, false, false, null, 62, null);
            return;
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aAll tagged items (" + allTaggedItems.size() + "):", false, null, false, false, null, 62, null);
        Map<String, String> $this$forEach$iv = allTaggedItems;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            String tag = entry.getKey();
            String uuid = entry.getValue();
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "\u00a7b" + tag + " \u00a77(UUID: " + StringsKt.take(INSTANCE.formatDashedUuid(uuid), 8) + "...)", () -> SearchItem.listAllTags$lambda$34$lambda$33(tag), "\u00a7eClick to search for this tag!", 0L, false, null, false, false, 248, null);
        }
    }

    private final String formatDashedUuid(String uuid) {
        String string = StringsKt.replace$default(uuid, "-", "", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String plain = string;
        if (plain.length() != 32) {
            return uuid;
        }
        String[] stringArray = new String[5];
        Intrinsics.checkNotNullExpressionValue(plain.substring(0, 8), "substring(...)");
        Intrinsics.checkNotNullExpressionValue(plain.substring(8, 12), "substring(...)");
        Intrinsics.checkNotNullExpressionValue(plain.substring(12, 16), "substring(...)");
        Intrinsics.checkNotNullExpressionValue(plain.substring(16, 20), "substring(...)");
        Intrinsics.checkNotNullExpressionValue(plain.substring(20, 32), "substring(...)");
        return CollectionsKt.joinToString$default(CollectionsKt.listOf(stringArray), "-", null, null, 0, null, null, 62, null);
    }

    private static final boolean nameSuggestionProvider$lambda$2$lambda$1(NeuInternalName neuInternalName) {
        Intrinsics.checkNotNullParameter(neuInternalName, "<unused var>");
        return true;
    }

    private static final CompletableFuture nameSuggestionProvider$lambda$2(CommandContext commandContext, SuggestionsBuilder builder) {
        String remaining = builder.getRemainingLowerCase();
        Intrinsics.checkNotNull(remaining);
        Set names = NeuItems.findItemNameWithoutNPCs$default(NeuItems.INSTANCE, remaining, SearchItem::nameSuggestionProvider$lambda$2$lambda$1, false, 4, null);
        for (String n : names) {
            builder.suggest(n);
        }
        return builder.buildFuture();
    }

    private static final Collection commandRegistration$lambda$6$lambda$3() {
        return ItemTagManager.INSTANCE.getAllTags();
    }

    private static final Unit commandRegistration$lambda$6$lambda$5() {
        ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /shtagitem <tag>", false, 2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commandRegistration$lambda$6(BaseBrigadierBuilder $this$registerBrigadier) {
        void argument$iv;
        void this_$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Tag the currently held item for later searching");
        BrigadierBuilder brigadierBuilder = $this$registerBrigadier;
        String string = "tag";
        ArgumentType argumentType = BrigadierArguments.INSTANCE.greedyString();
        SuggestionProvider<Object> suggestions$iv = BrigadierUtils.INSTANCE.dynamicSuggestionProvider(SearchItem::commandRegistration$lambda$6$lambda$3);
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void tagArg;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u246_u24lambda_u244 = $this$internalArg;
                    boolean bl = false;
                    $this$commandRegistration_u24lambda_u246_u24lambda_u244.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)tagArg){
                        final /* synthetic */ BrigadierArgument<String> $tagArg;
                        {
                            this.$tagArg = $tagArg;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            String tag = $this$callback.getArg(this.$tagArg);
                            Intrinsics.checkNotNull(tag);
                            if (StringsKt.isBlank(tag)) {
                                ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /shtagitem <tag>", false, 2, null);
                            } else {
                                SearchItem.access$tagCurrentItem(SearchItem.INSTANCE, tag);
                            }
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            this_$iv.literal(stringArray, (Function1<? super BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, (ArgumentType)argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void tagArg;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u246_u24lambda_u244 = $this$internalArg;
                            boolean bl = false;
                            $this$commandRegistration_u24lambda_u246_u24lambda_u244.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$registerBrigadier.simpleCallback(SearchItem::commandRegistration$lambda$6$lambda$5);
        return Unit.INSTANCE;
    }

    private static final Collection commandRegistration$lambda$27$lambda$10$lambda$7() {
        return ItemTagManager.INSTANCE.getAllTags();
    }

    private static final Unit commandRegistration$lambda$27$lambda$10$lambda$9() {
        ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /searchitem tag <tag>", false, 2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commandRegistration$lambda$27$lambda$10(BrigadierBuilder $this$literal) {
        void argument$iv;
        void this_$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        BrigadierBuilder brigadierBuilder = $this$literal;
        String string = "tag";
        ArgumentType argumentType = BrigadierArguments.INSTANCE.greedyString();
        SuggestionProvider<Object> suggestions$iv = BrigadierUtils.INSTANCE.dynamicSuggestionProvider(SearchItem::commandRegistration$lambda$27$lambda$10$lambda$7);
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void tagArg;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2410_u24lambda_u248 = $this$internalArg;
                    boolean bl = false;
                    $this$commandRegistration_u24lambda_u2427_u24lambda_u2410_u24lambda_u248.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)tagArg){
                        final /* synthetic */ BrigadierArgument<String> $tagArg;
                        {
                            this.$tagArg = $tagArg;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            SkyHanniMod.launchCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "SearchItem /searchitem tag", 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$callback, this.$tagArg, null){
                                int label;
                                final /* synthetic */ ArgContext $this_callback;
                                final /* synthetic */ BrigadierArgument<String> $tagArg;
                                {
                                    this.$this_callback = $this_callback;
                                    this.$tagArg = $tagArg;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            String string = this.$this_callback.getArg(this.$tagArg);
                                            Intrinsics.checkNotNullExpressionValue(string, "getArg(...)");
                                            SearchItem.access$searchByTag(SearchItem.INSTANCE, string);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 2, null);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            this_$iv.literal(stringArray, (Function1<? super BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, (ArgumentType)argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void tagArg;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2410_u24lambda_u248 = $this$internalArg;
                            boolean bl = false;
                            $this$commandRegistration_u24lambda_u2427_u24lambda_u2410_u24lambda_u248.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(SearchItem::commandRegistration$lambda$27$lambda$10$lambda$9);
        return Unit.INSTANCE;
    }

    private static final Unit commandRegistration$lambda$27$lambda$13$lambda$12() {
        ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /searchitem name <regex>", false, 2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commandRegistration$lambda$27$lambda$13(BrigadierBuilder $this$literal) {
        void argument$iv;
        void this_$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        BrigadierBuilder brigadierBuilder = $this$literal;
        String string = "pattern";
        ArgumentType argumentType = BrigadierArguments.INSTANCE.greedyString();
        SuggestionProvider<Object> suggestions$iv = nameSuggestionProvider;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void pat;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2413_u24lambda_u2411 = $this$internalArg;
                    boolean bl = false;
                    $this$commandRegistration_u24lambda_u2427_u24lambda_u2413_u24lambda_u2411.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)pat){
                        final /* synthetic */ BrigadierArgument<String> $pat;
                        {
                            this.$pat = $pat;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            SkyHanniMod.launchCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "SearchItem /searchitem name", 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$callback, this.$pat, null){
                                int label;
                                final /* synthetic */ ArgContext $this_callback;
                                final /* synthetic */ BrigadierArgument<String> $pat;
                                {
                                    this.$this_callback = $this_callback;
                                    this.$pat = $pat;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            String pattern = this.$this_callback.getArg(this.$pat);
                                            Intrinsics.checkNotNull(pattern);
                                            if (StringsKt.isBlank(pattern)) {
                                                ChatUtils.userError$default(ChatUtils.INSTANCE, "Empty pattern", false, 2, null);
                                            } else {
                                                SearchItem.access$searchByDisplayName(SearchItem.INSTANCE, pattern);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 2, null);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            this_$iv.literal(stringArray, (Function1<? super BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, (ArgumentType)argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void pat;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2413_u24lambda_u2411 = $this$internalArg;
                            boolean bl = false;
                            $this$commandRegistration_u24lambda_u2427_u24lambda_u2413_u24lambda_u2411.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(SearchItem::commandRegistration$lambda$27$lambda$13$lambda$12);
        return Unit.INSTANCE;
    }

    private static final Unit commandRegistration$lambda$27$lambda$16$lambda$15() {
        ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /searchitem desc <regex>", false, 2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commandRegistration$lambda$27$lambda$16(BrigadierBuilder $this$literal) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        String string = "pattern";
        ArgumentType argument$iv = BrigadierArguments.INSTANCE.greedyString();
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            $this$literal.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void pat;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2416_u24lambda_u2414 = $this$internalArg;
                    boolean bl = false;
                    $this$commandRegistration_u24lambda_u2427_u24lambda_u2416_u24lambda_u2414.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)pat){
                        final /* synthetic */ BrigadierArgument<String> $pat;
                        {
                            this.$pat = $pat;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            SkyHanniMod.launchCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "SearchItem /searchitem desc", 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$callback, this.$pat, null){
                                int label;
                                final /* synthetic */ ArgContext $this_callback;
                                final /* synthetic */ BrigadierArgument<String> $pat;
                                {
                                    this.$this_callback = $this_callback;
                                    this.$pat = $pat;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            String pattern = this.$this_callback.getArg(this.$pat);
                                            Intrinsics.checkNotNull(pattern);
                                            if (StringsKt.isBlank(pattern)) {
                                                ChatUtils.userError$default(ChatUtils.INSTANCE, "Empty pattern", false, 2, null);
                                            } else {
                                                SearchItem.access$searchByDescription(SearchItem.INSTANCE, pattern);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 2, null);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            $this$literal.literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void pat;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2416_u24lambda_u2414 = $this$internalArg;
                            boolean bl = false;
                            $this$commandRegistration_u24lambda_u2427_u24lambda_u2416_u24lambda_u2414.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(SearchItem::commandRegistration$lambda$27$lambda$16$lambda$15);
        return Unit.INSTANCE;
    }

    private static final Collection commandRegistration$lambda$27$lambda$20$lambda$17() {
        return INSTANCE.collectItemIds();
    }

    private static final Unit commandRegistration$lambda$27$lambda$20$lambda$19() {
        ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /searchitem id <ITEM_ID>", false, 2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commandRegistration$lambda$27$lambda$20(BrigadierBuilder $this$literal) {
        void argument$iv;
        void this_$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        BrigadierBuilder brigadierBuilder = $this$literal;
        String string = "id";
        ArgumentType argumentType = BrigadierArguments.INSTANCE.string();
        SuggestionProvider<Object> suggestions$iv = BrigadierUtils.INSTANCE.dynamicSuggestionProvider(SearchItem::commandRegistration$lambda$27$lambda$20$lambda$17);
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv.internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void idArg;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2420_u24lambda_u2418 = $this$internalArg;
                    boolean bl = false;
                    $this$commandRegistration_u24lambda_u2427_u24lambda_u2420_u24lambda_u2418.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)idArg){
                        final /* synthetic */ BrigadierArgument<String> $idArg;
                        {
                            this.$idArg = $idArg;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            SkyHanniMod.launchCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "SearchItem /searchitem id", 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$callback, this.$idArg, null){
                                int label;
                                final /* synthetic */ ArgContext $this_callback;
                                final /* synthetic */ BrigadierArgument<String> $idArg;
                                {
                                    this.$this_callback = $this_callback;
                                    this.$idArg = $idArg;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            String id = this.$this_callback.getArg(this.$idArg);
                                            Intrinsics.checkNotNull(id);
                                            if (StringsKt.isBlank(id)) {
                                                ChatUtils.userError$default(ChatUtils.INSTANCE, "Empty id", false, 2, null);
                                            } else {
                                                SearchItem.access$searchByItemId(SearchItem.INSTANCE, id);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 2, null);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            this_$iv.literal(stringArray, (Function1<? super BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, (ArgumentType)argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void idArg;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2420_u24lambda_u2418 = $this$internalArg;
                            boolean bl = false;
                            $this$commandRegistration_u24lambda_u2427_u24lambda_u2420_u24lambda_u2418.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(SearchItem::commandRegistration$lambda$27$lambda$20$lambda$19);
        return Unit.INSTANCE;
    }

    private static final Collection commandRegistration$lambda$27$lambda$24$lambda$21() {
        return ItemTagManager.INSTANCE.getAllTaggedItems().values();
    }

    private static final Unit commandRegistration$lambda$27$lambda$24$lambda$23() {
        ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /searchitem uuid <uuid>", false, 2, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commandRegistration$lambda$27$lambda$24(BrigadierBuilder $this$literal) {
        void suggestions$iv;
        void argument$iv;
        void this_$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
        BrigadierBuilder brigadierBuilder = $this$literal;
        String string = "uuid";
        ArgumentType argumentType = BrigadierArguments.INSTANCE.string();
        SuggestionProvider<Object> suggestionProvider = BrigadierUtils.INSTANCE.dynamicSuggestionProvider(SearchItem::commandRegistration$lambda$27$lambda$24$lambda$21);
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            this_$iv.internalArg((String)name$iv, argument$iv, (SuggestionProvider<Object>)suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void uuidArg;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2424_u24lambda_u2422 = $this$internalArg;
                    boolean bl = false;
                    $this$commandRegistration_u24lambda_u2427_u24lambda_u2424_u24lambda_u2422.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)uuidArg){
                        final /* synthetic */ BrigadierArgument<String> $uuidArg;
                        {
                            this.$uuidArg = $uuidArg;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            SkyHanniMod.launchCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "SearchItem /searchitem uuid", 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$callback, this.$uuidArg, null){
                                int label;
                                final /* synthetic */ ArgContext $this_callback;
                                final /* synthetic */ BrigadierArgument<String> $uuidArg;
                                {
                                    this.$this_callback = $this_callback;
                                    this.$uuidArg = $uuidArg;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            String string = this.$this_callback.getArg(this.$uuidArg);
                                            Intrinsics.checkNotNullExpressionValue(string, "getArg(...)");
                                            SearchItem.access$searchByUuidString(SearchItem.INSTANCE, string);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 2, null);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            this_$iv.literal(stringArray, (Function1<? super BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, (ArgumentType)argument$iv, (SuggestionProvider)suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void uuidArg;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2424_u24lambda_u2422 = $this$internalArg;
                            boolean bl = false;
                            $this$commandRegistration_u24lambda_u2427_u24lambda_u2424_u24lambda_u2422.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$literal.simpleCallback(SearchItem::commandRegistration$lambda$27$lambda$24$lambda$23);
        return Unit.INSTANCE;
    }

    private static final Unit commandRegistration$lambda$27$lambda$26() {
        if (!((Collection)StorageApi.INSTANCE.getToHighlightResults()).isEmpty()) {
            StorageApi.INSTANCE.getToHighlightResults().clear();
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Cleared last search", false, null, false, false, null, 62, null);
        } else {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /searchitem <tag|name|desc|id|uuid> <query>", false, 2, null);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit commandRegistration$lambda$27(BaseBrigadierBuilder $this$registerBrigadier) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Search storage (tag|name|desc|id|uuid)");
        Object object = new String[]{"tag"};
        $this$registerBrigadier.literal((String[])object, SearchItem::commandRegistration$lambda$27$lambda$10);
        object = new String[]{"name"};
        $this$registerBrigadier.literal((String[])object, SearchItem::commandRegistration$lambda$27$lambda$13);
        object = new String[]{"desc", "lore"};
        $this$registerBrigadier.literal((String[])object, SearchItem::commandRegistration$lambda$27$lambda$16);
        object = new String[]{"id"};
        $this$registerBrigadier.literal((String[])object, SearchItem::commandRegistration$lambda$27$lambda$20);
        object = new String[]{"uuid"};
        $this$registerBrigadier.literal((String[])object, SearchItem::commandRegistration$lambda$27$lambda$24);
        object = "fallback";
        ArgumentType argument$iv = BrigadierArguments.INSTANCE.greedyString();
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            ((BrigadierBuilder)$this$registerBrigadier).internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void fb;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2425 = $this$internalArg;
                    boolean bl = false;
                    $this$commandRegistration_u24lambda_u2427_u24lambda_u2425.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)fb){
                        final /* synthetic */ BrigadierArgument<String> $fb;
                        {
                            this.$fb = $fb;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            SkyHanniMod.launchCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "SearchItem /searchitem fallback", 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$callback, this.$fb, null){
                                int label;
                                final /* synthetic */ ArgContext $this_callback;
                                final /* synthetic */ BrigadierArgument<String> $fb;
                                {
                                    this.$this_callback = $this_callback;
                                    this.$fb = $fb;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            String maybeTag = this.$this_callback.getArg(this.$fb);
                                            Intrinsics.checkNotNull(maybeTag);
                                            if (StringsKt.isBlank(maybeTag)) {
                                                if (!((Collection)StorageApi.INSTANCE.getToHighlightResults()).isEmpty()) {
                                                    StorageApi.INSTANCE.getToHighlightResults().clear();
                                                    ChatUtils.chat$default(ChatUtils.INSTANCE, "Cleared last search", false, null, false, false, null, 62, null);
                                                } else {
                                                    ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /searchitem <tag|name|desc|id|uuid> <query>", false, 2, null);
                                                }
                                            } else {
                                                SearchItem.access$searchByTag(SearchItem.INSTANCE, maybeTag);
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 2, null);
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            ((BrigadierBuilder)$this$registerBrigadier).literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void fb;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$commandRegistration_u24lambda_u2427_u24lambda_u2425 = $this$internalArg;
                            boolean bl = false;
                            $this$commandRegistration_u24lambda_u2427_u24lambda_u2425.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$registerBrigadier.simpleCallback(SearchItem::commandRegistration$lambda$27$lambda$26);
        return Unit.INSTANCE;
    }

    private static final Unit commandRegistration$lambda$29$lambda$28() {
        INSTANCE.removeTagFromCurrentItem();
        return Unit.INSTANCE;
    }

    private static final Unit commandRegistration$lambda$29(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Remove tag from currently held item");
        $this$registerBrigadier.simpleCallback(SearchItem::commandRegistration$lambda$29$lambda$28);
        return Unit.INSTANCE;
    }

    private static final Unit commandRegistration$lambda$31$lambda$30() {
        INSTANCE.listAllTags();
        return Unit.INSTANCE;
    }

    private static final Unit commandRegistration$lambda$31(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("List all tagged items");
        $this$registerBrigadier.simpleCallback(SearchItem::commandRegistration$lambda$31$lambda$30);
        return Unit.INSTANCE;
    }

    private static final Unit listAllTags$lambda$34$lambda$33(String $tag) {
        Intrinsics.checkNotNullParameter($tag, "$tag");
        INSTANCE.searchByTag($tag);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$tagCurrentItem(SearchItem $this, String tag) {
        $this.tagCurrentItem(tag);
    }

    public static final /* synthetic */ void access$searchByTag(SearchItem $this, String tag) {
        $this.searchByTag(tag);
    }

    public static final /* synthetic */ void access$searchByDisplayName(SearchItem $this, String query) {
        $this.searchByDisplayName(query);
    }

    public static final /* synthetic */ void access$searchByDescription(SearchItem $this, String query) {
        $this.searchByDescription(query);
    }

    public static final /* synthetic */ void access$searchByItemId(SearchItem $this, String id) {
        $this.searchByItemId(id);
    }

    public static final /* synthetic */ void access$searchByUuidString(SearchItem $this, String raw) {
        $this.searchByUuidString(raw);
    }
}

