/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.craft;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.CraftableItemListConfig;
import at.hannibal2.skyhanni.data.SackApi;
import at.hannibal2.skyhanni.data.SackItem;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryOpenEvent;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemPriceUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.PrimitiveRecipe;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.SearchTextInput;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ7\u0010\u000f\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010JI\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00112\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0016\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\f\u001a\u00020\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u0013H\u0002\u00a2\u0006\u0004\b\f\u0010\u001eJ7\u0010!\u001a\u00020\u001c2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001c0\u00132\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'J\r\u0010)\u001a\u00020(\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010.\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001c\u00101\u001a\b\u0012\u0004\u0012\u0002000/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0016\u00103\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0014\u00106\u001a\u0002058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u001b\u0010=\u001a\u0002088BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\u00a8\u0006>"}, d2={"Lat/hannibal2/skyhanni/features/inventory/craft/CraftableItemList;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryOpenEvent;", "event", "", "onInventoryOpen", "(Lat/hannibal2/skyhanni/events/InventoryOpenEvent;)V", "", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "", "pricePer", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "lines", "loadItems", "(Ljava/util/Map;Ljava/util/Map;)V", "Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;", "recipe", "", "", "availableMaterial", "internalName", "createItemRenderable", "(Lat/hannibal2/skyhanni/utils/PrimitiveRecipe;Ljava/util/Map;Ljava/util/Map;Lat/hannibal2/skyhanni/utils/NeuInternalName;)Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onInventoryClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "", "neededItems", "(Ljava/util/Map;)D", "need", "available", "canCraftAmount", "(Ljava/util/Map;Ljava/util/Map;)I", "readItems", "()Ljava/util/Map;", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/CraftableItemListConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/CraftableItemListConfig;", "config", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "display", "Ljava/util/List;", "inInventory", "Z", "Lat/hannibal2/skyhanni/utils/renderables/SearchTextInput;", "textInput", "Lat/hannibal2/skyhanni/utils/renderables/SearchTextInput;", "Ljava/util/regex/Pattern;", "craftItemPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getCraftItemPattern", "()Ljava/util/regex/Pattern;", "craftItemPattern", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCraftableItemList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CraftableItemList.kt\nat/hannibal2/skyhanni/features/inventory/craft/CraftableItemList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,182:1\n1557#2:183\n1628#2,3:184\n126#3:187\n153#3,3:188\n*S KotlinDebug\n*F\n+ 1 CraftableItemList.kt\nat/hannibal2/skyhanni/features/inventory/craft/CraftableItemList\n*L\n72#1:183\n72#1:184,3\n141#1:187\n141#1:188,3\n*E\n"})
public final class CraftableItemList {
    @NotNull
    public static final CraftableItemList INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static List<? extends Renderable> display;
    private static boolean inInventory;
    @NotNull
    private static final SearchTextInput textInput;
    @NotNull
    private static final RepoPattern craftItemPattern$delegate;

    private CraftableItemList() {
    }

    private final CraftableItemListConfig getConfig() {
        return SkyHanniMod.feature.getInventory().getCraftableItemList();
    }

    private final Pattern getCraftItemPattern() {
        return (Pattern)craftItemPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onInventoryOpen(@NotNull InventoryOpenEvent event2) {
        List<Renderable> list;
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getCraftItemPattern(), event2.getInventoryName())) {
            return;
        }
        inInventory = true;
        Map pricePer = new LinkedHashMap();
        Map lines = new LinkedHashMap();
        this.loadItems(pricePer, lines);
        if (lines.isEmpty()) {
            String[] stringArray = new String[]{"\u00a77No items found in your Inventory", "or sacks that can be used as", "material in crafting recipes."};
            list = CollectionUtils.INSTANCE.toSingletonListOrEmpty(Renderable.Companion.hoverTips$default(Renderable.Companion, "\u00a77No Items to craft", CollectionsKt.listOf(stringArray), null, null, null, false, false, false, null, null, 1020, null));
        } else {
            void $this$mapTo$iv$iv;
            List<Renderable> list2;
            List<Renderable> $this$onInventoryOpen_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterable $this$map$iv = CollectionUtils.INSTANCE.sortedDesc(pricePer).keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NeuInternalName neuInternalName = (NeuInternalName)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Searchable searchable = (Searchable)lines.get(it);
                if (searchable == null) {
                    throw new IllegalStateException("impossible".toString());
                }
                collection.add(searchable);
            }
            List items = (List)destination$iv$iv;
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$onInventoryOpen_u24lambda_u241, "\u00a7e\u00a7lCraftable Items \u00a77(" + items.size() + ')', 0.0, null, null, 14, null);
            $this$onInventoryOpen_u24lambda_u241.add(SearchableKt.buildSearchableScrollable$default(items, 250, textInput, null, 20.0, 4, null));
            list = CollectionsKt.build(list2);
        }
        display = list;
    }

    private final void loadItems(Map<NeuInternalName, Double> pricePer, Map<NeuInternalName, Searchable> lines) {
        Map<NeuInternalName, Long> availableMaterial = this.readItems();
        for (NeuInternalName internalName2 : NeuItems.INSTANCE.getAllInternalNames().values()) {
            if (this.getConfig().getExcludeVanillaItems()) {
                Intrinsics.checkNotNull(internalName2);
                if (NeuItems.INSTANCE.isVanillaItem(internalName2)) continue;
            }
            Intrinsics.checkNotNull(internalName2);
            Set<PrimitiveRecipe> recipes = NeuItems.INSTANCE.getRecipes(internalName2);
            for (PrimitiveRecipe recipe : recipes) {
                Searchable renderable2;
                if (!recipe.isCraftingRecipe() || this.createItemRenderable(recipe, availableMaterial, pricePer, internalName2) == null) continue;
                lines.put(internalName2, renderable2);
            }
        }
    }

    private final Searchable createItemRenderable(PrimitiveRecipe recipe, Map<NeuInternalName, Long> availableMaterial, Map<NeuInternalName, Double> pricePer, NeuInternalName internalName2) {
        Map<NeuInternalName, Integer> neededItems = ItemUtils.INSTANCE.neededItems(recipe);
        if (neededItems.isEmpty()) {
            return null;
        }
        int canCraftAmount = this.canCraftAmount(neededItems, availableMaterial);
        if (canCraftAmount <= 0) {
            return null;
        }
        String amountFormat = NumberUtil.INSTANCE.addSeparators(canCraftAmount);
        double totalPrice = this.pricePer(neededItems);
        Double d = totalPrice;
        pricePer.put(internalName2, d);
        String itemName2 = ItemUtils.INSTANCE.getRepoItemName(internalName2);
        Object object = CollectionsKt.createListBuilder();
        List<String> $this$createItemRenderable_u24lambda_u242 = object;
        boolean bl = false;
        $this$createItemRenderable_u24lambda_u242.add(itemName2);
        $this$createItemRenderable_u24lambda_u242.add("");
        $this$createItemRenderable_u24lambda_u242.add("\u00a77Craft cost: \u00a76" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, totalPrice, false, 1, null));
        for (Map.Entry<NeuInternalName, Integer> entry : neededItems.entrySet()) {
            NeuInternalName item2 = entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            $this$createItemRenderable_u24lambda_u242.add(' ' + ItemPriceUtils.getPriceName$default(ItemPriceUtils.INSTANCE, item2, amount, 0.0, 2, null));
        }
        $this$createItemRenderable_u24lambda_u242.add("");
        $this$createItemRenderable_u24lambda_u242.add("\u00a77You have enough materials");
        String timeName = StringUtils.pluralize$default(StringUtils.INSTANCE, canCraftAmount, "time", "times", false, 8, null);
        $this$createItemRenderable_u24lambda_u242.add("\u00a77to craft this item \u00a7e" + amountFormat + " \u00a77" + timeName + '!');
        $this$createItemRenderable_u24lambda_u242.add("");
        $this$createItemRenderable_u24lambda_u242.add("\u00a7eClick to craft!");
        List tooltip = CollectionsKt.build(object);
        object = Renderable.Companion;
        String string = "\u00a78x" + amountFormat + ' ' + itemName2;
        return SearchableKt.toSearchable(Renderable.Companion.clickable$default((Renderable.Companion)object, string, () -> CraftableItemList.createItemRenderable$lambda$3(internalName2), false, null, tooltip, null, 44, null), itemName2);
    }

    @HandleEvent
    public final void onInventoryClose(@NotNull InventoryCloseEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        inInventory = false;
    }

    /*
     * WARNING - void declaration
     */
    private final double pricePer(Map<NeuInternalName, Integer> neededItems) {
        void $this$mapTo$iv$iv;
        Map<NeuInternalName, Integer> $this$map$iv = neededItems;
        boolean $i$f$map = false;
        Map<NeuInternalName, Integer> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ItemPriceUtils.getPrice$default(ItemPriceUtils.INSTANCE, (NeuInternalName)it.getKey(), null, null, 3, null) * ((Number)it.getValue()).doubleValue());
        }
        return CollectionsKt.sumOfDouble((List)destination$iv$iv);
    }

    private final int canCraftAmount(Map<NeuInternalName, Integer> need, Map<NeuInternalName, Long> available) {
        List canCraftTotal = new ArrayList();
        for (Map.Entry<NeuInternalName, Integer> entry : need.entrySet()) {
            NeuInternalName name2 = entry.getKey();
            int neededAmount = ((Number)entry.getValue()).intValue();
            Long l = available.get(name2);
            long having = l != null ? l : 0L;
            int canCraft = (int)Math.floor((double)having / (double)neededAmount);
            canCraftTotal.add(canCraft);
        }
        return ((Number)CollectionsKt.minOrThrow(canCraftTotal)).intValue();
    }

    private final Map<NeuInternalName, Long> readItems() {
        Map materials = new LinkedHashMap();
        for (ItemStack entry : InventoryUtils.INSTANCE.getItemsInOwnInventory()) {
            PrimitiveItemStack item2;
            if (PrimitiveItemStack.Companion.toPrimitiveStackOrNull(entry) == null) continue;
            CollectionUtils.INSTANCE.addOrPut(materials, item2.getInternalName(), (long)item2.getAmount());
        }
        if (this.getConfig().getIncludeSacks()) {
            for (Map.Entry entry : SackApi.INSTANCE.getSackData().entrySet()) {
                NeuInternalName internalName2 = (NeuInternalName)entry.getKey();
                SackItem item3 = (SackItem)entry.getValue();
                CollectionUtils.INSTANCE.addOrPut(materials, internalName2, (long)item3.getAmount());
            }
        }
        return materials;
    }

    @HandleEvent
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!inInventory) {
            return;
        }
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, this.getConfig().getPosition(), display, 0, "Craftable Item List", false, 10, null);
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getEnabled();
    }

    private static final Unit createItemRenderable$lambda$3(NeuInternalName $internalName) {
        Intrinsics.checkNotNullParameter($internalName, "$internalName");
        HypixelCommands.viewRecipe$default(HypixelCommands.INSTANCE, $internalName, 0, 2, null);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(CraftableItemList.class, "craftItemPattern", "getCraftItemPattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new CraftableItemList();
        display = CollectionsKt.emptyList();
        textInput = new SearchTextInput();
        craftItemPattern$delegate = RepoPattern.Companion.pattern("craftableitemlist.craftitem", "Craft Item");
    }
}

