/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.experimentationtable;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.ExperimentationTableApi;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.experimentationtable.ExperimentsDryStreakConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.experiments.TableRareUncoverEvent;
import at.hannibal2.skyhanni.events.experiments.TableTaskCompletedEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lat/hannibal2/skyhanni/features/inventory/experimentationtable/ExperimentsDryStreakDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;", "event", "", "onBackgroundDraw", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$ChestGuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/experiments/TableRareUncoverEvent;", "onTableRareUncover", "(Lat/hannibal2/skyhanni/events/experiments/TableRareUncoverEvent;)V", "Lat/hannibal2/skyhanni/events/experiments/TableTaskCompletedEvent;", "onTableTaskCompleted", "(Lat/hannibal2/skyhanni/events/experiments/TableTaskCompletedEvent;)V", "", "", "drawDisplay", "()Ljava/util/List;", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/inventory/experimentationtable/ExperimentsDryStreakConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/experimentationtable/ExperimentsDryStreakConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$ExperimentationStorage$ExperimentsDryStreakStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$ExperimentationStorage$ExperimentsDryStreakStorage;", "storage", "display", "Ljava/util/List;", "ignoreNextFinish", "Z", "1.8.9"})
public final class ExperimentsDryStreakDisplay {
    @NotNull
    public static final ExperimentsDryStreakDisplay INSTANCE = new ExperimentsDryStreakDisplay();
    @NotNull
    private static List<String> display = CollectionsKt.emptyList();
    private static boolean ignoreNextFinish;

    private ExperimentsDryStreakDisplay() {
    }

    private final ExperimentsDryStreakConfig getConfig() {
        return SkyHanniMod.feature.getInventory().getExperimentationTable().getDryStreak();
    }

    private final ProfileSpecificStorage.ExperimentationStorage.ExperimentsDryStreakStorage getStorage() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        return object != null && (object = ((ProfileSpecificStorage)object).getExperimentation()) != null ? ((ProfileSpecificStorage.ExperimentationStorage)object).getDryStreak() : null;
    }

    @HandleEvent(onlyOnIsland=IslandType.PRIVATE_ISLAND)
    public final void onBackgroundDraw(@NotNull GuiRenderEvent.ChestGuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled() || !ExperimentationTableApi.INSTANCE.getInTable()) {
            return;
        }
        List<String> list = (List<String>)CollectionUtils.INSTANCE.takeIfNotEmpty((Collection)display);
        if (list == null) {
            list = this.drawDisplay();
        }
        display = list;
        RenderUtils.renderStrings$default(RenderUtils.INSTANCE, this.getConfig().getPosition(), display, 0, "Experimentation Table Dry Streak", 2, null);
    }

    @HandleEvent(onlyOnIsland=IslandType.PRIVATE_ISLAND)
    public final void onTableRareUncover(@NotNull TableRareUncoverEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (!this.isEnabled()) {
            return;
        }
        ProfileSpecificStorage.ExperimentationStorage.ExperimentsDryStreakStorage experimentsDryStreakStorage = this.getStorage();
        if (experimentsDryStreakStorage == null) {
            return;
        }
        ProfileSpecificStorage.ExperimentationStorage.ExperimentsDryStreakStorage storage2 = experimentsDryStreakStorage;
        String attemptsFormat = StringUtils.INSTANCE.pluralize("attempt", storage2.getAttemptsSince());
        String finallyFormat = storage2.getAttemptsSince() >= 10 ? "\u00a7o(finally)\u00a7r\u00a7e " : "";
        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7a\u00a7lDRY-STREAK ENDED! \u00a7eYou have " + finallyFormat + "found an \u00a75ULTRA-RARE \u00a7eafter \u00a73" + NumberUtil.shortFormat$default(NumberUtil.INSTANCE, storage2.getXpSince(), false, 1, null) + " Enchanting Exp \u00a7eand \u00a72" + storage2.getAttemptsSince() + ' ' + attemptsFormat + "\u00a7e!", false, null, false, false, null, 62, null);
        storage2.setAttemptsSince(0);
        storage2.setXpSince(0L);
        display = this.drawDisplay();
        ignoreNextFinish = true;
    }

    @HandleEvent(onlyOnIsland=IslandType.PRIVATE_ISLAND)
    public final void onTableTaskCompleted(@NotNull TableTaskCompletedEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        if (ignoreNextFinish) {
            ignoreNextFinish = false;
            return;
        }
        ProfileSpecificStorage.ExperimentationStorage.ExperimentsDryStreakStorage experimentsDryStreakStorage = this.getStorage();
        if (experimentsDryStreakStorage == null) {
            return;
        }
        ProfileSpecificStorage.ExperimentationStorage.ExperimentsDryStreakStorage storage2 = experimentsDryStreakStorage;
        Long l = event2.getEnchantingXpGained();
        storage2.setXpSince(storage2.getXpSince() + (l != null ? l : 0L));
        if (event2.getType() == ExperimentationTableApi.ExperimentationTaskType.SUPERPAIRS) {
            int n = storage2.getAttemptsSince();
            storage2.setAttemptsSince(n + 1);
        }
        display = this.drawDisplay();
    }

    private final List<String> drawDisplay() {
        List<String> list;
        List<String> $this$drawDisplay_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (INSTANCE.isEnabled()) {
            ProfileSpecificStorage.ExperimentationStorage.ExperimentsDryStreakStorage experimentsDryStreakStorage = INSTANCE.getStorage();
            if (experimentsDryStreakStorage != null) {
                boolean bl2;
                ProfileSpecificStorage.ExperimentationStorage.ExperimentsDryStreakStorage storage2 = experimentsDryStreakStorage;
                $this$drawDisplay_u24lambda_u240.add("\u00a7cDry-Streak since last \u00a75ULTRA-RARE");
                int attemptsSince = storage2.getAttemptsSince();
                String xpSince = NumberUtil.shortFormat$default(NumberUtil.INSTANCE, storage2.getXpSince(), false, 1, null);
                String attemptFormat = StringUtils.INSTANCE.pluralize("Attempt", attemptsSince);
                if (INSTANCE.getConfig().getAttemptsSince() && INSTANCE.getConfig().getXpSince()) {
                    $this$drawDisplay_u24lambda_u240.add("\u00a7e \u251c " + attemptsSince + ' ' + attemptFormat);
                    bl2 = $this$drawDisplay_u24lambda_u240.add("\u00a7e \u2514 " + xpSince + " XP");
                } else {
                    bl2 = INSTANCE.getConfig().getAttemptsSince() ? $this$drawDisplay_u24lambda_u240.add("\u00a7e \u2514 " + attemptsSince + ' ' + attemptFormat) : $this$drawDisplay_u24lambda_u240.add("\u00a7e \u2514 " + xpSince + " XP");
                }
            }
        }
        return CollectionsKt.build(list);
    }

    private final boolean isEnabled() {
        return this.getConfig().getEnabled() && (this.getConfig().getXpSince() || this.getConfig().getAttemptsSince());
    }
}

