/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.storage;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.ConfigFileType;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.utils.ChatUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\fJ\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000eJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0003R \u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0015\u00a8\u0006\""}, d2={"Lat/hannibal2/skyhanni/features/inventory/storage/ItemTagManager;", "", "<init>", "()V", "", "uuid", "tag", "displayName", "", "addTag", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Z", "removeTag", "(Ljava/lang/String;)Z", "getUuidByTag", "(Ljava/lang/String;)Ljava/lang/String;", "getTagByUuid", "", "getAllTags", "()Ljava/util/Set;", "", "getAllTaggedItems", "()Ljava/util/Map;", "hasTag", "query", "", "searchTags", "(Ljava/lang/String;)Ljava/util/List;", "normalizeUuid", "normalizeTag", "", "saveData", "", "getTagToUuid", "tagToUuid", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nItemTagManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemTagManager.kt\nat/hannibal2/skyhanni/features/inventory/storage/ItemTagManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1#2:125\n774#3:126\n865#3,2:127\n*S KotlinDebug\n*F\n+ 1 ItemTagManager.kt\nat/hannibal2/skyhanni/features/inventory/storage/ItemTagManager\n*L\n107#1:126\n107#1:127,2\n*E\n"})
public final class ItemTagManager {
    @NotNull
    public static final ItemTagManager INSTANCE = new ItemTagManager();

    private ItemTagManager() {
    }

    private final Map<String, String> getTagToUuid() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        if (object == null || (object = ((ProfileSpecificStorage)object).getItemTags()) == null) {
            object = new LinkedHashMap();
        }
        return object;
    }

    public final boolean addTag(@NotNull String uuid, @NotNull String tag, @NotNull String displayName) {
        String existingTag;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        if (StringsKt.isBlank(uuid) || StringsKt.isBlank(tag)) {
            return false;
        }
        String normalizedUuid = this.normalizeUuid(uuid);
        String normalizedTag = this.normalizeTag(tag);
        String existingUuid = this.getTagToUuid().get(normalizedTag);
        if (existingUuid != null && !Intrinsics.areEqual(existingUuid, normalizedUuid)) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Tag \u00a7b" + normalizedTag + " \u00a77was moved from previous item to \u00a7e" + displayName, false, null, false, false, null, 62, null);
        }
        if ((existingTag = this.getTagByUuid(normalizedUuid)) != null && !Intrinsics.areEqual(existingTag, normalizedTag)) {
            this.getTagToUuid().remove(existingTag);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Removed previous tag \u00a7b" + existingTag + " \u00a77from this item", false, null, false, false, null, 62, null);
        }
        this.getTagToUuid().put(normalizedTag, normalizedUuid);
        this.saveData();
        return true;
    }

    public final boolean removeTag(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        String normalizedUuid = this.normalizeUuid(uuid);
        String existingTag = this.getTagByUuid(normalizedUuid);
        if (existingTag != null) {
            this.getTagToUuid().remove(existingTag);
            this.saveData();
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aRemoved tag \u00a7b" + existingTag, false, null, false, false, null, 62, null);
            return true;
        }
        ChatUtils.userError$default(ChatUtils.INSTANCE, "No tag found for this item", false, 2, null);
        return false;
    }

    @Nullable
    public final String getUuidByTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        String normalizedTag = this.normalizeTag(tag);
        return this.getTagToUuid().get(normalizedTag);
    }

    @Nullable
    public final String getTagByUuid(@NotNull String uuid) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(uuid, "uuid");
            String normalizedUuid = this.normalizeUuid(uuid);
            Iterable iterable = this.getTagToUuid().entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getValue(), normalizedUuid)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (String)entry.getKey() : null;
    }

    @NotNull
    public final Set<String> getAllTags() {
        return CollectionsKt.toSet((Iterable)this.getTagToUuid().keySet());
    }

    @NotNull
    public final Map<String, String> getAllTaggedItems() {
        return MapsKt.toMap(this.getTagToUuid());
    }

    public final boolean hasTag(@NotNull String uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        return this.getTagByUuid(uuid) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> searchTags(@NotNull String query) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(query, "query");
        String string = query.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String normalizedQuery = string;
        Iterable $this$filter$iv = this.getAllTags();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)string2, normalizedQuery, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String normalizeUuid(String uuid) {
        String string = StringsKt.replace$default(uuid, "-", "", false, 4, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return string;
    }

    private final String normalizeTag(String tag) {
        String string = tag.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return string;
    }

    private final void saveData() {
        SkyHanniMod.launchCoroutine-8Mi8wO0$default(SkyHanniMod.INSTANCE, "Save Item Tags", 0L, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        SkyHanniMod.INSTANCE.getConfigManager().saveConfig(ConfigFileType.STORAGE, "Updated item tags");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }
}

