/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.CollectionApi;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArgument;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierArguments;
import at.hannibal2.skyhanni.config.commands.brigadier.BrigadierBuilder;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.container.HorizontalContainerRenderable;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u000f\u0010\u0017\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u000f\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001b2\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001e\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u0003J\u000f\u0010\u001f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u000f\u0010 \u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b \u0010\u0003J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020$H\u0007\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00188\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0018\u0010*\u001a\u0004\u0018\u00010)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010.R\u0016\u00100\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00102\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00101R\u0016\u00103\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u0010(R\u0016\u00104\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u0010(R\u0016\u00105\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00101R\u0014\u00106\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u0010.R\u0014\u00107\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u0010.R\u0014\u00108\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u0010.R\u0014\u00109\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010.R\u0014\u0010:\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010.\u00a8\u0006;"}, d2={"Lat/hannibal2/skyhanni/features/misc/CollectionTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "", "args", "command", "([Ljava/lang/String;)V", "rawName", "fixTypo", "(Ljava/lang/String;)Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "internalName", "name", "setNewCollection", "(Lat/hannibal2/skyhanni/utils/NeuInternalName;Ljava/lang/String;)V", "resetData", "updateDisplay", "", "countCurrentlyInInventory", "()I", "", "handleTabComplete", "(Ljava/lang/String;)Ljava/util/List;", "onTick", "compareInventory", "updateGain", "amount", "gainItems", "(I)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "RECENT_GAIN_TIME", "I", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "display", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "itemName", "Ljava/lang/String;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "", "itemAmount", "J", "goalAmount", "lastAmountInInventory", "recentGain", "lastGainTime", "CACTUS", "CACTUS_GREEN", "YOUNGITE", "OBSOLITE", "TIMITE", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nCollectionTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionTracker.kt\nat/hannibal2/skyhanni/features/misc/CollectionTracker\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 BrigadierBuilder.kt\nat/hannibal2/skyhanni/config/commands/brigadier/BrigadierBuilder\n*L\n1#1,252:1\n37#2,2:253\n1611#3,9:255\n1863#3:264\n1864#3:266\n1620#3:267\n1557#3:268\n1628#3,3:269\n1#4:265\n162#5,15:272\n*S KotlinDebug\n*F\n+ 1 CollectionTracker.kt\nat/hannibal2/skyhanni/features/misc/CollectionTracker\n*L\n84#1:253,2\n203#1:255,9\n203#1:264\n203#1:266\n203#1:267\n204#1:268\n204#1:269,3\n203#1:265\n58#1:272,15\n*E\n"})
public final class CollectionTracker {
    @NotNull
    public static final CollectionTracker INSTANCE = new CollectionTracker();
    private static final int RECENT_GAIN_TIME = 1500;
    @Nullable
    private static Renderable display;
    @NotNull
    private static String itemName;
    @Nullable
    private static NeuInternalName internalName;
    private static long itemAmount;
    private static long goalAmount;
    private static int lastAmountInInventory;
    private static int recentGain;
    private static long lastGainTime;
    @NotNull
    private static final NeuInternalName CACTUS;
    @NotNull
    private static final NeuInternalName CACTUS_GREEN;
    @NotNull
    private static final NeuInternalName YOUNGITE;
    @NotNull
    private static final NeuInternalName OBSOLITE;
    @NotNull
    private static final NeuInternalName TIMITE;

    private CollectionTracker() {
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter(event2, "event");
        event2.registerBrigadier("shtrackcollection", CollectionTracker::onCommandRegistration$lambda$2);
    }

    private final void command(String[] args2) {
        Object[] objectArray;
        String lastArg = ArraysKt.last(args2);
        if (NumberUtil.INSTANCE.isFormatNumber(lastArg)) {
            long goal = NumberUtil.INSTANCE.formatLong(lastArg);
            if (goal <= 0L) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Invalid Amount for Goal.", false, null, false, false, null, 62, null);
                return;
            }
            goalAmount = goal;
            Collection $this$toTypedArray$iv = ArraysKt.dropLast(args2, 1);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new String[0]);
        } else {
            goalAmount = -1L;
            objectArray = args2;
        }
        Object[] nameArgs = objectArray;
        String string = ArraysKt.joinToString$default(nameArgs, (CharSequence)" ", null, null, 0, null, null, 62, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String rawName = this.fixTypo(StringsKt.replace$default(string, "_", " ", false, 4, null));
        if (Intrinsics.areEqual(rawName, "gemstone")) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Gemstone collection is not supported!", false, 2, null);
            return;
        }
        if (Intrinsics.areEqual(rawName, "mushroom")) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Mushroom collection is not supported!", false, 2, null);
            return;
        }
        NeuInternalName foundInternalName = NeuInternalName.Companion.fromItemNameOrNull(rawName);
        if (foundInternalName == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Item '" + rawName + "' does not exist!", false, 2, null);
            return;
        }
        ItemStack stack = NeuItems.INSTANCE.getItemStackOrNull(foundInternalName);
        if (stack == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Item '" + rawName + "' does not exist!", false, 2, null);
            return;
        }
        String string2 = stack.func_82833_r();
        Intrinsics.checkNotNullExpressionValue(string2, "getDisplayName(...)");
        this.setNewCollection(foundInternalName, StringUtils.removeColor$default(StringUtils.INSTANCE, string2, false, 1, null));
    }

    private final String fixTypo(String rawName) {
        String string;
        switch (rawName) {
            case "carrots": {
                string = "carrot";
                break;
            }
            case "melons": {
                string = "melon";
                break;
            }
            case "seed": {
                string = "seeds";
                break;
            }
            case "iron": {
                string = "iron ingot";
                break;
            }
            case "gold": {
                string = "gold ingot";
                break;
            }
            case "sugar": {
                string = "sugar cane";
                break;
            }
            case "cocoa": 
            case "cocoa bean": {
                string = "cocoa beans";
                break;
            }
            case "lapis": {
                string = "lapis lazuli";
                break;
            }
            case "cacti": {
                string = "cactus";
                break;
            }
            case "pumpkins": {
                string = "pumpkin";
                break;
            }
            case "potatoes": {
                string = "potato";
                break;
            }
            case "nether warts": 
            case "wart": 
            case "warts": {
                string = "nether wart";
                break;
            }
            case "stone": {
                string = "cobblestone";
                break;
            }
            case "mushrooms": 
            case "brown mushroom": 
            case "red mushroom": {
                string = "mushroom";
                break;
            }
            case "gemstones": {
                string = "gemstone";
                break;
            }
            case "caducous": {
                string = "caducous stem";
                break;
            }
            case "agaricus": {
                string = "agaricus cap";
                break;
            }
            case "quartz": {
                string = "nether quartz";
                break;
            }
            case "glowstone": {
                string = "glowstone dust";
                break;
            }
            default: {
                string = rawName;
            }
        }
        return string;
    }

    private final void setNewCollection(NeuInternalName internalName2, String name2) {
        Long foundAmount = CollectionApi.INSTANCE.getCollectionCounter(internalName2);
        if (foundAmount == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, name2 + " collection not found. Try to open the collection inventory!", false, 2, null);
            return;
        }
        internalName = internalName2;
        itemName = name2;
        itemAmount = foundAmount;
        lastAmountInInventory = this.countCurrentlyInInventory();
        this.updateDisplay();
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Started tracking " + itemName + " \u00a7ecollection.", false, null, false, false, null, 62, null);
    }

    private final void resetData() {
        itemAmount = -1L;
        goalAmount = -1L;
        internalName = null;
        lastAmountInInventory = -1;
        display = null;
        recentGain = 0;
    }

    private final void updateDisplay() {
        String format = NumberUtil.INSTANCE.addSeparators(itemAmount);
        Ref.ObjectRef gainText = new Ref.ObjectRef();
        gainText.element = "";
        if (recentGain != 0) {
            gainText.element = "\u00a7a+" + NumberUtil.INSTANCE.addSeparators(recentGain);
        }
        if (goalAmount != -1L && itemAmount >= goalAmount) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Collection goal of \u00a7a" + NumberUtil.INSTANCE.addSeparators(goalAmount) + " reached!", false, null, false, false, null, 62, null);
            goalAmount = -1L;
        }
        String goal = goalAmount == -1L ? "" : " \u00a7f/ \u00a7b" + NumberUtil.INSTANCE.addSeparators(goalAmount) + " \u00a7f(\u00a7a" + NumberUtil.INSTANCE.percentWithColorCode(itemAmount, goalAmount, 1) + "\u00a7f)";
        display = HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, 0, null, null, arg_0 -> CollectionTracker.updateDisplay$lambda$4(format, goal, gainText, arg_0), 7, null);
    }

    private final int countCurrentlyInInventory() {
        return InventoryUtils.INSTANCE.countItemsInLowerInventory(CollectionTracker::countCurrentlyInInventory$lambda$5);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<String> handleTabComplete(@NotNull String command2) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(command2, "command");
        if (!Intrinsics.areEqual(command2, "shtrackcollection")) {
            return null;
        }
        Iterable $this$mapNotNull$iv = CollectionApi.INSTANCE.getCollectionValue().keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ItemStack itemStack = $this$forEach$iv$iv$iv.iterator();
        while (itemStack.hasNext()) {
            ItemStack it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = itemStack.next();
            boolean bl = false;
            NeuInternalName it = (NeuInternalName)element$iv$iv;
            boolean bl2 = false;
            if (NeuItems.INSTANCE.getItemStackOrNull(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            itemStack = (ItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.func_82833_r();
            Intrinsics.checkNotNullExpressionValue(string, "getDisplayName(...)");
            collection.add(StringsKt.replace$default(StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null), " ", "_", false, 4, null));
        }
        return (List)destination$iv$iv;
    }

    @HandleEvent
    public final void onTick() {
        this.compareInventory();
        this.updateGain();
    }

    private final void compareInventory() {
        if (lastAmountInInventory == -1) {
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        int currentlyInInventory = this.countCurrentlyInInventory();
        int diff = currentlyInInventory - lastAmountInInventory;
        if (diff != 0 && diff > 0) {
            this.gainItems(diff);
        }
        lastAmountInInventory = currentlyInInventory;
    }

    private final void updateGain() {
        if (recentGain != 0 && System.currentTimeMillis() > lastGainTime + (long)1500) {
            recentGain = 0;
            this.updateDisplay();
        }
    }

    private final void gainItems(int amount) {
        itemAmount += (long)amount;
        if (System.currentTimeMillis() > lastGainTime + (long)1500) {
            recentGain = 0;
        }
        lastGainTime = System.currentTimeMillis();
        recentGain += amount;
        this.updateDisplay();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        block0: {
            Intrinsics.checkNotNullParameter(event2, "event");
            Renderable renderable2 = display;
            if (renderable2 == null) break block0;
            Renderable it = renderable2;
            boolean bl = false;
            RenderUtils.renderRenderable$default(RenderUtils.INSTANCE, SkyHanniMod.feature.misc.getCollectionCounterPos(), it, "Collection Tracker", false, 4, null);
        }
    }

    private static final Unit onCommandRegistration$lambda$2$lambda$1() {
        if (internalName == null) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "/shtrackcollection <item name> [goal amount]", false, 2, null);
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Stopped collection tracker.", false, null, false, false, null, 62, null);
            INSTANCE.resetData();
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$2(BaseBrigadierBuilder $this$registerBrigadier) {
        void name$iv;
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Tracks your collection gain over time");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        String string = "args";
        ArgumentType argument$iv = BrigadierArguments.INSTANCE.greedyString();
        SuggestionProvider<Object> suggestions$iv = null;
        boolean $i$f$arg = false;
        if (!StringUtils.INSTANCE.hasWhitespace((String)name$iv)) {
            ((BrigadierBuilder)$this$registerBrigadier).internalArg((String)name$iv, argument$iv, suggestions$iv, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>((String)name$iv){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                    void args2;
                    Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                    BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                    String argumentName$iv = this.$name;
                    boolean $i$f$of = false;
                    BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                    BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u242_u24lambda_u240 = $this$internalArg;
                    boolean bl = false;
                    $this$onCommandRegistration_u24lambda_u242_u24lambda_u240.callback(new Function1<ArgContext, Unit>((BrigadierArgument<String>)args2){
                        final /* synthetic */ BrigadierArgument<String> $args;
                        {
                            this.$args = $args;
                        }

                        public final void invoke(ArgContext $this$callback) {
                            Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
                            String string = $this$callback.getArg(this.$args);
                            Intrinsics.checkNotNullExpressionValue(string, "getArg(...)");
                            String[] stringArray = new String[]{" "};
                            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
                            boolean $i$f$toTypedArray = false;
                            Collection thisCollection$iv = $this$toTypedArray$iv;
                            CollectionTracker.access$command(CollectionTracker.INSTANCE, thisCollection$iv.toArray(new String[0]));
                        }
                    });
                }
            });
        } else {
            Pair<String, String> pair = StringUtils.INSTANCE.splitLastWhitespace((String)name$iv);
            String literalNames$iv = pair.component1();
            String argName$iv = pair.component2();
            String[] stringArray = new String[]{literalNames$iv};
            ((BrigadierBuilder)$this$registerBrigadier).literal(stringArray, (Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>)new Function1<BrigadierBuilder<LiteralArgumentBuilder<Object>>, Unit>(argName$iv, argument$iv, suggestions$iv){
                final /* synthetic */ String $argName;
                final /* synthetic */ ArgumentType $argument;
                final /* synthetic */ SuggestionProvider $suggestions;
                {
                    this.$argName = $argName;
                    this.$argument = $argument;
                    this.$suggestions = $suggestions;
                }

                public final void invoke(BrigadierBuilder<LiteralArgumentBuilder<Object>> $this$literal) {
                    Intrinsics.checkNotNullParameter($this$literal, "$this$literal");
                    $this$literal.internalArg(this.$argName, this.$argument, this.$suggestions, (Function1)new Function1<BrigadierBuilder<RequiredArgumentBuilder<Object, String>>, Unit>(this.$argName){
                        final /* synthetic */ String $argName;
                        {
                            this.$argName = $argName;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$internalArg) {
                            void args2;
                            Intrinsics.checkNotNullParameter($this$internalArg, "$this$internalArg");
                            BrigadierArgument.Companion companion = BrigadierArgument.Companion;
                            String argumentName$iv = this.$argName;
                            boolean $i$f$of = false;
                            BrigadierArgument<String> brigadierArgument = new BrigadierArgument<String>(argumentName$iv, String.class);
                            BrigadierBuilder<RequiredArgumentBuilder<Object, String>> $this$onCommandRegistration_u24lambda_u242_u24lambda_u240 = $this$internalArg;
                            boolean bl = false;
                            $this$onCommandRegistration_u24lambda_u242_u24lambda_u240.callback(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            });
        }
        $this$registerBrigadier.simpleCallback(CollectionTracker::onCommandRegistration$lambda$2$lambda$1);
        return Unit.INSTANCE;
    }

    private static final Unit updateDisplay$lambda$4(String $format, String $goal, Ref.ObjectRef $gainText, List $this$horizontal) {
        Intrinsics.checkNotNullParameter($format, "$format");
        Intrinsics.checkNotNullParameter($goal, "$goal");
        Intrinsics.checkNotNullParameter($gainText, "$gainText");
        Intrinsics.checkNotNullParameter($this$horizontal, "$this$horizontal");
        NeuInternalName neuInternalName = internalName;
        if (neuInternalName != null) {
            NeuInternalName it = neuInternalName;
            boolean bl = false;
            RenderableCollectionUtils.addItemStack$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, NeuItems.INSTANCE.getItemStack(it), false, 0.0, 6, null);
        }
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$horizontal, itemName + " collection: \u00a7e" + $format + $goal + ' ' + (String)$gainText.element, 0.0, null, null, 14, null);
        return Unit.INSTANCE;
    }

    private static final boolean countCurrentlyInInventory$lambda$5(ItemStack it) {
        Intrinsics.checkNotNullParameter(it, "it");
        NeuInternalName name2 = ItemUtils.INSTANCE.getInternalName(it);
        if (Intrinsics.areEqual(internalName, CACTUS) && Intrinsics.areEqual(name2, CACTUS_GREEN)) {
            return true;
        }
        if (Intrinsics.areEqual(internalName, TIMITE) && (Intrinsics.areEqual(name2, YOUNGITE) || Intrinsics.areEqual(name2, OBSOLITE))) {
            return true;
        }
        return Intrinsics.areEqual(name2, internalName);
    }

    public static final /* synthetic */ void access$command(CollectionTracker $this, String[] args2) {
        $this.command(args2);
    }

    static {
        itemName = "";
        itemAmount = -1L;
        goalAmount = -1L;
        lastAmountInInventory = -1;
        lastGainTime = -1L;
        CACTUS = NeuInternalName.Companion.toInternalName("CACTUS");
        CACTUS_GREEN = NeuInternalName.Companion.toInternalName("INK_SACK-2");
        YOUNGITE = NeuInternalName.Companion.toInternalName("YOUNGITE");
        OBSOLITE = NeuInternalName.Companion.toInternalName("OBSOLITE");
        TIMITE = NeuInternalName.Companion.toInternalName("TIMITE");
    }
}

