/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.keybinds;

import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.features.misc.keybinds.Keybinds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u000e\u0010\n\u00a8\u0006\u0010"}, d2={"Lat/hannibal2/skyhanni/features/misc/keybinds/KeybindEditor;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/features/misc/keybinds/KeybindEditor$EditorKeybind;", "e", "", "original", "", "validate", "(Lat/hannibal2/skyhanni/features/misc/keybinds/KeybindEditor$EditorKeybind;Ljava/lang/String;)Ljava/util/List;", "Lat/hannibal2/skyhanni/features/misc/keybinds/Keybinds$Keybind;", "toKeybind", "(Lat/hannibal2/skyhanni/features/misc/keybinds/KeybindEditor$EditorKeybind;)Lat/hannibal2/skyhanni/features/misc/keybinds/Keybinds$Keybind;", "save", "EditorKeybind", "1.8.9"})
public final class KeybindEditor {
    @NotNull
    public final List<String> validate(@NotNull EditorKeybind e, @Nullable String original) {
        List<String> vanilla;
        Intrinsics.checkNotNullParameter(e, "e");
        List errors = new ArrayList();
        if (StringsKt.isBlank(e.getCombo())) {
            ((Collection)errors).add("Key combo cannot be empty");
        }
        if (StringsKt.isBlank(e.getCommand())) {
            ((Collection)errors).add("Command cannot be empty");
        }
        if (!((Collection)errors).isEmpty()) {
            return errors;
        }
        String normalized = Keybinds.INSTANCE.normalizeCombo(e.getCombo());
        if (Keybinds.INSTANCE.duplicateExists(normalized, original, e.getCommand())) {
            ((Collection)errors).add("Reuse: combo already bound");
        }
        if (!((Collection)(vanilla = Keybinds.INSTANCE.vanillaKeyConflicts(normalized))).isEmpty()) {
            ((Collection)errors).add("Uses Minecraft bound key(s): " + CollectionsKt.joinToString$default(vanilla, ", ", null, null, 0, null, null, 62, null));
        }
        return errors;
    }

    public static /* synthetic */ List validate$default(KeybindEditor keybindEditor, EditorKeybind editorKeybind, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return keybindEditor.validate(editorKeybind, string);
    }

    @NotNull
    public final Keybinds.Keybind toKeybind(@NotNull EditorKeybind e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return new Keybinds.Keybind(Keybinds.INSTANCE.normalizeCombo(((Object)StringsKt.trim((CharSequence)e.getCombo())).toString()), ((Object)StringsKt.trim((CharSequence)e.getCommand())).toString(), CollectionsKt.toSet((Iterable)e.getAllowedIslands()), e.getAllowOutsideSkyBlock());
    }

    @NotNull
    public final List<String> save(@NotNull EditorKeybind e, @Nullable String original) {
        Intrinsics.checkNotNullParameter(e, "e");
        List<String> errs = this.validate(e, original);
        if (!((Collection)errs).isEmpty()) {
            return errs;
        }
        Keybinds.INSTANCE.register(this.toKeybind(e));
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List save$default(KeybindEditor keybindEditor, EditorKeybind editorKeybind, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return keybindEditor.save(editorKeybind, string);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0012\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\rJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J>\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0016\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\rR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\r\"\u0004\b\u001e\u0010\u001fR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b \u0010\r\"\u0004\b!\u0010\u001fR(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010\u0010\"\u0004\b$\u0010%R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010&\u001a\u0004\b'\u0010\u0012\"\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/features/misc/keybinds/KeybindEditor$EditorKeybind;", "", "", "combo", "command", "", "Lat/hannibal2/skyhanni/data/IslandType;", "allowedIslands", "", "allowOutsideSkyBlock", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Z)V", "component1", "()Ljava/lang/String;", "component2", "component3", "()Ljava/util/Set;", "component4", "()Z", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Z)Lat/hannibal2/skyhanni/features/misc/keybinds/KeybindEditor$EditorKeybind;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getCombo", "setCombo", "(Ljava/lang/String;)V", "getCommand", "setCommand", "Ljava/util/Set;", "getAllowedIslands", "setAllowedIslands", "(Ljava/util/Set;)V", "Z", "getAllowOutsideSkyBlock", "setAllowOutsideSkyBlock", "(Z)V", "1.8.9"})
    public static final class EditorKeybind {
        @NotNull
        private String combo;
        @NotNull
        private String command;
        @NotNull
        private Set<IslandType> allowedIslands;
        private boolean allowOutsideSkyBlock;

        public EditorKeybind(@NotNull String combo, @NotNull String command2, @NotNull Set<IslandType> allowedIslands, boolean allowOutsideSkyBlock) {
            Intrinsics.checkNotNullParameter(combo, "combo");
            Intrinsics.checkNotNullParameter(command2, "command");
            Intrinsics.checkNotNullParameter(allowedIslands, "allowedIslands");
            this.combo = combo;
            this.command = command2;
            this.allowedIslands = allowedIslands;
            this.allowOutsideSkyBlock = allowOutsideSkyBlock;
        }

        public /* synthetic */ EditorKeybind(String string, String string2, Set set, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                IslandType[] islandTypeArray = new IslandType[]{IslandType.ANY};
                set = SetsKt.mutableSetOf(islandTypeArray);
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            this(string, string2, set, bl);
        }

        @NotNull
        public final String getCombo() {
            return this.combo;
        }

        public final void setCombo(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.combo = string;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        public final void setCommand(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.command = string;
        }

        @NotNull
        public final Set<IslandType> getAllowedIslands() {
            return this.allowedIslands;
        }

        public final void setAllowedIslands(@NotNull Set<IslandType> set) {
            Intrinsics.checkNotNullParameter(set, "<set-?>");
            this.allowedIslands = set;
        }

        public final boolean getAllowOutsideSkyBlock() {
            return this.allowOutsideSkyBlock;
        }

        public final void setAllowOutsideSkyBlock(boolean bl) {
            this.allowOutsideSkyBlock = bl;
        }

        @NotNull
        public final String component1() {
            return this.combo;
        }

        @NotNull
        public final String component2() {
            return this.command;
        }

        @NotNull
        public final Set<IslandType> component3() {
            return this.allowedIslands;
        }

        public final boolean component4() {
            return this.allowOutsideSkyBlock;
        }

        @NotNull
        public final EditorKeybind copy(@NotNull String combo, @NotNull String command2, @NotNull Set<IslandType> allowedIslands, boolean allowOutsideSkyBlock) {
            Intrinsics.checkNotNullParameter(combo, "combo");
            Intrinsics.checkNotNullParameter(command2, "command");
            Intrinsics.checkNotNullParameter(allowedIslands, "allowedIslands");
            return new EditorKeybind(combo, command2, allowedIslands, allowOutsideSkyBlock);
        }

        public static /* synthetic */ EditorKeybind copy$default(EditorKeybind editorKeybind, String string, String string2, Set set, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = editorKeybind.combo;
            }
            if ((n & 2) != 0) {
                string2 = editorKeybind.command;
            }
            if ((n & 4) != 0) {
                set = editorKeybind.allowedIslands;
            }
            if ((n & 8) != 0) {
                bl = editorKeybind.allowOutsideSkyBlock;
            }
            return editorKeybind.copy(string, string2, set, bl);
        }

        @NotNull
        public String toString() {
            return "EditorKeybind(combo=" + this.combo + ", command=" + this.command + ", allowedIslands=" + this.allowedIslands + ", allowOutsideSkyBlock=" + this.allowOutsideSkyBlock + ')';
        }

        public int hashCode() {
            int result2 = this.combo.hashCode();
            result2 = result2 * 31 + this.command.hashCode();
            result2 = result2 * 31 + ((Object)this.allowedIslands).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.allowOutsideSkyBlock);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EditorKeybind)) {
                return false;
            }
            EditorKeybind editorKeybind = (EditorKeybind)other;
            if (!Intrinsics.areEqual(this.combo, editorKeybind.combo)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.command, editorKeybind.command)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.allowedIslands, editorKeybind.allowedIslands)) {
                return false;
            }
            return this.allowOutsideSkyBlock == editorKeybind.allowOutsideSkyBlock;
        }

        public EditorKeybind() {
            this(null, null, null, false, 15, null);
        }
    }
}

